<?php get_header(); ?>

	<div id="wp-content">
		
		<div id="wp-content-pri">

			<?php if (have_posts()) : ?>

			<div class="post">
				<h2><?php _e('Search Results'); ?></h2>
				<p>Your search for <strong><?php echo wp_specialchars($s, 1); ?></strong> returned the following results:</p>

				<?php while (have_posts()) : the_post(); ?>

				<h3 id="post-<?php the_ID(); ?>"><a href="<?php the_permalink() ?>" rel="bookmark" title="Permanent Link to <?php the_title(); ?>"><?php the_title(); ?></a></h3>
				<div class="content-entry-meta">
					<p>
					<span class="content-entry-meta-category"><?php the_category(', ') ?></span>
					&nbsp;
					<span class="content-entry-meta-date"><?php the_time('F jS, Y') ?></span>
					&nbsp;
					<span class="content-entry-meta-comments"><?php comments_popup_link('Leave a comment', '1 comment', '% comments'); ?></span>
					<?php edit_post_link('Edit', ' | ', ''); ?>
					</p>
				</div>

				<?php endwhile; ?>

				<div id="post-navigation-bot">
					<div class="prev"><?php previous_posts_link('Next Entries &raquo;') ?></div>
					<div class="next"><?php next_posts_link('&laquo; Previous Entries') ?></div>
				</div>
			</div>

				<?php else : ?>

			<div class="post">
				<h2>No Results</h2>
				<p>Unfortunately your search for <strong><?php echo wp_specialchars($s, 1); ?></strong> returned no results.</p>
				<p>Please enter a different search term below, or alternatively browse throught the <a href="<?php echo get_settings('home'); ?>/archives/">archives</a>.</p>
				<?php $noresults = true; ?>
				<?php include (TEMPLATEPATH . '/searchform.php'); ?>
				<?php edit_post_link('Edit Page', '<p style="clear:both;">', '</p>'); ?>
			</div>

			<?php endif; ?>

		</div>

		<?php get_sidebar(); ?>

<?php get_footer(); ?>