<?php
// WP Ajax Connector Framework 1.3a
// Author: Nico Berlee
//
// The WP Ajax Connector comes with four files.
// acf.js which is the client side javascript and
// acf.php which is the backend for acf.js
// acf-search.php which is the instant search backend
// acf-comment.php which is the instant comment backend based on wp-comments-post.php WP 2.2
// acf-functions.php which plugs into WordPress..
//
// All files are released under GPL
//

//
// Credits for the panel go to theundersigned.net
//

$WPACF_title = "WP Ajax Connector Framework";
$WPACF_options = array (
	array(	"name" => "WP Ajax Connector Framework",
			"description" => "If disabled, page load will be handled the traditional way. Instant Search, Instant Comment and Client Side caching will be also disabled.",
			"id" => "WPACF_enable",
			"type" => "select",
			"std" => "Enabled",
			"options" => array("Enabled", "Disabled")),

	array(	"name" => "WP Ajax Client side caching ",
			"description" => "Warning: Only enable this when you are absolutely sure you are not changing theme files in the future.<br />For more details see ReadMe.txt",
			"id" => "WPACF_ClientCache",
			"type" => "select",
			"std" => "Disabled",
			"options" => array("Disabled", "Enabled")),

	array(	"name" => "Instant Search",
			"description" => "If disabled, the Search box will not show.",
			"id" => "WPACF_search",
			"type" => "select",
			"std" => "Enabled",
			"options" => array("Enabled", "Disabled")),

	array(	"name" => "Instant Comment",
			"description" => "If disabled, adding comments will be handled the traditional way.",
			"id" => "WPACF_comment",
			"type" => "select",
			"std" => "Enabled",
			"options" => array("Enabled", "Disabled")),

	array(	"name" => "Loading Image",
			"description" => "Displays a image when loading a page",
			"id" => "WPACF_LoadImage",
			"type" => "select",
			"std" => "Enabled",
			"options" => array("Enabled", "Disabled")),

	array(	"name" => "Loading text",
			"description" => "Displays the text when loading a page, it will be below the picture if enabled.<br />Leave it blank if you don't want text to be displayed",
			"id" => "WPACF_LoadText",
			"type" => "text",
			"std" => ""),
);

function WPACF_add_admin() {

	global $WPACF_title, $WPACF_options;

	if ( $_GET['page'] == basename(__FILE__) ) {
	
		if ( 'save' == $_REQUEST['action'] ) {

				foreach ($WPACF_options as $value) {
					if( isset( $_REQUEST[ $value['id'] ] ) ) { update_option( $value['id'], htmlentities($_REQUEST[ $value['id'] ]) ); } else { delete_option( $value['id'] ); } }

				header("Location: themes.php?page=".basename(__FILE__)."&saved=true");
				die;

		} else if( 'reset' == $_REQUEST['action'] ) {

			foreach ($WPACF_options as $value) {
				delete_option( $value['id'] ); }

			header("Location: themes.php?page=".basename(__FILE__)."&reset=true");
			die;

		}
	}

    add_theme_page($WPACF_title." Options", "WP ACF Options", 'edit_themes', basename(__FILE__), 'WPACF_admin');

}

function WPACF_admin() {

	global $WPACF_title, $WPACF_options;

	if ( $_REQUEST['saved'] ) echo '<div id="message" class="updated fade"><p><strong>'.$WPACF_title.' settings saved.</strong></p></div>';
	if ( $_REQUEST['reset'] ) echo '<div id="message" class="updated fade"><p><strong>'.$WPACF_title.' settings reset.</strong></p></div>';
	
?>
<div class="wrap">
<h2><?php echo $WPACF_title; ?> settings</h2>

<form method="post">

<table class="optiontable">

<?php foreach ($WPACF_options as $value) { 
	
if ($value['type'] == "text") { ?>
		
<tr valign="top"> 
	<th scope="row"><?php echo $value['name']; ?>:</th>
	<td>
		<input name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" type="<?php echo $value['type']; ?>" value="<?php if ( get_option( $value['id'] ) != "") { echo stripslashes( get_option( $value['id'] ) ); } else { echo $value['std']; } ?>" />
		<?php if ( $value['description']) { echo "<br />".$value['description'];} ?>
	</td>
</tr>

<?php } elseif ($value['type'] == "select") { ?>

	<tr valign="top"> 
		<th scope="row"><?php echo $value['name']; ?>:</th>
		<td>
			<select name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>">
				<?php foreach ($value['options'] as $WPACF_option) { ?>
				<option<?php if ( get_option( $value['id'] ) == $WPACF_option) { echo ' selected="selected"'; } elseif ($WPACF_option == $value['std']) { echo ' selected="selected"'; } ?>><?php echo $WPACF_option; ?></option>
				<?php } ?>
			</select>
			<?php if ( $value['description']) { echo "<br />".$value['description'];} ?>
		</td>
	</tr>

<?php 
} 
}
?>

</table>

<p class="submit">
<input name="save" type="submit" value="Save changes" />	
<input type="hidden" name="action" value="save" />
</p>
</form>
<form method="post">
<p class="submit">
<input name="reset" type="submit" value="Reset" />
<input type="hidden" name="action" value="reset" />
</p>
</form>

<?php
}

function WPACF_header_enable() { ?>
    <script type="text/javascript"><!--
	var sessid="<?php echo session_id(); ?>";
	var baseurl="<?php bloginfo('url'); ?>";
	var themeurl="<?php bloginfo('template_directory'); ?>/";
	var sort="<?php echo (is_home() ? "home" : (is_single() ? "article" : (is_page() ? "page" : (is_archive() ? "article" : 0)))); ?>";
    --></script>
    <script type="text/javascript" src="<?php bloginfo('template_directory'); ?>/acf.js"></script>
<?php }

function WPACF_footer_enable() { 
    if (strstr($_SERVER['HTTP_USER_AGENT'], "MSIE")) echo '    <!--[if IE]><iframe id="navfix" height="0"></iframe><![endif]-->';
?>
    <script type="text/javascript"><!--
	WPACF_Init();
    --></script>
<?php }

function WPACF_loader() { ?>
    <div id="ACFLoader"><p>
    <?php
	if ( get_option("WPACF_LoadImage") != "Disabled" ) { echo '<img src="'; bloginfo("template_url"); echo '/acfloader.gif" alt="ACF loading animated gif" width="16" height="16" />';}
	if ( get_option("WPACF_LoadText") ) echo "&nbsp;&nbsp;".stripslashes(get_option("WPACF_LoadText"));
    ?>
    </p></div>
<?php }


if ( get_option("WPACF_enable") != "Disabled" ) {
    if ( get_option("WPACF_LoadImage") != "Disabled" || get_option("WPACF_LoadText")) add_action('wp_footer', 'WPACF_loader');

    add_action('wp_head',   'WPACF_header_enable');
    add_action('wp_footer', 'WPACF_footer_enable');

    if (!session_is_registered("from_frontpage")) {
	ini_set('session.use_trans_sid', true);
	ini_set('url_rewriter.tags', '');
	session_start();
	session_register("from_frontpage");
	$_SESSION['home'] = get_option('home');
    }
}

add_action('admin_menu', 'WPACF_add_admin'); 

?>
