<?php
// WP Ajax Connector Framework 1.3a
// Author: Nico Berlee
//
// The WP Ajax Connector comes with four files.
// acf.js which is the client side javascript and
// acf.php which is the backend for acf.js
// acf-search.php which is the instant search backend
// acf-comment.php which is the instant comment backend based on wp-comments-post.php WP 2.2
// acf-functions.php which plugs into WordPress..
//
// All files are released under GPL
//

session_start();
if (!session_is_registered('from_frontpage')) 
{
    header('Content-Type: text/xml');
    die('<?xml version="1.0" encoding="UTF-8"?><ajax><refresh/></ajax>');	// Asks Javascript kindly to refresh the page so the session could be renewed, and you are sure the trafic is originating from your site
}

if ($_SERVER["REQUEST_METHOD"] == "POST") 
{
    define('WP_USE_THEMES', false);
    require('../../../wp-config.php');

    $parseajax = true;

    if ( !$user->ID ) :
        setcookie('comment_author_' . COOKIEHASH, $comment->comment_author, time() + 30000000, COOKIEPATH, COOKIE_DOMAIN);
        setcookie('comment_author_email_' . COOKIEHASH, $comment->comment_author_email, time() + 30000000, COOKIEPATH, COOKIE_DOMAIN);
        setcookie('comment_author_url_' . COOKIEHASH, clean_url($comment->comment_author_url), time() + 30000000, COOKIEPATH, COOKIE_DOMAIN);
    endif;

    header('Content-Type: text/xml');
    echo '<?xml version="1.0" encoding="UTF-8"?><ajax><element id="comments"><![CDATA[';
    include(dirname(__FILE__)."/acf-comment.php");
    die(']]></element></ajax>');
}

// Change the {4} if the Wordpress address (URL) is differs from the Blog address (URL)
// See readme.txt for more information
//$baseurl = preg_replace('%(/.[^/]*){4}\?.*$%', '/', $_SERVER['REQUEST_URI']);
$baseurl = WPACF_StripURL($_SESSION['home'] . "/");
$basepath = realpath(str_replace($_SERVER['SCRIPT_NAME'], '', $_SERVER['SCRIPT_FILENAME']));

// Get the request and strip the ? and everything after it, filter ../ from the request, make it a canonicalized path and check if it is a real file
if ($_REQUEST['g'])
{
    $requestfile = realpath($basepath . $baseurl . WPACF_StripURL('/' . $_REQUEST['g']));
    $requestfile = file_exists($requestfile) ? $requestfile : "";
}
// Because the Javascript is redirecting everything to this php, downloads need to be redirected back
// According to the W3C Working Draft 302 responses are supported by XMLHttpRequest, but only Firefox
// supports it.
if ($requestfile || 					// A real file or
    preg_match('/^feed|^files/', $_REQUEST['g']) )	// files redirected by .htaccess
{
    header('Content-Type: text/xml');
    die ("<?xml version=\"1.0\" encoding=\"UTF-8\"?><ajax><redir>". $_SESSION['home'] . "/" .strip_tags($_REQUEST['g']) . "</redir></ajax>");
}
$_SERVER['PHP_SELF'] = $baseurl;
if (preg_match('/^[_a-z]+?=[\\d]+?$/i', $_REQUEST['g']))
{
    $parameter = split("=",$_REQUEST['g']);
    $GLOBALS[$parameter[0]] = $parameter[1];		// non permalinks
    $_SERVER['REQUEST_URI'] = "?".$_REQUEST['g'];
} 
else 
{
    $_SERVER['REQUEST_URI'] = $baseurl . $_REQUEST['g'];
}

define('WP_USE_THEMES', false);
require('../../../wp-blog-header.php');

If (get_option("WPACF_enable") == "Disabled") die("Ajax request are disabled!");
If (get_option("WPACF_ClientCache") == "Enabled") WPACF_ClientCache();

header('Content-Type: text/xml');

echo "<?xml version=\"1.0\" encoding=\""; echo bloginfo('charset')."\" ?>";
echo "<ajax>";
if (isset($_REQUEST['s']))
    WPACF_addelement(dirname(__FILE__)."/acf-search.php","instantsearch");
else 
    WPACF_refreshelements();

echo "</ajax>";
// Commented out for the poor dailup user, every bit helps :) 
//echo "<!-- parsetime: "; timer_stop(1,3); echo " seconds ({$wpdb->num_queries} queries) -->";

function WPACF_addelement($template, $classid)
{
    global $post, $posts, $paged;
    echo "<element id=\"$classid\"><![CDATA[";
    $parseajax = true;
    if (!empty($template)) include($template);
    echo "]]></element>";
}

function WPACF_refreshelements()
{
    define('RIGHT_SIDEBAR', TEMPLATEPATH."/col-right.php");
    define('LATEST', TEMPLATEPATH."/latest.php");
    define('TOPNAV', TEMPLATEPATH."/topnav.php");
    define('SLIDETEXT', TEMPLATEPATH."/slidetext.php");

    $oldsort = $_REQUEST['sort'];
    echo "<title>"; if (function_exists("Seo_Title")){ Seo_Title();}else{ wp_title(' '); if(wp_title(' ', false)) { echo " | "; }  bloginfo('name');} echo "</title>";
    $newsort = (is_404() ? "404" : (is_home() ? "home" : (is_single() ? "single" : (is_page() ? "page" : (is_archive() ? "archive" : (is_tag() ? "tag" : 0))))));

    // There are a number of different page layouts depending on what content is
    // displayed. Depending on what page is currently displayed an what the new
    // page will be, div blogs needs to be refreshed.
    // This basically what the switch logic below does.

    switch ($newsort)
    {
	case "404":
	    status_header(200);
	    WPACF_addelement(get_404_template(), "col-main");
	    return;
	break;
	case "home":
	    $newsort = "home";
	    WPACF_addelement(get_home_template(), "col-main");
	break;
	case "page":
	    $newsort = "page";
	    if (is_attachment()) add_filter('the_content', 'prepend_attachment');
	    WPACF_addelement(get_page_template(), "col-main");
	break;
	case "single":
	    $newsort = "article";
	    if (is_attachment()) add_filter('the_content', 'prepend_attachment');
	    WPACF_addelement(get_single_template(), "col-main");
	break;
	case "archive":
	    $newsort = "article";
	    WPACF_addelement(get_archive_template(), "col-main");
	break;
	case "tag":
	    $newsort = "article";
	    WPACF_addelement(TEMPLATEPATH."/tag.php", "col-main");
    }

    switch ($oldsort)
    {
	case "article":
	    switch ($newsort)
	    {
		case "home":
		    WPACF_addelement(LATEST, "latest");
		break;
		case "page":
		    WPACF_addelement(RIGHT_SIDEBAR, "col-right");
		    WPACF_addelement(TOPNAV, "topnav");
		break;
	    }
	break;
	case "home":
	    switch ($newsort)
	    {
		case "page":
		    WPACF_addelement(RIGHT_SIDEBAR, "col-right");
		    WPACF_addelement(TOPNAV, "topnav");
		case "article":
		    WPACF_addelement(SLIDETEXT, "latest");
		break;
	    }
	break;
	case "page":
	    switch ($newsort)
	    {
		case "home":
		    WPACF_addelement(LATEST, "latest");
		case "article":
		case "page":
		    WPACF_addelement(TOPNAV, "topnav");
		    WPACF_addelement(RIGHT_SIDEBAR, "col-right");
		break;
	    }
	break;
	case "undefined":	//Javascript is confused, because strings have been reset... this happens when a page is refreshed pressed back in the browser or loaded from a bookmark. 
	    WPACF_addelement(TOPNAV, "topnav");
	    WPACF_addelement(RIGHT_SIDEBAR, "col-right");
	    switch ($newsort)
	    {
		case "home":
		    WPACF_addelement(LATEST, "latest");
		break;
		case "page":
		case "article":
		    WPACF_addelement(SLIDETEXT, "latest");
		break;
	    }
	break;
    }
    echo "<sort>$newsort</sort>";
}

function WPACF_ClientCache()
{
    //Cache control is set to never use local cache,
    //its going to revalidate if the content is renewed.
    //no-cache doesn't work ok with IE7
    header("Cache-Control: must-revalidate, max-age=0");
    
    //Expire in two days.. It doesn't matter if it passed the validation...
    //This is used to ensure that theme changes are committed
    $seconds = 60 * 60 * 24 * 2;
    header("Expires: ".gmdate("D, d M Y H:i:s", time() + $seconds)." GMT");
    
    global $wpdb, $post;
    $now = current_time('mysql', 1);
    if (is_page() && !isset($_REQUEST['s']))
    {
        $wp_last_modified = mysql2date('D, d M Y H:i:s', $wpdb->get_var("SELECT post_modified_gmt FROM $wpdb->posts WHERE post_modified_gmt <= '$now' AND post_status = 'static' ORDER BY post_modified_gmt DESC LIMIT 1"), 0).' GMT';
    } 
    else
	$wp_last_modified = mysql2date('D, d M Y H:i:s', get_lastpostmodified('GMT'), 0).' GMT';

    // Make a timestamp for our most recent modification...
    $wp_modified_timestamp = strtotime($wp_last_modified);

    if (is_single() && !isset($_REQUEST['s']))
    {
        $wp_last_modified_comment = mysql2date('D, d M Y H:i:s', $wpdb->get_var("SELECT comment_date_gmt FROM $wpdb->comments WHERE comment_post_ID = $post->ID AND comment_date_gmt <= '$now' ORDER BY comment_date_gmt DESC LIMIT 1"), 0).' GMT';
	if ($wp_last_modified_comment != " GMT" && strtotime($wp_last_modified_comment) > $wp_modified_timestamp)
	{
	    $wp_last_modified = $wp_last_modified_comment;
	    $wp_modified_timestamp = strtotime($wp_last_modified);
	}
    }
    $wp_etag = '"'.md5($wp_last_modified).'"';
    header("Last-Modified: $wp_last_modified");
    header("ETag: $wp_etag");

    // Support for Conditional GET
    if (isset($_SERVER['HTTP_IF_NONE_MATCH']))
    {
        $client_etag = stripslashes($_SERVER['HTTP_IF_NONE_MATCH']);
	$client_etag = stripslashes($client_etag); 		// <-- Because it does not remove \\\\ at once... bad proxies can cause \\\\
    }
    else 
	$client_etag = false;

    $client_last_modified = trim($_SERVER['HTTP_IF_MODIFIED_SINCE']);
    // Guess what, Internet Explorer Last-Modified is not compliant to the RFC...
    $client_last_modified = strstr($client_last_modified, ";") ? substr($client_last_modified, 0, strpos($client_last_modified, ";")) : $client_last_modified;
    // If string is empty, return 0. If not, attempt to parse into a timestamp
    $client_modified_timestamp = $client_last_modified ? strtotime($client_last_modified) : 0;

    if (($client_modified_timestamp == $wp_modified_timestamp) || ($client_etag == $wp_etag))
    {
	        status_header( 304 );
	        exit;
    }
} 
function WPACF_StripURL($url)
{
    if (preg_match('%(https?://[-A-Z0-9.]+)?(/[^?]*)%i', $url, $regs))
    {
	if (strpos($regs[2], '..') != false ) die();
	return $regs[2];
    } 
}
?>
