<?php
// WP Ajax Connector Framework 1.3a
// Author: Nico Berlee
//
// The WP Ajax Connector comes with four files.
// acf.js which is the client side javascript and
// acf.php which is the backend for acf.js
// acf-search.php which is the instant search backend
// acf-comment.php which is the instant comment backend based on wp-comments-post.php WP 2.2
// acf-functions.php which plugs into WordPress..
//
// All files are released under GPL
//

if ( !$parseajax ) exit;

$close = "]]></element></ajax>";

if (get_option("WPACF_comment") == "Disabled" || get_option("WPACF_enable") == "Disabled") die ("Instant Comment is disabled!".$close);
$id = (int) $_POST['comment_post_ID'];
$post->comment_status = get_option('default_comment_status');

$comment_post_ID = (int) $_POST['comment_post_ID'];

$status = $wpdb->get_row("SELECT post_status, comment_status FROM $wpdb->posts WHERE ID = '$comment_post_ID'");

if ( empty($status->comment_status) ) {
	do_action('comment_id_not_found', $comment_post_ID);
	exit;
} elseif ( 'closed' ==  $status->comment_status ) {
	do_action('comment_closed', $comment_post_ID);
	wp_die( __('Sorry, comments are closed for this item.').$close );
} elseif ( 'draft' == $status->post_status ) {
	do_action('comment_on_draft', $comment_post_ID);
	exit;
}

$comment_author       = trim(strip_tags($_POST['author']));
$comment_author_email = trim($_POST['email']);
$comment_author_url   = trim($_POST['url']);
$comment_content      = trim($_POST['comment']);

// If the user is logged in
$user = wp_get_current_user();
if ( $user->ID ) {
	$comment_author       = $wpdb->escape($user->display_name);
	$comment_author_email = $wpdb->escape($user->user_email);
	$comment_author_url   = $wpdb->escape($user->user_url);
	if ( current_user_can('unfiltered_html') ) {
		if ( wp_create_nonce('unfiltered-html-comment_' . $comment_post_ID) != $_POST['_wp_unfiltered_html_comment'] ) {
			kses_remove_filters(); // start with a clean slate
			kses_init_filters(); // set up the filters
		}
	}
} else {
	if ( get_option('comment_registration') )
		wp_die( __('Sorry, you must be logged in to post a comment.').$close );
}

$comment_type = '';

if ( get_option('require_name_email') && !$user->ID ) {
	if ( 6 > strlen($comment_author_email) || '' == $comment_author )
		wp_die( __('Error: please fill the required fields (name, email).').$close );
	elseif ( !is_email($comment_author_email))
		wp_die( __('Error: please enter a valid email address.').$close );
}

if ( '' == $comment_content )
	wp_die( __('Error: please type a comment.').$close );

$commentdata = compact('comment_post_ID', 'comment_author', 'comment_author_email', 'comment_author_url', 'comment_content', 'comment_type', 'user_ID');

$comment_id = wp_new_comment( $commentdata );

$comment = get_comment($comment_id);

if ( empty($comment_author) ) {
      $comments = $wpdb->get_results("SELECT * FROM $wpdb->comments WHERE comment_post_ID = '{$comment_post_ID}' AND comment_approved = '1' ORDER BY comment_date");
} else {
      $author_db = $wpdb->escape($comment_author);
      $email_db  = $wpdb->escape($comment_author_email);
      $comments = $wpdb->get_results("SELECT * FROM $wpdb->comments WHERE comment_post_ID = '{$comment_post_ID}' AND ( comment_approved = '1' OR ( comment_author = '$author_db' AND comment_author_email = '$email_db' AND comment_approved = '0' ) ) ORDER BY comment_date");
}
include(TEMPLATEPATH . '/comments.php');
?>
