<?php
// search.php
// Deficient theme for WordPress
// Copyright (C) 2006 Ciro Principe
// Distributed under the terms of the GNU General Public License v2

get_header();
?>

<div id="content">

<h3 class="archive_title"><?php _e('Search Results','def'); ?> &raquo;</h3>
<?php if (have_posts()) : while (have_posts()) : the_post(); ?>

	<div class="post_marker">
		<h2 id="post-<?php the_ID(); ?>" class="thepost"><a href="<?php the_permalink() ?>" rel="bookmark" title="<?php _e('Permanent Link','def'); ?>: <?php the_title(); ?>"><?php the_title(); ?></a></h2>
		<p class="thepost"><?php the_time('j F Y'); echo ' @ '; the_time('H:i'); ?> | <?php the_category(', '); ?> | <?php comments_popup_link( __('No Comments','def'), __('1 Comment','def'), __('% Comments','def') ); ?>
		<?php edit_post_link($link = __('Edit','def'), $before = ' | ', $after = ''); ?></p>
	</div>
	<div class="data"><?php the_excerpt(); ?></div>

<?php endwhile; ?>

<div class="wp-pagenavi">
	<?php if(function_exists('wp_pagenavi')) { wp_pagenavi(); } // plugin wp_pagenavi ?>
</div>

<?php else: ?>
	<p><?php _e('Sorry, nothing found.','def'); ?></p>
<?php endif; ?>

</div> <!-- end of #content -->
<?php include('sideright.php'); ?>

<?php get_footer(); ?>