<?php
// comments.php
// Deficient theme for WordPress
// Copyright (C) 2006 Ciro Principe
// Distributed under the terms of the GNU General Public License v2

// Do not delete these lines
if ('comments.php' == basename($_SERVER['SCRIPT_FILENAME']))
	die ( __('Please do not load this page directly. Thanks!') );

if (!empty($post->post_password)) { // if there's a password
	if ($_COOKIE['wp-postpass_' . COOKIEHASH] != $post->post_password) {  // and it doesn't match the cookie
		?>
	<div id="bottom_box">
		<p class="info" style="text-align: center;"><?php _e("This post is password protected. Enter the password to view comments"); ?></p>
	</div>
		<?php
		return;
	}
}

?>

<div id="bottom_box">

		<div class="div_break_box"></div> <!-- hack for 'visual' padding -->
	<div id="thecomments">

		<h4 id="comments" class="comments"><?php comments_number( __('No Comments','def'), __('1 Comment','def'), __('% Comments','def') );?></h4>
		<?php if ($comments) : ?>

		<ol class="commentlist">

			<?php foreach ($comments as $comment) : ?>
			<li id="comment-<?php comment_ID() ?>">

				<?php if(function_exists('comment_favicon')) { comment_favicon('<img src="', '" alt="favatar" class="favatar" />'); } // plugin favatars ?>

				<span class="posted">&nbsp;<cite><?php comment_author_link() ?></cite>
				:: <a href="<?php the_permalink() ?>#comment-<?php comment_ID() ?>" title="<?php _e('Permalink to the comment', 'def'); ?>"><?php comment_date('j M Y') ?> @ <?php comment_time() ?></a> ::
				<?php edit_comment_link( __('[e]','def'),'',''); ?></span>
				<?php comment_text() ?>
			</li>
			<?php endforeach; /* end for each comment */ ?>

		</ol>
		<?php endif; ?>
	</div> <!-- end of #thecomments -->

		<div class="div_break_box"></div> <!-- hack for 'visual' padding -->

	<div id="postcomment">
		<?php if ('open' == $post-> comment_status) : // check if comments need registration and if user is logged in
			if ( get_option('comment_registration') && !$user_ID ) : ?>
				<h4 class="comments"><a href="<?php echo get_option('siteurl'); ?>/wp-login.php?redirect_to=<?php the_permalink(); ?>"><?php _e('Log in','def'); ?></a> <?php _e('to post a comment.','def'); ?></h4>
			<?php else : ?>
				<h4 id="respond" class="comments"><?php _e('Leave a Reply','def'); ?></h4>
				<div style="text-align: justify;"><em><?php echo 'XHTML: ' . allowed_tags(); ?></em></div>
				<form action="<?php echo get_option('siteurl'); ?>/wp-comments-post.php" method="post" id="commentform">
					<p><textarea name="comment" id="comment" cols="50" rows="10"></textarea></p>
					<?php if ( $user_ID ) : ?>
						<p><?php _e('Logged in as','def'); ?> <a href="<?php echo get_option('siteurl'); ?>/wp-admin/profile.php"><?php echo $user_identity; ?></a>. <a href="<?php echo get_option('siteurl'); ?>/wp-login.php?action=logout" title="<?php _e('Log out of this account','def');?>"><?php _e('Logout','def'); ?> &#187;</a></p>
					<?php else : ?>
						<p><input type="text" name="author" id="author" value="<?php echo $comment_author; ?>" />
						<label for="author"><?php _e('Name','def'); ?></label></p>
						<p><input type="text" name="email" id="email" value="<?php echo $comment_author_email; ?>" />
						<label for="email"><?php _e('Email (will not be published)','def'); ?></label></p>
						<p><input type="text" name="url" id="url" value="<?php echo $comment_author_url; ?>" />
						<label for="url"><?php _e('Website','def'); ?></label></p>
					<?php endif; ?>
					<p><input name="submitComment" type="submit" id="submitComment" value="<?php _e('Submit','def'); ?>" />
					<input type="hidden" name="comment_post_ID" value="<?php echo $id; ?>" /></p>
					<?php do_action('comment_form', $post->ID); ?>
				</form>
			<?php endif; // if registration required and not logged in ?>
		<?php else : // if comments are closed ?>
			<h4 class="comments"><?php _e('Comments are closed','def'); ?></h4>
		<?php endif; ?>
	</div> <!--end of #postcomment -->

		<div class="div_break_box"></div> <!-- hack for 'visual' padding -->

	<div style="clear: both;"></div>

</div> <!-- end of #bottom_box -->