<?php get_header();?>

	<?php if (have_posts()) : ?>

		 <?php $post = $posts[0]; // Hack. Set $post so that the_date() works. ?>
		<?php /* If this is a category archive */ if (is_category()) { ?>				
		<h2>Archive for '<?php echo single_cat_title(); ?>' </h2>
		
 	  <?php /* If this is a daily archive */ } elseif (is_day()) { ?>
		<h2>Daily Archive <?php the_time('F jS, Y'); ?></h2>
		
	 <?php /* If this is a monthly archive */ } elseif (is_month()) { ?>
		<h2>Monthly Archive <?php the_time('F, Y'); ?></h2>

		<?php /* If this is a yearly archive */ } elseif (is_year()) { ?>
		<h2>Yearly Archive <?php the_time('Y'); ?></h2>
		
	  <?php /* If this is a search */ } elseif (is_search()) { ?>
		<h2>Search result</h2>
		
	  <?php /* If this is an author archive */ } elseif (is_author()) { ?>
		<h2>Author Archive</h2>

		<?php /* If this is a paged archive */ } elseif (isset($_GET['paged']) && !empty($_GET['paged'])) { ?>
		<h2>Archive</h2>

		<?php } ?>


	<?php while (have_posts()) : the_post(); ?>

<div class="post" id="post-<?php the_ID(); ?>">
	<h2 class="posttitle"><a href="<?php the_permalink() ?>" rel="bookmark"><?php the_title(); ?></a></h2>

	<div class="postinfo">
		<?php the_date(); ?>  
		&bull; <?php _e("by"); ?> <?php the_author(); ?>
		<?php edit_post_link(__('Edit','&bull;','')); ?>
	</div>
	
	<div class="story">
		<?php if(is_archive() || is_search()) : ?>
			<?php the_excerpt() ?>
		<?php else : ?>
			<?php the_content("Continue reading " . the_title('', '', false)); ?>
		 	<?php wp_link_pages(); ?>
		<?php endif; ?>
	</div>
	
	
	<div class="postinfo">
		<?php if ( comments_open() ) : ?>
			<a href="<?php comments_link(); ?>" title="Write comment to <?php the_title(); ?>">
			 <?php comments_number('Post Comment','1 Comment','% Comments'); ?></a>
		<?php else : ?>
			<?php _e('Comments'); ?> <?php _e('closed'); ?>
		<?php endif; ?>
			&bull; <?php the_category(', ') ?> 
	</div>

</div>
	<?php endwhile; else: ?>
		<h2>Not Found</h2>
		<div class="story"><?php _e('Sorry, no posts matched your criteria.'); ?></div>
	<?php endif; ?>


	<?php posts_nav_link('<div class="none"> &bull; </div>', 
			'<div class="right">Next &raquo;</div>', 
			'<div class="left">&laquo; Previous</div>'); ?>



<?php get_footer(); ?>
