<?php

// if comments are closed and is page then do nothing
if( !comments_open() && is_page() ) {

} else { ?>

<div id="comments">

	<h2><?php _e('Comments'); if ( comments_open() ) : ?><a href="#postComment" title="leave a comment">&raquo;</a><?php endif; ?></h2>

	<?php

	global $usePassword;
	
	if ( $usePassword ) { ?>
	
		<p>Enter your password to view comments</p>
		
 	<?php
 	
	} else if ( $comments ) {

		$commentCount = 1;

		?>

		<dl>

		<?php foreach ($comments as $comment) : 
		
			$class = bm_author_highlight();

		?>

			<dt class="<?php echo $class; ?>">
			<a href="#<?php comment_ID() ?>"><?php echo $commentCount."."; ?></a> <?php comment_author_link() ?> - <?php 
			comment_date();
			edit_comment_link( "[Edit]" ); ?>
			</dt>
			<dd class="<?php echo $class; ?>">

			<?php

			comment_text();

			$commentCount ++; ?>
			</dd>

		<?php endforeach; ?>

		</dl>

	<?php } else { // If there are no comments yet

		if ( comments_open() ) {

			echo "<p>no comments yet - be the first?</p>";
			
		} else {
		
			echo "<p>Sorry comments are closed for this entry</p>";

		}
		
	} ?>
	
</div>

	<?php if ( comments_open() && !$usePassword ) { ?>

<form action="<?php echo get_settings('siteurl'); ?>/wp-comments-post.php" method="post" id="postComment">

	<input type="hidden" name="comment_post_ID" value="<?php echo $post->ID; ?>" />
	<input type="hidden" name="redirect_to" value="<?php echo wp_specialchars($_SERVER['REQUEST_URI']); ?>" />

	<label for="comment">message</label><br /><textarea name="comment" id="comment" tabindex="1"></textarea>

	<label for="author">name</label><input name="author" id="author" value="<?php echo $comment_author; ?>" tabindex="2" />
	<label for="email">email</label><input name="email" id="email" value="<?php echo $comment_author_email; ?>" tabindex="3" />
	<label for="url">url</label><input name="url" id="url" value="<?php echo $comment_author_url; ?>" tabindex="4" />
		
	<input class="button" name="submit" id="submit" type="submit" tabindex="5" value="say it!" />
	<?php do_action('comment_form', $post->ID); ?>
</form>

<?php

		}
	}
	
?>
