<?php



////////////////////////////////////////////////////////////////////////////////

// Recent Comments

////////////////////////////////////////////////////////////////////////////////

function mw_recent_comments(

	$no_comments = 10,

	$show_pass_post = false,

	$title_length = 100, 	// shortens the title if it is longer than this number of chars

	$author_length = 30,	// shortens the author if it is longer than this number of chars

	$wordwrap_length = 50, // adds a blank if word is longer than this number of chars

	$type = 'all', 	// Comments, trackbacks, or both?

	$format = '<li>%date%: <a href="%permalink%" title="%title%">%title%</a> (von %author_full%)</li>',

	$date_format = 'd.m',

	$none_found = '<li>No Comments.</li>',	// None found

	$type_text_pingback = 'Pingback of',

	$type_text_trackback = 'Trackback of',

	$type_text_comment = 'of'



	) {



	//Language...

	$mwlang_anonymous = 'Anonym'; // Anonymous

	$mwlang_authorurl_title_before = 'Website of &lsaquo;';

	$mwlang_authorurl_title_after = '&rsaquo; visit';





    global $wpdb;



    $request = "SELECT ID, comment_ID, comment_content, comment_author, comment_author_url, comment_date, post_title, comment_type

				FROM $wpdb->comments LEFT JOIN $wpdb->posts ON $wpdb->posts.ID=$wpdb->comments.comment_post_ID

				WHERE post_status IN ('publish','static')";



	switch($type) {

		case 'all':

			// add nothing

			break;

		case 'comment_only':

			//

			$request .= "AND $wpdb->comments.comment_type='' ";

			break;

		case 'trackback_only':

			$request .= "AND ( $wpdb->comments.comment_type='trackback' OR $wpdb->comments.comment_type='pingback' ) ";

			break;

	 default:

 		//

			break;



	}



	if (!$show_pass_post) $request .= "AND post_password ='' ";



	$request .= "AND comment_approved = '1' ORDER BY comment_ID DESC LIMIT $no_comments";



	$comments = $wpdb->get_results($request);

    $output = '';

	if ($comments) {

    	foreach ($comments as $comment) {



			// Permalink to post/comment

			$loop_res['permalink'] = get_permalink($comment->ID). '#comment-' . $comment->comment_ID;



			// Title of the post

			$loop_res['post_title'] = stripslashes($comment->post_title);

			$loop_res['post_title'] = wordwrap($loop_res['post_title'], $wordwrap_length, ' ' , 1);



			if (strlen($loop_res['post_title']) >= $title_length) {

				$loop_res['post_title'] = substr($loop_res['post_title'], 0, $title_length) . '&#8230;';

			}



			// Author's name only

        	$loop_res['author_name'] = stripslashes($comment->comment_author);

			$loop_res['author_name'] = wordwrap($loop_res['author_name'], $wordwrap_length, ' ' , 1);



			if ($loop_res['author_name'] == '') $loop_res['author_name'] = $mwlang_anonymous;

			if (strlen($loop_res['author_name']) >= $author_length) {

				$loop_res['author_name'] = substr($loop_res['author_name'], 0, $author_length) . '&#8230;';

			}



			// Full author (link, name)

			$author_url = $comment->comment_author_url;

			if (empty($author_url)) {

				$loop_res['author_full'] = $loop_res['author_name'];

			} else {

				$loop_res['author_full'] = '<a href="' . $author_url . '" title="' . $mwlang_authorurl_title_before . $loop_res['author_name'] . $mwlang_authorurl_title_after . '">' . $loop_res['author_name'] . '</a>';

			}



/*

			// Comment excerpt

			$comment_excerpt = strip_tags($comment->comment_content);

			$comment_excerpt = stripslashes($comment_excerpt);

			if (strlen($comment_excerpt) >= $comment_length) {

				$comment_excerpt = substr($comment_excerpt, 0, $comment_length) . '...';

			}



*/



			// Comment type

			if ( $comment->comment_type == 'pingback' ) {

				$loop_res['comment_type'] = $type_text_pingback;

			} elseif ( $comment->comment_type == 'trackback' ) {

				$loop_res['comment_type'] = $type_text_trackback;

			} else {

				$loop_res['comment_type'] = $type_text_comment;

			}



			// Date of comment

			$loop_res['comment_date'] = mysql2date($date_format, $comment->comment_date);



			// Output element

			$element_loop = str_replace('%permalink%', $loop_res['permalink'], $format);

			$element_loop = str_replace('%title%', $loop_res['post_title'], $element_loop);

			$element_loop = str_replace('%author_name%', $loop_res['author_name'], $element_loop);

			$element_loop = str_replace('%author_full%', $loop_res['author_full'], $element_loop);

			$element_loop = str_replace('%date%', $loop_res['comment_date'], $element_loop);

			$element_loop = str_replace('%type%', $loop_res['comment_type'], $element_loop);





			$output .= $element_loop . "\n";





		} //foreach



		$output = convert_smilies($output);



	} else {

		$output .= $none_found;

    }



    echo $output;

}



if ( function_exists('register_sidebars') )

    register_sidebars(3, array(

        'before_widget' => '<div id="%1$s" class="widget %2$s">',

        'after_widget' => '</ul></div>',

        'before_title' => '<h2>',

        'after_title' => '</h2><ul>',

    ));





function cattag_tagcloud(

	$min_scale = 8,

	$max_scale = 30,

	$min_include = 0,

	$sort_by = 'NAME_ASC',

	$exclude = '',

	$element = '<li><a rel="tag" href="%link%" title="%description% (%count%)" style="font-size:%size%pt">%title%<sub style="font-size:60%; color:#ccc;">%count%</sub></a></li>'

	)

{

	$sort_by = strtoupper($sort_by);



	// *************************************************

	// Get categories and put into array

	// *************************************************

	

	// If sorting is by name, descending...

	$sort_list_cats = 'asc';

	if ($sort_by == 'NAME_DESC') $sort_list_cats = 'desc';



	$cats = list_cats(true, 'all', 'name', $sort_list_cats, '', false, false, true, true, true, true, true, false, true, '', '', $exclude, false);

	$catsArray = explode("\n", $cats);



	// *************************************************

	// Create clean array out of the cat array	

	// *************************************************

	$resultArray = array();

	$count = 0;

	foreach ($catsArray as $cat_loop) {

		if (! empty($cat_loop)) {

			// Get link

			eregi("a href=\"(.+)\" ", $cat_loop, $regs);

			$resultArray[$count]['link'] = $regs[1];



			// Get title

			eregi("title=\"(.+)\"", $cat_loop, $regs);

			$resultArray[$count]['title'] = $regs[1];



			// Get name and number of cat entries

			$cat_loop = trim(strip_tags($cat_loop));

			eregi("(.*) \(([0-9]+)\)$", $cat_loop, $regs);

			$resultArray[$count]['name'] = $regs[1];

			$resultArray[$count]['count'] = $regs[2];



			if ($regs[2] >= $min_include) {

				// Set the min and max number of cat entries

				if ( ( ! isset($count_min) ) or ($regs[2] < $count_min) ) { $count_min = $regs[2]; }

				if ( ( ! isset($count_max) ) or ($regs[2] > $count_max) ) { $count_max = $regs[2]; }				

			} else {

				// Remove array element if the number of posts in this category is smaller than the min value

				// We do this now since the number of posts was not available at the beginning of this foreach loop...

				unset($resultArray[$count]);

			}

			$count++;

		}

	}



	// *************************************************

	// Sort...

	// *************************************************

	switch ($sort_by) {

		case 'WEIGHT_ASC':

			$resultArray = cattag_aux_sortmddata($resultArray,'count','ASC','num');

			break;

		case 'WEIGHT_DESC':

			$resultArray = cattag_aux_sortmddata($resultArray,'count','DESC','num');

			break;

		case 'RANDOM':

			shuffle($resultArray);

			break;

	}



	// *************************************************

	// Scale font

	// *************************************************

	$spread_current = $count_max - $count_min; 

	$spread_default = $max_scale - $min_scale;

	if ($spread_current <= 0) { $spread_current = 1; };

	if ($spread_default <= 0) { $spread_default = 1; }

	$scale_factor = $spread_default / $spread_current;





	// *************************************************

	// Create result

	// *************************************************

	$result = '';

	foreach ($resultArray as $result_loop) {

		// font scaling		

		$final_font = (int) (($result_loop['count'] - $count_min) * $scale_factor + $min_scale);



		// Generate output element

		$element_loop = str_replace('%link%', $result_loop['link'], $element);

		$element_loop = str_replace('%title%', $result_loop['name'], $element_loop);

		$element_loop = str_replace('%description%', $result_loop['title'], $element_loop);

		$element_loop = str_replace('%count%', $result_loop['count'], $element_loop);

		$element_loop = str_replace('%size%', $final_font, $element_loop);

		$result .= $element_loop . "\n";

	}



	$result = "\n" . '<!-- Tag Cloud, generated by \'Category Tagging Plugin\' - http://sw-guide.de/ -->' . "\n" . $result; // Please do not remove this line.

	return $result;

}





function cattag_related_posts(

	$limit = 5,

	$display_posts = true,

	$display_pages = false,

	$before = '<li>',

	$after = '</li>',

	$notfound = false,

	$order = 'DATE_DESC',

	$exclude_ids = ''

) {



	global $wpdb,$post;	// WordPress globals



	// *************************************************

	// Prepare selection of posts and pages

	// *************************************************

	if ( ($display_posts === true) AND ($display_pages === true) ) {

		// Display both posts and pages

		$poststatus = "IN('publish', 'static')";

	} elseif ( ($display_posts === true) AND ($display_pages === false) ) {

		// Display posts only

		$poststatus = "= 'publish'";

	} elseif ( ($display_posts === false) AND ($display_pages === true) ) {

		// Display pages only

		$poststatus = "= 'static'";

	} else {

		// Nothing can be displayed

		return $notfound;

	}



	// *************************************************

	// Prepare exlusion of categories

	// *************************************************	

	$exclude_ids = preg_replace('/[^0-9,]/','',$exclude_ids);	// remove everything except 0-9 and comma

	$exclude_ids_sql = '';

	if ($exclude_ids != '') {

		$exclude_ids_sql = 'AND post2cat.category_id NOT IN(' . $exclude_ids . ')';

	}



	// *************************************************

	// Put the category IDs into a comma-separated string

	// *************************************************

	$catsList = '';

	$count = 0;

	foreach((get_the_category()) as $loop_cat) { 

		// Add category id to list

		if ($count == 0) {

			$catsList = $loop_cat->cat_ID;

		} else {

			$catsList = $catsList . ',' . $loop_cat->cat_ID;

		}

		$count++;

	}



	// *************************************************

	// Prepare order

	// *************************************************

	switch (strtoupper($order)) {

		case 'RANDOM':

			$order_by = 'RAND()';

			break;

		default:	// 'DATE_DESC'

			$order_by = 'posts.post_date DESC';

	}



	// *************************************************

 	// SQL query. DISTINCT is here for getting a unique result without duplicates

 	// *************************************************

	$queryresult = $wpdb->get_results("SELECT DISTINCT posts.ID, posts.post_title

							FROM $wpdb->posts posts, $wpdb->post2cat post2cat

							WHERE posts.ID <> $post->ID

							AND posts.post_status $poststatus

							AND posts.ID = post2cat.post_id

							AND post2cat.category_id IN($catsList)

							$exclude_ids_sql

							ORDER BY $order_by 

							LIMIT $limit

							");



	// *************************************************

	// Return the related posts

	// *************************************************

	$result = '';

	if (is_array($queryresult)) {

		foreach($queryresult as $tag_loop) {

			$result .= $before . '<a href="' . get_permalink($tag_loop->ID) . '" title="' . $tag_loop->post_title . '" id="post-' . $tag_loop->ID . '">' . $tag_loop->post_title . '</a>' . $after . "\n";

		}

		$result = "\n" . '<!-- Related Posts, generated by \'Category Tagging Plugin\' - http://www.sw-guide.de/ -->' . "\n" . $result; // Please do not remove this line.

		return $result;

	} else {

		return $notfound;

	}



}



//##############################################################################

// Additional functions

//##############################################################################

function cattag_aux_sortmddata($array, $by, $order, $type){

	// Sort a one level deep multidimensional array

	// Source: http://de2.php.net/manual/de/function.array-multisort.php#61334

	//		$array: the array you want to sort

	//		$by: the associative array name that is one level deep

	//				example: name

	//		$order: ASC or DESC

	//		$type: num or str



	$sortby = "sort$by"; //This sets up what you are sorting by

	

	$firstval = current($array); //Pulls over the first array

	

	$vals = array_keys($firstval); //Grabs the associate Arrays

	

	foreach ($vals as $init){

		$keyname = "sort$init";

		$$keyname = array();

	}

	//This was strange because I had problems adding

	//Multiple arrays into a variable variable

	//I got it to work by initializing the variable variables as arrays

	//Before I went any further

	

	foreach ($array as $key => $row) {

		foreach ($vals as $names) {

			$keyname = "sort$names";

			$test = array();

			$test[$key] = $row[$names];

			$$keyname = array_merge($$keyname,$test);

		}

	}

	

	//This will create dynamic mini arrays so that I can perform

	//the array multisort with no problem

	//Notice the temp array... I had to do that because I

	//cannot assign additional array elements to a

	//varaiable variable           

	

	if ($order == "DESC") {   

		if ($type == "num") {

			array_multisort($$sortby,SORT_DESC, SORT_NUMERIC,$array);

		} else {

			array_multisort($$sortby,SORT_DESC, SORT_STRING,$array);

		}

	} else {

		if ($type == "num") {

			array_multisort($$sortby,SORT_ASC, SORT_NUMERIC,$array);

		} else {

			array_multisort($$sortby,SORT_ASC, SORT_STRING,$array);

		}

	}

	

	//This just goed through and asks the additional arguments

	//What they are doing and are doing variations of

	//the multisort

	return $array;

}



