<?php
/*
Template Name: contact
*/
?>
<?php get_header(); ?>
		<div id="content">
			<?php if (have_posts()) : ?>

	<?php while (have_posts()) : the_post(); ?>
		<div class="post">
		<?php
		//validate email adress
		function is_valid_email($email)
		{
  			return (eregi ("^([a-z0-9_]|\\-|\\.)+@(([a-z0-9_]|\\-)+\\.)+[a-z]{2,4}$", $email));
		}

		//clean up text
		function clean($text)
		{
			return stripslashes($text);
		}

		//encode special chars (in name and subject)
		function encodeMailHeader ($string, $charset = 'UTF-8')
		{
    		return sprintf ('=?%s?B?%s?=', strtoupper ($charset),base64_encode ($string));
		}

		$aq_name    = (!empty($_POST['aq_name']))    ? $_POST['aq_name']    : "";
		$aq_email   = (!empty($_POST['aq_email']))   ? $_POST['aq_email']   : "";
		$aq_url     = (!empty($_POST['aq_url']))     ? $_POST['aq_url']     : "";
		$aq_subject = (!empty($_POST['aq_subject'])) ? $_POST['aq_subject'] : "";
		$aq_message = (!empty($_POST['aq_message'])) ? $_POST['aq_message'] : "";

		$aq_subject = clean($aq_subject);
		$aq_message = clean($aq_message);
		$error_msg = "";
		$send = 0;

		if (!empty($_POST['submit'])) {			
			$send = 1;
			if (empty($aq_name) || empty($aq_email) || empty($aq_message)) {
				$error_msg.= "<p><strong>Please fill in all required fields.</strong></p>\n";
				$send = 0;
			}
			if (!is_valid_email($aq_email)) {
				$error_msg.= "<p><strong>Your email adress failed to validate.</strong></p>\n";
				$send = 0;
			}
		}
		if (!$send) { ?>

			<h2 class="post-title"><?php the_title(); ?></h2>
			<p><?php edit_post_link(); ?></p>
			<div class="post-content">
			<?php
				the_content();
				echo $error_msg;
			?>
			<table width="100%" cellspacing="2" cellpadding="5" class="editform">

			<form method="post" action="<?php echo "http://" . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']; ?>" id="contactform">
				<fieldset>
				<?php
				aq_th( "Name" );
				aq_input( "aq_name", "text", "", $aq_name );	
				aq_cth();
				aq_th( "Email" );
				aq_input( "aq_email", "text", "", $aq_email );					
				aq_cth();
				aq_th( "Subject" );
				aq_input( "aq_subject", "text", "", $aq_subject );	
				aq_cth();
				aq_th( "Website" );
				aq_input( "aq_url", "text", "", $aq_url );	
				aq_cth();
				aq_th( "Message" );
				aq_input( "aq_message", "textarea", "", $aq_message );	
				aq_cth();
				aq_th( "Ready ?" );
				aq_input( "submit", "submit", "", "Send Message" );
				aq_cth( "" );
				?>					
				</fieldset>
			</form>
			</table>
			</div>
		<?php
		} else {

			$displayName_array	= explode(" ",$aq_name);
			$displayName = htmlentities(utf8_decode($displayName_array[0]));

			$header  = "MIME-Version: 1.0\n";
			$header .= "Content-Type: text/plain; charset=\"utf-8\"\n";
			$header .= "From:" . encodeMailHeader($aq_name) . "<" . $aq_email . ">\n";
			$email_subject	= "[" . get_settings('blogname') . "] " . encodeMailHeader($aq_subject);
			$email_text		= "From......: " . $aq_name . "\n" .
							  "Email.....: " . $aq_email . "\n" .
							  "Url.......: " . $aq_url . "\n\n" .
							  $aq_message;

			if (@mail(get_settings('admin_email'), $email_subject, $email_text, $header)) {
				echo "<h2>Hey " . $displayName . ",</h2><p>thanks for your message! I'll get back to you as soon as possible.</p>";
			}
		}
		?>

	<?php endwhile; ?>

<?php endif; ?>

	</div>
	</div>

<?php get_sidebar(); ?>
<?php get_footer(); ?>