<?php
	require(dirname(__FILE__)."/../../../../wp-blog-header.php");

	// check to see if the user has enabled gzip compression in the WordPress admin panel
	if ( !get_settings('gzipcompression') and !ini_get('zlib.output_compression') and ini_get('output_handler') != 'ob_gzhandler' and ini_get('output_handler') != 'mb_output_handler' ) {
		ob_start('ob_gzhandler');
	}

	// The headers below tell the browser to cache the file and also tell the browser it is JavaScript.
	header("Cache-Control: public");
	header("Pragma: cache");

	$offset = 60*60*24*60;
	$ExpStr = "Expires: ".gmdate("D, d M Y H:i:s",time() + $offset)." GMT";
	$LmStr = "Last-Modified: ".gmdate("D, d M Y H:i:s",filemtime(__FILE__))." GMT";

	header($ExpStr);
	header($LmStr);
	header('Content-Type: text/javascript; charset: UTF-8');
?>
Livesearch = Class.create();

Livesearch.prototype = {
	initialize: function(father, url, pars, searchtext) {
		this.father = father;
		this.url = url;
		this.pars = pars;
		this.searchtext = searchtext;
		
		this.searchfield = 's';
		this.loaditem = 'search-loading';
		this.resetitem = 'search-reset';
		this.contentitem = 'search-results';
		this.lastsearch = '';
		this.t = null;
		
		Event.observe(window, "load", this.onLoading.bindAsEventListener(this));
	},
	
	onLoading: function() {
		if ( $(this.father) ) {
			$(this.father).update('<input type="text" id="'+this.searchfield+'" name="'+this.searchfield+'" class="searchinput" autocomplete="off" value="'+this.searchtext+'" /><div id="'+this.resetitem+'"></div><div id="'+this.loaditem+'"></div><div id="'+this.contentitem+'"></div>');
			$(this.resetitem).hide();
			$(this.loaditem).hide();
       		$(this.contentitem).hide();
			this.focusListener = this.onInputFocus.bindAsEventListener(this);
			this.blurListener = this.onInputBlur.bindAsEventListener(this);
			this.keyupListener = this.readyLivesearch.bindAsEventListener(this);
			Event.observe(this.searchfield, 'focus', this.focusListener);
			Event.observe(this.searchfield, 'blur', this.blurListener);
			Event.observe(this.searchfield, 'keyup', this.keyupListener);
		}
	},

	onInputFocus: function() {
		if ($F(this.searchfield) == this.searchtext) {
			$(this.searchfield).value = '';
		}
	},

	onInputBlur: function() {
		if ($F(this.searchfield) == '') {
			$(this.searchfield).value = this.searchtext;
		}
	},

	readyLivesearch: function(event) {
		var code = event.keyCode;
		var currentLivesearch = this;
		if (code == Event.KEY_ESC || ((code == Event.KEY_DELETE || code == Event.KEY_BACKSPACE) && $F(this.searchfield) == '')) {
			this.resetLivesearch();
		} else if (code != Event.KEY_LEFT && code != Event.KEY_RIGHT && code != Event.KEY_DOWN && code != Event.KEY_UP && code != Event.KEY_RETURN) {
			if (this.t) { clearTimeout(this.t) };
	        this.t = setTimeout(this.doLivesearch.bind(this), 400);
		}
	},

	searchComplete: function() {
		Effect.Fade(this.loaditem, { duration: .1});
		Effect.Appear(this.resetitem, { duration: .8});
		Effect.Appear(this.contentitem, {duration: .5});
		Event.observe(this.resetitem, 'click', this.resetLivesearch.bindAsEventListener(this));
	},

	doLivesearch: function() {
		if ($F(this.searchfield) == this.lastsearch) return;
		$(this.resetitem).hide();
		Effect.Appear(this.loaditem, {duration: .1});
		new Ajax.Updater(
			this.contentitem,
			this.url,
			{
				method: 'get',
				parameters: this.pars + encodeURIComponent($F(this.searchfield)),
				onComplete: this.searchComplete.bind(this)
		});
		this.lastsearch = $F(this.searchfield);
	},

	resetLivesearch: function() {
		Effect.Fade(this.resetitem, { duration: .7 });
		Effect.Fade(this.contentitem, {duration: .5});
		this.lastsearch = '';
		$(this.searchfield).value = this.searchtext;
	}
}

FastInit.addOnLoad( function() { new Livesearch('searchform', '<?php bloginfo('template_url'); ?>/livesearch.php', 'searchquery=', '<?php _e('Type and Wait to Search','unnamed'); ?>'); } );