<?php
/*
Template Name: Sitemap 
*/
?>

<?php get_header(); ?>

<div id="left">
<div id="lside">

<div id="blogc" class="blogc">
<?php if (have_posts()) : ?>
			
<?php while (have_posts()) : the_post(); ?>

			
<h1 class="main_title"><a href="<?php the_permalink() ?>" rel="bookmark" title="Permanent Link to <?php the_title(); ?>"><?php the_title(); ?></a></h1>

<div class="post">		
<p><strong><a href="<?php bloginfo('url'); ?>" alt="<?php bloginfo('name'); ?>">Home</a></strong></p>

<div class="clog">All internal pages:</div>
<ul><?php wp_list_pages('title_li='); ?></ul>

<div class="clog">All internal blog posts:</div>
<ul>
<?php $archive_query = new WP_Query('showposts=500'); while ($archive_query->have_posts()) : $archive_query->the_post(); ?>
<li><a href="<?php the_permalink() ?>" rel="bookmark" title="Permanent Link to <?php the_title(); ?>"><?php the_title(); ?></a> <strong><?php comments_number('0', '1', '%'); ?></strong></li>
<?php endwhile; ?></ul>

<div class="clog">Monthly archive pages:</div>
<ul><?php wp_get_archives('type=monthly'); ?></ul>

<div class="clog">Topical archive pages:</div>
<ul><?php wp_list_categories('title_li=0'); ?></ul>

<div class="clog">Available RSS Feeds:</div>
<ul>
<li><a href="<?php bloginfo('rdf_url'); ?>" alt="RDF/RSS 1.0 feed"><acronym title="Resource Description Framework">RDF</acronym>/<acronym title="Really Simple Syndication">RSS</acronym> 1.0 feed</a></li>
<li><a href="<?php bloginfo('rss_url'); ?>" alt="RSS 0.92 feed"><acronym title="Really Simple Syndication">RSS</acronym> 0.92 feed</a></li>
<li><a href="<?php bloginfo('rss2_url'); ?>" alt="RSS 2.0 feed"><acronym title="Really Simple Syndication">RSS</acronym> 2.0 feed</a></li>
<li><a href="<?php bloginfo('atom_url'); ?>" alt="Atom feed">Atom feed</a></li>
</ul>
</div>
<?php endwhile; endif; ?>
</div></div>			
<?php get_sidebar(); ?>
<?php get_footer(); ?>
</body>
</html>