<?php
function aq_extra_options($optionname,$stylesheet,$yesno) {
	if (get_option($optionname)==$yesno) {
		echo '		<link rel="stylesheet" type="text/css" media="screen" href="',bloginfo("template_url"),"/",$stylesheet,'"/>'; 
	}
}
function aq_header() {
	$aq_modules = array("aq_color","aq_gloss","aq_himage","aq_reflect","aq_sidebar");
	$aq_color_db = get_option($aq_modules[0]);
	switch ($aq_color_db) {
		case 2:
			echo "		<link rel=\"stylesheet\" type=\"text/css\" href=\"",bloginfo("template_url"),"/style_red.css\" />";
			break;
		case 3:
			echo "		<link rel=\"stylesheet\" type=\"text/css\" href=\"",bloginfo("template_url"),"/style_orange.css\" />";
			break;
		case 4:
			echo "		<link rel=\"stylesheet\" type=\"text/css\" href=\"",bloginfo("template_url"),"/style_green.css\" />";
			break;
		case 5:
			echo "		<link rel=\"stylesheet\" type=\"text/css\" href=\"",bloginfo("template_url"),"/style_midnight.css\" />";
			break;
		case 6:
			echo "		<link rel=\"stylesheet\" type=\"text/css\" href=\"",bloginfo("template_url"),"/style_black.css\" />";
			break;
		default:
			NULL;
			break;
	}
	aq_extra_options("aq_gloss","gloss.css","y");
	aq_extra_options("aq_himage","header.css","n");
	aq_extra_options("aq_reflect","reflect.css","n");
	aq_extra_options("aq_sidebar","sidebar.css","n");
}
if ( function_exists('register_sidebars') )
	register_sidebars(1);

function mt_add_pages() {
    // Add a new menu under Options:
    add_theme_page('Customize aqLite', 'Customize aqLite', 8, 'aq_customize', 'mt_theme_page');
}
function check_value($option, $value, $tag) {
	$getoption 		= get_option($option);
	if ($getoption==$value) {
		if ($tag=="radio") {
			return "checked=\"checked\"";
		}
		elseif ($tag=="option") {
			return "selected=\"selected\"";
		}
	}
}
function aqlite_admin() {
	if (isset($_POST['info_update'])) {
		$color 		= $_POST["color"];
		$gloss 		= $_POST["gloss"];
		$himage 	= $_POST["himage"];
		$reflect	= $_POST["reflect"];
		$sbar		= $_POST["sidebar"];
			update_option('aq_color', $color);
			update_option('aq_gloss', $gloss);
			update_option('aq_himage', $himage);
			update_option('aq_reflect', $reflect);
			update_option('aq_sidebar', $sbar); ?>

	<div class="updated">
		<p><strong><?php _e('Your theme has been changed.', 'english') ?></strong></p>
	</div>
	<?php } ?>
	<style type="text/css">
		/* Because I really liked the look of K2's Options page, I decided to format this page in a similar way. 
		This mini-stylesheet was found in the source of that options page, so I'm using it here. */
		h3 {
			font: normal 1.8em Georgia;
			margin: 30px 0 0;
			color: #222;
		}

		small {
			color: #666;
		}
		
		.configstuff input[type=submit], #k2-blogornoblog, .configstuff select  {
			width: 300px;
		}

		.configstuff input[type=file] {
			width: 220px;
			background: none;
			border: none;
			padding: 0;
		}

		.configstuff input[type=checkbox] {
			margin-right: 8px;
		}

		.configstuff {
			width: 700px;
			margin: 0 auto;
			font-size: 1.1em;
		}
		
		table {
			margin: 0 auto;
			padding: 0;
			border-spacing: 0;
		}
		
		table tr td {
			height: 30px;
		}
		</style>
		<div class="configstuff">
			<small>Well, you found it, the aqLite customize page. This page lets you choose the diffrent options for this theme. If you want more options, and to allow your users to change it for themselves, you might want to look into using Aqueous+.</small>
		<form method="post">
			<table>
				<tr>
					<td colspan="2">
						<h3>Color</h3>
					</td>
				</tr>
				<tr>
					<td>
						<small>You can choose a color here if you want something other than the default blue to grace your entire blog.</small>
					<td>
						<select name="color">
							<option value ="1" <?php echo check_value("aq_color", 1, "option"); ?>>Blue (default)</option>
							<option value ="2" <?php echo check_value("aq_color", 2, "option"); ?>>Red</option>
							<option value ="3" <?php echo check_value("aq_color", 3, "option"); ?>>Orange</option>
							<option value ="4" <?php echo check_value("aq_color", 4, "option"); ?>>Green</option>
							<option value ="5" <?php echo check_value("aq_color", 5, "option"); ?>>Midnight</option>
							<option value ="6" <?php echo check_value("aq_color", 6, "option"); ?>>Black</option>
						</select>
					</td>
				</tr>
				<tr>
					<td colspan="2">
						<h3>Gloss</h3>
					</td>
				</tr>
				<tr>
					<td><small>When this is enabled, a transparent white overlay appears over the top half of the header; to enable, choose "on".</small></td><td> <input type="radio" name="gloss" value="y" id="ygloss" <?php echo check_value("aq_gloss", "y", "radio"); ?> /><label for="ygloss">On</label><input type="radio" name="gloss" value="n" id="ngloss" <?php echo check_value("aq_gloss", "n", "radio"); ?> /><label for="ngloss">Off</label></td>
				</tr>
				<tr>
					<td colspan="2">
						<h3>Header image</h3>
					</td>
				</tr>
				<tr>
					<td><small>The background that appears on the left of the header can be disabled choosing "off"</small> </td><td> <input type="radio" name="himage" value="y" id="yhimage" <?php echo check_value("aq_himage", "y", "radio"); ?> /><label for="yhimage">On</label><input type="radio" name="himage" value="n" id="nhimage" <?php echo check_value("aq_himage", "n", "radio"); ?> /><label for="nhimage">Off</label></p></td>
				</tr>
				<tr>
					<td colspan="2">
						<h3>Reflection</h3>
					</td>
				</tr>
				<tr>
					<td><small>If you want to disable the reflection under the header, you can choose "off" here.</small></td><td> <input type="radio" name="reflect" value="y" id="yreflect" <?php echo check_value("aq_reflect", "y", "radio"); ?> /><label for="yreflect">On</label><input type="radio" name="reflect" value="n" id="nreflect" <?php echo check_value("aq_reflect", "n", "radio"); ?> /><label for="nreflect">Off</label></p></td>
				</tr>
				<tr>
					<td colspan="2">
						<h3>Sidebar background</h3>
					</td>
				</tr>
				<tr>
					<td><small>The grey background on the sidebar. If you want it disabled, choose "off" here.</small></td><td> <input type="radio" name="sidebar" value="y" id="ysidebar" <?php echo check_value("aq_sidebar", "y", "radio"); ?> /><label for="ysidebar">On</label><input type="radio" name="sidebar" value="n" id="nsidebar" <?php echo check_value("aq_sidebar", "n", "radio"); ?> /><label for="nsidebar">Off</label></p></td>
				</tr>
			</table>
			<input type="hidden" name="info_update" />
			<p class="submit">
				<input type="submit" value="Save" />
			</p>
		</form>
		<p class="aligncenter"><strong>WARNING! Clicking the button below will reset your theme to default, and you will have to reinstall Aqueous Lite!</strong></p> <form method="post"><input type="submit" name="uninstall_aqlite" value="Reset" /></form>

<?php }
function mt_theme_page() {
	echo "<div class=\"wrap\"><h2>aqLite Options</h2>";
	if (isset($_POST["install_aqlite"])) {
		add_option('aq_color', '1', 'Color chosen for Aqueous Lite');
		add_option('aq_gloss', 'n', 'Gloss in the header for aqLite?');
		add_option('aq_himage', 'y', 'Show the header image in aqLite?');
		add_option('aq_reflect', 'y', 'Header reflection in aqLite?');
		add_option('aq_sidebar', 'y', 'Sidebar background in aqLite?');
		add_option('aq_is_installed', 'y', 'Proves aqLite is installed and working correctly.'); ?>
		<div class="updated">
			<p><strong><?php _e('Welcome to Aqueous Lite! Installation was successful.', 'english'); ?></strong></p>
		</div>
		<?php aqlite_admin();
	}
	elseif (isset($_POST["uninstall_aqlite"])) {
		delete_option('aq_color');
		delete_option('aq_gloss');
		delete_option('aq_himage');
		delete_option('aq_reflect');
		delete_option('aq_sidebar');
		delete_option('aq_is_installed');
		?>
		<div class="updated">
			<p><strong><?php _e('Thanks for trying Aqueous Lite.', 'english'); ?></strong></p>
		</div>
		<?php
	}

	elseif (get_option('aq_is_installed')==NULL) {
		echo '<p>Congratulations on your choice of Aqueous Lite! This theme has many options, but in order to use them, a few small changes have to be made to your database. Don\'t worry, it\'s very unlikely that a problem will arise from this change, in fact, most themes that use the database perform this without asking for your permission.</p><form method="post"><input type="submit" name="install_aqlite" value="Install aqLite now!" /></form>';
	}
	else {
		aqlite_admin();
	}
	echo "</div>";
}
add_action('admin_menu', 'mt_add_pages');
?>