<?php get_header(); ?>

<div id="main">
	<?php if (have_posts()) : ?>

	 <?php $post = $posts[0]; // Hack. Set $post so that the_date() works. ?>
	<?php /* If this is a category archive */ if (is_category()) { ?>				
		<h1><?php _e('Archives:'); ?> '<?php echo single_cat_title(); ?>'</h1>
		
 	  <?php /* If this is a daily archive */ } elseif (is_day()) { ?>
		<h1><?php _e('Archives:'); ?> <?php the_time('F jS, Y'); ?></h1>
		
	 <?php /* If this is a monthly archive */ } elseif (is_month()) { ?>
		<h1><?php _e('Archives:'); ?> <?php the_time('F, Y'); ?></h1>

		<?php /* If this is a yearly archive */ } elseif (is_year()) { ?>
		<h1><?php _e('Archives:'); ?> <?php the_time('Y'); ?></h1>
		
	  <?php /* If this is a search */ } elseif (is_search()) { ?>
		<h1><?php _e('Search:'); ?></h1>
		
	  <?php /* If this is an author archive */ } elseif (is_author()) { ?>
		<h1><?php _e('Author'); ?> <?php _e('Archives:'); ?></h1>

		<?php /* If this is a paged archive */ } elseif (isset($_GET['paged']) && !empty($_GET['paged'])) { ?>
		<h1>Blog <?php _e('Archives:'); ?></h1>

		<?php } ?>


		<div class="navigation">
			<div class="left"><?php posts_nav_link('','','&laquo; Previous Entries') ?></div><div class="right"><?php posts_nav_link('','Next Entries &raquo;','') ?></div>
		</div>

		<?php while (have_posts()) : the_post(); ?>
		<div class="post">
				<div class="date">
					<small><?php the_author('nickname'); ?>  &mdash;  <?php the_date(); ?>, <?php the_time(); ?></small>
				</div>	
				<h2 id="post-<?php the_ID(); ?>"><a href="<?php the_permalink() ?>" rel="bookmark" title="Permanent Link to <?php the_title(); ?>"><?php the_title(); ?></a></h2>
				
				<div class="entry">
					<?php the_excerpt() ?>
				</div>
				
				<div class="post_info">
					<small><?php _e("Filed under:"); ?> <?php the_category(', ', 'single'); ?> &mdash; <?php comments_popup_link(__('Comments (0)'), __('Comments (1)'), __('Comments (%)'), __('comments-link'), __('Sorry, the comment form is closed at this time.')); ?></small>
				</div>
				<!--
				<?php trackback_rdf(); ?>
				-->
		</div>
	
		<?php endwhile; ?>

		<div class="navigation">
			<div class="left"><?php posts_nav_link('','','&laquo; Previous Entries') ?></div><div class="right"><?php posts_nav_link('','Next Entries &raquo;','') ?></div>
		</div>
	
	<?php else : ?>

		<h2 class="center">Not Found</h2>
		<?php include (TEMPLATEPATH . '/searchform.php'); ?>

	<?php endif; ?>
		
	</div>


<?php get_sidebar(); ?>
<?php get_footer(); ?>