<?php

/*

Template Name: Single Entry Template

*/

?>



<?php get_header(); ?>



<div id="content">



<?php if (have_posts()) : while (have_posts()) : the_post(); ?>



<div class="post">



<h2><a href="<?php the_permalink() ?>" rel="bookmark" title="Permanent Link to <?php the_title(); ?>"><?php the_title(); ?></a></h2>



<div class="entry">

<?php the_content('<p>Read the rest of this entry &raquo;</p>'); ?>

<?php link_pages('<p><strong>Pages:</strong> ', '</p>', 'number'); ?>

</div>



</div>



<p class="alt">

This entry was posted

on <?php the_time('l, F jS, Y') ?> at <?php the_time() ?> 

and is filed under <?php the_category(', ') ?>.

You can follow any responses to this entry through the <?php comments_rss_link('RSS 2.0'); ?> feed. 



<?php if (('open' == $post-> comment_status) && ('open' == $post->ping_status)) {

// Both Comments and Pings are open ?>

You can <a href="#respond">leave a response</a>, or <a href="<?php trackback_url(true); ?>" rel="trackback">trackback</a> from your own site.



<?php } elseif (!('open' == $post-> comment_status) && ('open' == $post->ping_status)) {

// Only Pings are Open ?>

Responses are currently closed, but you can <a href="<?php trackback_url(true); ?> " rel="trackback">trackback</a> from your own site.



<?php } elseif (('open' == $post-> comment_status) && !('open' == $post->ping_status)) {

// Comments are open, Pings are not ?>

You can skip to the end and <a href="#respond">leave a response</a>. Pinging is currently not allowed.



<?php } elseif (!('open' == $post-> comment_status) && !('open' == $post->ping_status)) {

// Neither Comments, nor Pings are open ?>

Both comments and pings are currently closed.			



<?php } edit_post_link('Edit this entry','',''); ?>

</p>



<div class="navigation">

<div class="align-right"><?php next_post_link('%link &raquo;') ?></div>

<div class="align-left"><?php previous_post_link('&laquo; %link') ?></div>

</div>



</div> <!-- end of content div -->



<?php get_sidebar(); ?>



<?php comments_template(); ?>



<?php endwhile; ?>



<? else : ?>



<div class="post">

<h2>Post Not Found</h2>

<div class="entry">

<p>Sorry, no posts matched your criteria.</p>

</div>

</div>



<?php get_sidebar(); ?>



<?php endif; ?>



<?php get_footer(); ?>

