<?php
function barthelme_globalnav() {
	echo "<div id=\"globalnav\"><ul id=\"menu\">";
	if ( !is_home() || is_paged() ) { ?><li class="page_item home_page_item"><a href="<?php bloginfo('home') ?>" title="<?php echo wp_specialchars(get_bloginfo('name'), 1) ?>"><?php _e('Home', 'barthelme') ?></a></li><?php }
	$menu = wp_list_pages('title_li=&sort_column=post_title&echo=0');
	echo str_replace(array("\r", "\n", "\t"), '', $menu);
	echo "</ul></div>\n";
}

function barthelme_admin_hCard() {
	global $wpdb, $user_info;
	$user_info = get_userdata(1);
	echo '<span class="vcard"><a class="url fn n" href="' . $user_info->user_url . '"><span class="given-name">' . $user_info->first_name . '</span> <span class="family-name">' . $user_info->last_name . '</span></a></span>';
}

function barthelme_author_hCard() {
	global $wpdb, $authordata;
	echo '<span class="entry-author author vcard"><a class="url fn" href="' . get_author_link(false, $authordata->ID, $authordata->user_nicename) . '" title="View all posts by ' . $authordata->display_name . '">' . get_the_author() . '</a></span>';
}

function barthelme_body_class( $print = true ) {
	global $wp_query, $current_user;

	$c = array('wordpress');

	barthelme_date_classes(time(), $c);

	is_home()       ? $c[] = 'home'       : null;
	is_archive()    ? $c[] = 'archive'    : null;
	is_date()       ? $c[] = 'date'       : null;
	is_search()     ? $c[] = 'search'     : null;
	is_paged()      ? $c[] = 'paged'      : null;
	is_attachment() ? $c[] = 'attachment' : null;
	is_404()        ? $c[] = 'four04'     : null;

	if ( is_single() ) {
		the_post();
		$c[] = 'single';
		if ( isset($wp_query->post->post_date) )
			barthelme_date_classes(mysql2date('U', $wp_query->post->post_date), $c, 's-');
		foreach ( (array) get_the_category() as $cat )
			$c[] = 's-category-' . $cat->category_nicename;
			$c[] = 's-author-' . get_the_author_login();
		rewind_posts();
	}

	else if ( is_author() ) {
		$author = $wp_query->get_queried_object();
		$c[] = 'author';
		$c[] = 'author-' . $author->user_nicename;
	}
	
	else if ( is_category() ) {
		$cat = $wp_query->get_queried_object();
		$c[] = 'category';
		$c[] = 'category-' . $cat->category_nicename;
	}

	else if ( is_page() ) {
		the_post();
		$c[] = 'page';
		$c[] = 'page-author-' . get_the_author_login();
		rewind_posts();
	}

	if ( $current_user->ID )
		$c[] = 'loggedin';
		
	$c = join(' ', apply_filters('body_class',  $c));

	return $print ? print($c) : $c;
}

function barthelme_post_class( $print = true ) {
	global $post, $barthelme_post_alt;

	$c = array('hentry', "p$barthelme_post_alt", $post->post_type, $post->post_status);

	$c[] = 'author-' . get_the_author_login();
	
	foreach ( (array) get_the_category() as $cat )
		$c[] = 'category-' . $cat->category_nicename;

	barthelme_date_classes(mysql2date('U', $post->post_date), $c);

	if ( ++$barthelme_post_alt % 2 )
		$c[] = 'alt';
		
	$c = join(' ', apply_filters('post_class', $c));

	return $print ? print($c) : $c;
}
$barthelme_post_alt = 1;

function barthelme_comment_class( $print = true ) {
	global $comment, $post, $barthelme_comment_alt;

	$c = array($comment->comment_type);

	if ( $comment->user_id > 0 ) {
		$user = get_userdata($comment->user_id);

		$c[] = "byuser commentauthor-$user->user_login";

		if ( $comment->user_id === $post->post_author )
			$c[] = 'bypostauthor';
	}

	barthelme_date_classes(mysql2date('U', $comment->comment_date), $c, 'c-');
	if ( ++$barthelme_comment_alt % 2 )
		$c[] = 'alt';

	$c[] = "c$barthelme_comment_alt";

	if ( is_trackback() ) {
		$c[] = 'trackback';
	}

	$c = join(' ', apply_filters('comment_class', $c));

	return $print ? print($c) : $c;
}

function barthelme_date_classes($t, &$c, $p = '') {
	$t = $t + (get_settings('gmt_offset') * 3600);
	$c[] = $p . 'y' . gmdate('Y', $t);
	$c[] = $p . 'm' . gmdate('m', $t);
	$c[] = $p . 'd' . gmdate('d', $t);
	$c[] = $p . 'h' . gmdate('h', $t);
}

function barthelme_other_cats($glue) {
	$current_cat = single_cat_title('', false);
	$separator = "\n";
	$cats = explode($separator, get_the_category_list($separator));

	foreach ( $cats as $i => $str ) {
		if ( strstr($str, ">$current_cat<") ) {
			unset($cats[$i]);
			break;
		}
	}

	if ( empty($cats) )
		return false;

	return trim(join($glue, $cats));
}

function widget_barthelme_search($args) {
	extract($args);
?>
		<?php echo $before_widget ?>
			<?php echo $before_title ?><label for="s"><?php _e('Blog Search', 'barthelme') ?></label><?php echo $after_title ?>
			<form id="searchform" method="get" action="<?php bloginfo('home') ?>">
				<div>
					<input id="s" name="s" type="text" value="<?php echo wp_specialchars(stripslashes($_GET['s']), true) ?>" size="10" />
					<input id="searchsubmit" name="searchsubmit" type="submit" value="<?php _e('Find', 'barthelme') ?>" />
				</div>
			</form>
		<?php echo $after_widget ?>
<?php
}

function widget_barthelme_meta($args) {
	extract($args);
	$options = get_option('widget_meta');
	$title = empty($options['title']) ? __('Meta', 'barthelme') : $options['title'];
?>
		<?php echo $before_widget; ?>
			<?php echo $before_title . $title . $after_title; ?>
			<ul>
				<?php wp_register() ?>
				<li><?php wp_loginout() ?></li>
				<?php wp_meta() ?>
			</ul>
		<?php echo $after_widget; ?>
<?php
}

function widget_barthelme_homelink($args) {
	extract($args);
	$options = get_option('widget_barthelme_homelink');
	$title = empty($options['title']) ? __('Home', 'barthelme') : $options['title'];
?>
<?php if ( !is_home() || is_paged() ) { ?>
		<?php echo $before_widget; ?>
			<?php echo $before_title ?><a href="<?php bloginfo('home') ?>" title="<?php echo wp_specialchars(get_bloginfo('name'), 1) ?>"><?php echo $title ?></a><?php echo $after_title ?>
		<?php echo $after_widget; ?>
<?php } ?>
<?php
}

function widget_barthelme_homelink_control() {
	$options = $newoptions = get_option('widget_barthelme_homelink');
	if ( $_POST["homelink-submit"] ) {
		$newoptions['title'] = strip_tags(stripslashes($_POST["homelink-title"]));
	}
	if ( $options != $newoptions ) {
		$options = $newoptions;
		update_option('widget_barthelme_homelink', $options);
	}
	$title = htmlspecialchars($options['title'], ENT_QUOTES);
?>
		<p style="text-align:left;"><?php _e('Adds a link to the home page on every page <em>except</em> the home.', 'barthelme'); ?></p>
		<p><label for="homelink-title"><?php _e('Link Text:'); ?> <input style="width: 175px;" id="homelink-title" name="homelink-title" type="text" value="<?php echo $title; ?>" /></label></p>
		<input type="hidden" id="homelink-submit" name="homelink-submit" value="1" />
<?php
}

function widget_barthelme_rsslinks($args) {
	extract($args);
	$options = get_option('widget_barthelme_rsslinks');
	$title = empty($options['title']) ? __('RSS Links', 'barthelme') : $options['title'];
?>
		<?php echo $before_widget; ?>
			<?php echo $before_title . $title . $after_title; ?>
			<ul>
				<li><a href="<?php bloginfo('rss2_url') ?>" title="<?php echo wp_specialchars(get_bloginfo('name'), 1) ?> RSS 2.0 Feed" rel="alternate" type="application/rss+xml"><?php _e('All posts', 'barthelme') ?></a></li>
				<li><a href="<?php bloginfo('comments_rss2_url') ?>" title="<?php echo wp_specialchars(bloginfo('name'), 1) ?> Comments RSS 2.0 Feed" rel="alternate" type="application/rss+xml"><?php _e('All comments', 'barthelme') ?></a></li>
			</ul>
		<?php echo $after_widget; ?>
<?php
}

function widget_barthelme_rsslinks_control() {
	$options = $newoptions = get_option('widget_barthelme_rsslinks');
	if ( $_POST["rsslinks-submit"] ) {
		$newoptions['title'] = strip_tags(stripslashes($_POST["rsslinks-title"]));
	}
	if ( $options != $newoptions ) {
		$options = $newoptions;
		update_option('widget_barthelme_rsslinks', $options);
	}
	$title = htmlspecialchars($options['title'], ENT_QUOTES);
?>
			<p><label for="rsslinks-title"><?php _e('Title:'); ?> <input style="width: 250px;" id="rsslinks-title" name="rsslinks-title" type="text" value="<?php echo $title; ?>" /></label></p>
			<input type="hidden" id="rsslinks-submit" name="rsslinks-submit" value="1" />
<?php
}

function widget_barthelme_links() {
	if ( function_exists('wp_list_bookmarks') ) {
		wp_list_bookmarks(array('title_before'=>'<h3>', 'title_after'=>'</h3>', 'show_images'=>true));
	} else {
		global $wpdb;

		$cats = $wpdb->get_results("
			SELECT DISTINCT link_category, cat_name, show_images, 
				show_description, show_rating, show_updated, sort_order, 
				sort_desc, list_limit
			FROM `$wpdb->links` 
			LEFT JOIN `$wpdb->linkcategories` ON (link_category = cat_id)
			WHERE link_visible =  'Y'
				AND list_limit <> 0
			ORDER BY cat_name ASC", ARRAY_A);
	
		if ($cats) {
			foreach ($cats as $cat) {
				$orderby = $cat['sort_order'];
				$orderby = (bool_from_yn($cat['sort_desc'])?'_':'') . $orderby;

				echo '	<li id="linkcat-' . $cat['link_category'] . '" class="linkcat"><h3>' . $cat['cat_name'] . "</h3>\n\t<ul>\n";
				get_links($cat['link_category'],
					'<li>',"</li>","\n",
					bool_from_yn($cat['show_images']),
					$orderby,
					bool_from_yn($cat['show_description']),
					bool_from_yn($cat['show_rating']),
					$cat['list_limit'],
					bool_from_yn($cat['show_updated']));

				echo "\n\t</ul>\n</li>\n";
			}
		}
	}
}

function barthelme_widgets_init() {
	if ( !function_exists('register_sidebars') )
		return;

	$p = array(
		'before_title' => "<h3 class='widgettitle'>",
		'after_title' => "</h3>\n",
	);
	register_sidebars(1, $p);

	register_sidebar_widget(__('Search', 'barthelme'), 'widget_barthelme_search', null, 'search');
	unregister_widget_control('search');
	register_sidebar_widget(__('Meta', 'barthelme'), 'widget_barthelme_meta', null, 'meta');
	unregister_widget_control('meta');
	register_sidebar_widget(__('Links', 'barthelme'), 'widget_barthelme_links', null, 'links');
	unregister_widget_control('links');
	register_sidebar_widget(array('Home Link', 'widgets'), 'widget_barthelme_homelink', null, 'homelink');
	register_widget_control(array('Home Link', 'widgets'), 'widget_barthelme_homelink_control', 300, 125, 'homelink');
	register_sidebar_widget(array('RSS Links', 'widgets'), 'widget_barthelme_rsslinks', null, 'rsslinks');
	register_widget_control(array('RSS Links', 'widgets'), 'widget_barthelme_rsslinks_control', 300, 90, 'rsslinks');
}

function barthelme_add_admin() {
	if ( $_GET['page'] == basename(__FILE__) ) {
	
		if ( 'save' == $_REQUEST['action'] ) {

			update_option( 'barthelme_basefontsize', $_REQUEST['bm_basefontsize'] );
			update_option( 'barthelme_basefontfamily', $_REQUEST['bm_basefontfamily'] );
			update_option( 'barthelme_headingfontfamily', $_REQUEST['bm_headingfontfamily'] );
			update_option( 'barthelme_posttextalignment', $_REQUEST['bm_posttextalignment'] );
			update_option( 'barthelme_layoutwidth', $_REQUEST['bm_layoutwidth'] );
			update_option( 'barthelme_uppercolor', $_REQUEST['bm_uppercolor'] );
			update_option( 'barthelme_lowercolor', $_REQUEST['bm_lowercolor'] );
			update_option( 'barthelme_headerfontcolor', $_REQUEST['bm_headerfontcolor'] );
			update_option( 'barthelme_authorlink', $_REQUEST['bm_authorlink'] );

			if( isset( $_REQUEST['bm_basefontsize'] ) ) { update_option( 'barthelme_basefontsize', $_REQUEST['bm_basefontsize']  ); } else { delete_option( 'barthelme_basefontsize' ); }
			if( isset( $_REQUEST['bm_basefontfamily'] ) ) { update_option( 'barthelme_basefontfamily', $_REQUEST['bm_basefontfamily']  ); } else { delete_option( 'barthelme_basefontfamily' ); }
			if( isset( $_REQUEST['bm_headingfontfamily'] ) ) { update_option( 'barthelme_headingfontfamily', $_REQUEST['bm_headingfontfamily']  ); } else { delete_option('barthelme_headingfontfamily'); }
			if( isset( $_REQUEST['bm_posttextalignment'] ) ) { update_option( 'barthelme_posttextalignment', $_REQUEST['bm_posttextalignment']  ); } else { delete_option('barthelme_posttextalignment'); }
			if( isset( $_REQUEST['bm_layoutwidth'] ) ) { update_option( 'barthelme_layoutwidth', $_REQUEST['bm_layoutwidth']  ); } else { delete_option('barthelme_layoutwidth'); }
			if( isset( $_REQUEST['bm_uppercolor'] ) ) { update_option( 'barthelme_uppercolor', $_REQUEST['bm_uppercolor']  ); } else { delete_option('barthelme_uppercolor'); }
			if( isset( $_REQUEST['bm_lowercolor'] ) ) { update_option( 'barthelme_lowercolor', $_REQUEST['bm_lowercolor']  ); } else { delete_option('barthelme_lowercolor'); }
			if( isset( $_REQUEST['bm_headerfontcolor'] ) ) { update_option( 'barthelme_headerfontcolor', $_REQUEST['bm_headerfontcolor']  ); } else { delete_option('barthelme_headerfontcolor'); }
			if( isset( $_REQUEST['bm_authorlink'] ) ) { update_option( 'barthelme_authorlink', $_REQUEST['bm_authorlink']  ); } else { delete_option('barthelme_authorlink'); }

			header("Location: themes.php?page=functions.php&saved=true");
			die;

		} else if ( 'reset' == $_REQUEST['action'] ) {
			delete_option('barthelme_basefontsize');
			delete_option('barthelme_basefontfamily');
			delete_option('barthelme_headingfontfamily');
			delete_option('barthelme_posttextalignment');
			delete_option('barthelme_layoutwidth');
			delete_option('barthelme_uppercolor');
			delete_option('barthelme_lowercolor');
			delete_option('barthelme_headerfontcolor');
			delete_option('barthelme_authorlink');

			header("Location: themes.php?page=functions.php&reset=true");
			die;
		}
		add_action('admin_head', 'barthelme_admin_head');
	}
    add_theme_page("Barthelme Options", "Barthelme Options", 'edit_themes', basename(__FILE__), 'barthelme_admin');
}

function barthelme_admin_head() {

?>
<meta name="author" content="Scott Allan Wallick" />
<style type="text/css" media="all">
/*<![CDATA[*/
div.wrap table.editform tr td input.radio{background:#fff;border:none;margin-right:3px;}
div.wrap table.editform tr td input.text{text-align:center;width:5em;}
div.wrap table.editform tr td label{font-size:1.2em;line-height:140%;}
div.wrap table.editform tr td select.dropdown option{margin-right:10px;}
div.wrap table.editform th h3{font:normal 2em/133% georgia,times,serif;margin:1em 0 0.3em;color#222;}
div.wrap table.editform td.important span {background:#f5f5df;padding:0.1em 0.2em;font:85%/175% georgia,times,serif;}
span.info{color:#555;display:block;font-size:90%;margin:3px 0 9px;}
span.info span{font-weight:bold;}
.arial{font-family:arial,helvetica,sans-serif;}
.courier{font-family:'courier new',courier,monospace;}
.georgia{font-family:georgia,times,serif;}
.lucida-console{font-family:'lucida console',monaco,monospace;}
.lucida-unicode{font-family:'lucida sans unicode','lucida grande',sans-serif;}
.tahoma{font-family:tahoma,geneva,sans-serif;}
.times{font-family:'times new roman',times,serif;}
.trebuchet{font-family:'trebuchet ms',helvetica,sans-serif;}
.verdana{font-family:verdana,geneva,sans-serif;}
/*]]>*/
</style>
<?php
}

function barthelme_admin() {
	if ( $_REQUEST['saved'] ) { ?><div id="message1" class="updated fade"><p><?php printf(__('Barthelme theme options saved. <a href="%s">View site &raquo;</a>', 'barthelme'), get_bloginfo('home') . '/'); ?></p></div><?php }
	if ( $_REQUEST['reset'] ) { ?><div id="message2" class="updated fade"><p><?php _e('Barthelme theme options reset.', 'barthelme'); ?></p></div><?php } ?>
	
<?php $installedVersion = "3.0"; ?>
<script src="http://www.plaintxt.org/ver-check/barthelme-ver-check.php?version=<?php echo $installedVersion; ?>" type="text/javascript"></script>

<div class="wrap" id="barthelme-options">
	
	<h2><?php _e('Theme Options', 'barthelme'); ?></h2>
	<p><?php _e('Thanks for selecting the <span class="theme-title">Barthelme</span> theme. You can customize this theme with the options below. <strong>You must click on <i><u>S</u>ave Options</i> to save any changes.</strong> You can also discard your changes and reload the default settings by clicking on <i><u>R</u>eset</i>.', 'barthelme'); ?></p>

	<form action="<?php echo $_SERVER['REQUEST_URI']; ?>" method="post">
	
		<p class="submit">
			<input name="save" type="submit" value="<?php _e('Save Options &raquo;', 'barthelme'); ?>" tabindex="26" accesskey="S" />  
			<input name="action" type="hidden" value="save" />
		</p>

		<table class="editform" cellspacing="2" cellpadding="5" width="100%" border="0" summary="Barthelme theme options">

			<tr valign="top">
				<th scope="row" width="33%"><h3><?php _e('Typography', 'barthelme'); ?></h3></th>
			</tr>

			<tr valign="top">
				<th scope="row" width="33%" style="padding-top:0.7em;"><label for="bm_basefontsize"><?php _e('Base font size', 'barthelme'); ?></label></th> 
				<td>
					<input id="bm_basefontsize" name="bm_basefontsize" type="text" class="text" value="<?php if ( get_settings('barthelme_basefontsize') == "" ) { echo "75%"; } else { echo get_settings('barthelme_basefontsize'); } ?>" tabindex="1" size="10" /><br/>
					<span class="info"><?php _e('The base font size globally affects the size of text throughout your blog. This can be in any unit (e.g., px, pt, em), but I suggest using a percentage (%). Default is <span>75%</span>.', 'barthelme'); ?></span>
				</td>
			</tr>

			<tr valign="top">
				<th scope="row" width="33%"><?php _e('Base font family', 'barthelme'); ?></th> 
				<td>
					<label for="bm_basefontArial" class="arial"><input id="bm_basefontArial" name="bm_basefontfamily" type="radio" class="radio" value="arial,helvetica,sans-serif" <?php if ( ( get_settings('barthelme_basefontfamily') == "") || ( get_settings('barthelme_basefontfamily') == "arial,helvetica,sans-serif") ) { echo 'checked="checked"'; } ?> tabindex="2" />Arial</label><br/>
					<label for="bm_basefontCourier" class="courier"><input id="bm_basefontCourier" name="bm_basefontfamily" type="radio" class="radio" value="'courier new',courier,monospace" <?php if ( get_settings('barthelme_basefontfamily') == "\'courier new\',courier,monospace" ) { echo 'checked="checked"'; } ?> tabindex="3" />Courier</label><br/>
					<label for="bm_basefontGeorgia" class="georgia"><input id="bm_basefontGeorgia" name="bm_basefontfamily" type="radio" class="radio" value="georgia,times,serif" <?php if ( get_settings('barthelme_basefontfamily') == "georgia,times,serif" ) { echo 'checked="checked"'; } ?> tabindex="4" />Georgia</label><br/>
					<label for="bm_basefontLucidaConsole" class="lucida-console"><input id="bm_basefontLucidaConsole" name="bm_basefontfamily" type="radio" class="radio" value="'lucida console',monaco,monospace" <?php if ( get_settings('barthelme_basefontfamily') == "\'lucida console\',monaco,monospace" ) { echo 'checked="checked"'; } ?> tabindex="5" />Lucida Console</label><br/>
					<label for="bm_basefontLucidaUnicode" class="lucida-unicode"><input id="bm_basefontLucidaUnicode" name="bm_basefontfamily" type="radio" class="radio" value="'lucida sans unicode','lucida grande',sans-serif" <?php if ( get_settings('barthelme_basefontfamily') == "\'lucida sans unicode\',\'lucida grande\',sans-serif" ) { echo 'checked="checked"'; } ?> tabindex="6" />Lucida Sans Unicode</label><br/>
					<label for="bm_basefontTahoma" class="tahoma"><input id="bm_basefontTahoma" name="bm_basefontfamily" type="radio" class="radio" value="tahoma,geneva,sans-serif" <?php if ( get_settings('barthelme_basefontfamily') == "tahoma,geneva,sans-serif" ) { echo 'checked="checked"'; } ?> tabindex="7" />Tahoma</label><br/>
					<label for="bm_basefontTimes" class="times"><input id="bm_basefontTimes" name="bm_basefontfamily" type="radio" class="radio" value="'times new roman',times,serif" <?php if ( get_settings('barthelme_basefontfamily') == "\'times new roman\',times,serif" ) { echo 'checked="checked"'; } ?>
					tabindex="8" />Times</label><br/>
					<label for="bm_basefontTrebuchetMS" class="trebuchet"><input id="bm_basefontTrebuchetMS" name="bm_basefontfamily" type="radio" class="radio" value="'trebuchet ms',helvetica,sans-serif" <?php if ( get_settings('barthelme_basefontfamily') == "\'trebuchet ms\',helvetica,sans-serif" ) { echo 'checked="checked"'; } ?> tabindex="9" />Trebuchet MS</label><br/>
					<label for="bm_basefontVerdana" class="verdana"><input id="bm_basefontVerdana" name="bm_basefontfamily" type="radio" class="radio" value="verdana,geneva,sans-serif" <?php if ( get_settings('barthelme_basefontfamily') == "verdana,geneva,sans-serif" ) { echo 'checked="checked"'; } ?> tabindex="10" />Verdana</label><br/>
					<span class="info"><?php printf(__('The base font family sets the font for everything except content headings. The selection is limited to %1$s fonts, as they will display correctly. Default is <span class="arial">Arial</span>.', 'barthelme'), '<cite><a href="http://en.wikipedia.org/wiki/Web_safe_fonts" title="Web safe fonts - Wikipedia">web safe</a></cite>'); ?></span>
				</td>
			</tr>

			<tr valign="top">
				<th scope="row" width="33%"><?php _e('Heading font family', 'barthelme'); ?></th> 
				<td>
					<label for="bm_headingfontArial" class="arial"><input id="bm_headingfontArial" name="bm_headingfontfamily" type="radio" class="radio" value="arial,helvetica,sans-serif" <?php if ( get_settings('barthelme_headingfontfamily') == "arial,helvetica,sans-serif" ) { echo 'checked="checked"'; } ?> tabindex="11" />Arial</label><br/>
					<label for="bm_headingfontCourier" class="courier"><input id="bm_headingfontCourier" name="bm_headingfontfamily" type="radio" class="radio" value="'courier new',courier,monospace" <?php if ( get_settings('barthelme_headingfontfamily') == "\'courier new\',courier,monospace" ) { echo 'checked="checked"'; } ?> tabindex="12" />Courier</label><br/>
					<label for="bm_headingfontGeorgia" class="georgia"><input id="bm_headingfontGeorgia" name="bm_headingfontfamily" type="radio" class="radio" value="georgia,times,serif" <?php if ( ( get_settings('barthelme_headingfontfamily') == "") || ( get_settings('barthelme_headingfontfamily') == "georgia,times,serif") ) { echo 'checked="checked"'; } ?> tabindex="13" />Georgia</label><br/>
					<label for="bm_headingfontLucidaConsole" class="lucida-console"><input id="bm_headingfontLucidaConsole" name="bm_headingfontfamily" type="radio" class="radio" value="'lucida console',monaco,monospace" <?php if ( get_settings('barthelme_headingfontfamily') == "\'lucida console\',monaco,monospace" ) { echo 'checked="checked"'; } ?> tabindex="14" />Lucida Console</label><br/>
					<label for="bm_headingfontLucidaUnicode" class="lucida-unicode"><input id="bm_headingfontLucidaUnicode" name="bm_headingfontfamily" type="radio" class="radio" value="'lucida sans unicode','lucida grande',sans-serif" <?php if ( get_settings('barthelme_headingfontfamily') == "\'lucida sans unicode\',\'lucida grande\',sans-serif" ) { echo 'checked="checked"'; } ?> tabindex="15" />Lucida Sans Unicode</label><br/>
					<label for="bm_headingfontTahoma" class="tahoma"><input id="bm_headingfontTahoma" name="bm_headingfontfamily" type="radio" class="radio" value="tahoma,geneva,sans-serif" <?php if ( get_settings('barthelme_headingfontfamily') == "tahoma,geneva,sans-serif" ) { echo 'checked="checked"'; } ?> tabindex="16" />Tahoma</label><br/>
					<label for="bm_headingfontTimes" class="times"><input id="bm_headingfontTimes" name="bm_headingfontfamily" type="radio" class="radio" value="'times new roman',times,serif" <?php if ( get_settings('barthelme_headingfontfamily') == "\'times new roman\',times,serif" ) { echo 'checked="checked"'; } ?> tabindex="17" />Times</label><br/>
					<label for="bm_headingfontTrebuchetMS" class="trebuchet"><input id="bm_headingfontTrebuchetMS" name="bm_headingfontfamily" type="radio" class="radio" value="'trebuchet ms',helvetica,sans-serif" <?php if ( get_settings('barthelme_headingfontfamily') == "\'trebuchet ms\',helvetica,sans-serif" ) { echo 'checked="checked"'; } ?> tabindex="18" />Trebuchet MS</label><br/>
					<label for="bm_headingfontVerdana" class="verdana"><input id="bm_headingfontVerdana" name="bm_headingfontfamily" type="radio" class="radio" value="verdana,geneva,sans-serif" <?php if ( get_settings('barthelme_headingfontfamily') == "verdana,geneva,sans-serif" ) { echo 'checked="checked"'; } ?> tabindex="19" />Verdana</label><br/>
					<span class="info"><?php printf(__('The heading font family sets the font for all content headings and miscellanea. The selection is limited to %1$s fonts, as they will display correctly. Default is <span class="georgia">Georgia</span>. ', 'barthelme'), '<cite><a href="http://en.wikipedia.org/wiki/Web_safe_fonts" title="Web safe fonts - Wikipedia">web safe</a></cite>'); ?></span>
				</td>
			</tr>

			<tr valign="top">
				<th scope="row" width="33%"><h3><?php _e('Layout', 'barthelme'); ?></h3></th>
			</tr>

			<tr valign="top">
				<th scope="row" width="33%" style="padding-top:0.7em;"><label for="bm_layoutwidth"><?php _e('Layout width', 'barthelme'); ?></label></th> 
				<td>
					<input id="bm_layoutwidth" name="bm_layoutwidth" type="text" class="text" value="<?php if ( get_settings('barthelme_layoutwidth') == "" ) { echo "auto"; } else { echo get_settings('barthelme_layoutwidth'); } ?>" tabindex="20" size="10" /><br/>
					<span class="info"><?php _e('The layout width determines the normal width of the entire layout. This can be in any unit (e.g., px, pt, em), but I suggest "auto". Default is <span>auto</span>.', 'barthelme'); ?></span>
					<span class="info"><?php _e('<em>Note: If you use 100%, the width will be ever-so-larger than the browser window. If you want to play, I suggest playing with ems. But really, auto is the best option.</em>', 'barthelme'); ?></span>
				</td>
			</tr>

			<tr valign="top">
				<th scope="row" width="33%" style="padding-top:0.7em;"><label for="bm_posttextalignment"><?php _e('Post text alignment', 'barthelme'); ?></label></th> 
				<td>
					<select id="bm_posttextalignment" name="bm_posttextalignment" tabindex="21" class="dropdown">
						<option value="center" <?php if ( get_settings('barthelme_posttextalignment') == "center" ) { echo 'selected="selected"'; } ?>><?php _e('Centered', 'barthelme'); ?> </option>
						<option value="justify" <?php if ( get_settings('barthelme_posttextalignment') == "justify" ) { echo 'selected="selected"'; } ?>><?php _e('Justified', 'barthelme'); ?> </option>
						<option value="left" <?php if ( ( get_settings('barthelme_posttextalignment') == "") || ( get_settings('barthelme_posttextalignment') == "left") ) { echo 'selected="selected"'; } ?>><?php _e('Left', 'barthelme'); ?> </option>
						<option value="right" <?php if ( get_settings('barthelme_posttextalignment') == "right" ) { echo 'selected="selected"'; } ?>><?php _e('Right', 'barthelme'); ?> </option>
					</select>
					<br/>
					<span class="info"><?php _e('Choose one of the options for the alignment of the post entry text. Default is <span>left</span>.', 'barthelme'); ?></span>
				</td>
			</tr>

			<tr valign="top">
				<th scope="row" width="33%"><h3><?php _e('Content', 'barthelme'); ?></h3></th>
			</tr>

			<tr valign="top">
				<th scope="row" width="33%" style="padding-top:0.7em;"><label for="bm_authorlink"><?php _e('Author link', 'barthelme'); ?></label></th> 
				<td>
					<select id="bm_authorlink" name="bm_authorlink" tabindex="21" class="dropdown">
						<option value="displayed" <?php if ( ( get_settings('barthelme_authorlink') == "") || ( get_settings('barthelme_authorlink') == "displayed") ) { echo 'selected="selected"'; } ?>><?php _e('Displayed', 'barthelme'); ?> </option>
						<option value="hidden" <?php if ( get_settings('barthelme_authorlink') == "hidden" ) { echo 'selected="selected"'; } ?>><?php _e('Hidden', 'barthelme'); ?> </option>
					</select>
					<br/>
					<span class="info"><?php _e('The author\'s name and link to his/her corresponding archives page can be displayed or hidden. The "hidden" setting disables the link in an author\'s name in single post footers (and in pages &mdash; see the <a href="#readme">documentation</a> for info). Default is <span>displayed</span>.', 'barthelme'); ?></span>
				</td>
			</tr>

			<tr valign="top">
				<th scope="row" width="33%"><h3><?php _e('Header colors', 'barthelme'); ?></h3></th>
				<td class="important" valign="bottom"><br/><span><?php _e('<em><strong>Important note on color values below:</strong> You must enter the full, six-digit <a href="http://www.w3schools.com/html/html_colors.asp" title="HTML Colors at W3 Schools">hexidecimal color value</a> without the "#" symbol for each color value. Otherwise, things won\'t work.</em>', 'barthelme'); ?></span></td>
			</tr>

			<tr valign="top">
				<th scope="row" width="33%" style="padding-top:0.7em;"><label for="bm_uppercolor"><?php _e('Upper gradient color', 'barthelme'); ?></label></th> 
				<td>
					# <input id="bm_uppercolor" name="bm_uppercolor" type="text" class="text" value="<?php if ( get_settings('barthelme_uppercolor') == "" ) { echo "8999b0"; } else { echo get_settings('barthelme_uppercolor'); } ?>" tabindex="23" size="10" /><br/>
					<span class="info"><?php _e('Sets the upper color for the banner gradient. Default is <span>8999B0</span>.', 'barthelme'); ?></span>
				</td>
			</tr>

			<tr valign="top">
				<th scope="row" width="33%" style="padding-top:0.7em;"><label for="bm_lowercolor"><?php _e('Lower gradient color', 'barthelme'); ?></label></th> 
				<td>
					# <input id="bm_lowercolor" name="bm_lowercolor" type="text" class="text" value="<?php if ( get_settings('barthelme_lowercolor') == "" ) { echo "bbc8d9"; } else { echo get_settings('barthelme_lowercolor'); } ?>" tabindex="24" size="10" /><br/>
					<span class="info"><?php _e('Sets the lower color for the banner gradient. Default is <span>BBC8D9</span>.', 'barthelme'); ?></span>
				</td>
			</tr>

			<tr valign="top">
				<th scope="row" width="33%" style="padding-top:0.7em;"><label for="bm_uppercolor"><?php _e('Header font color', 'barthelme'); ?></label></th> 
				<td>
					# <input id="bm_headerfontcolor" name="bm_headerfontcolor" type="text" class="text" value="<?php if ( get_settings('barthelme_headerfontcolor') == "" ) { echo "fefefe"; } else { echo get_settings('barthelme_headerfontcolor'); } ?>" tabindex="25" size="10" /><br/>
					<span class="info"><?php _e('Sets the font color for the blog title and description. Default is <span>FEFEFE</span>.', 'barthelme'); ?></span>
				</td>
			</tr>

		</table>

		<p class="submit">
			<input name="save" type="submit" value="<?php _e('Save Options &raquo;', 'barthelme'); ?>" tabindex="26" accesskey="S" />  
			<input name="action" type="hidden" value="save" />
		</p>

	</form>

	<h2 id="reset"><?php _e('Reset Options', 'barthelme'); ?></h2>
	<p><?php _e('<strong>Resetting clears all changes to the above options.</strong> After resetting, default options are loaded and this theme will continue to be the active theme. A reset does not affect the actual theme files in any way.', 'barthelme'); ?></p>

	<form method="post" action="<?php echo $_SERVER['REQUEST_URI']; ?>">
		<p class="submit">
			<input name="reset" type="submit" value="<?php _e('Reset', 'barthelme'); ?>" onclick="return confirm('<?php _e('Click OK to reset. Any changes to these theme options will be lost!', 'barthelme'); ?>');" tabindex="27" accesskey="R" />
			<input name="action" type="hidden" value="reset" />
		</p>
	</form>

</div>

<div id="theme-information" class="wrap">

	<h2 id="info"><?php _e('Theme Information'); ?></h2>
	<p><?php _e('You are currently using the <a href="http://www.plaintxt.org/themes/barthelme/" title="Barthelme for WordPress"><span class="theme-title">Barthelme</span></a> theme, version ' . $installedVersion . ', by <span class="vcard"><a class="url xfn-me" href="http://scottwallick.com/" title="scottwallick.com" rel="me designer"><span class="n"><span class="given-name">Scott</span> <span class="additional-name">Allan</span> <span class="family-name">Wallick</span></span></a></span>.', 'barthelme'); ?></p>

	<p><?php printf(__('Please read the included <a href="%1$s" title="Open the readme.html" rel="enclosure" tabindex="28" id="readme">documentation</a> for more information about the <span class="theme-title">Barthelme</span> theme and its advanced features.', 'barthelme'), get_template_directory_uri() . '/readme.html'); ?></p>

	<h3 id="license" style="margin-bottom:-8px;"><?php _e('License', 'barthelme'); ?></h3>
	<p><?php printf(__('The <span class="theme-title">Barthelme</span> theme copyright &copy; %1$s by <span class="vcard"><a class="url xfn-me" href="http://scottwallick.com/" title="scottwallick.com" rel="me designer"><span class="n"><span class="given-name">Scott</span> <span class="additional-name">Allan</span> <span class="family-name">Wallick</span></span></a></span> is distributed with the <cite class="vcard"><a class="fn org url" href="http://www.gnu.org/licenses/gpl.html" title="GNU General Public License" rel="license">GNU General Public License</a></cite>.', 'barthelme'), gmdate('Y') ); ?></p>

</div>

<?php
}

function barthelme_wp_head() {

	function barthelme_author_link() {
		global $wpdb, $authordata;
		if ( get_settings('barthelme_authorlink') == "" ) {
			if ( is_single() || is_page() ) {
				return '<span class="entry-author author vcard"><a class="url fn" href="' . get_author_link(false, $authordata->ID, $authordata->user_nicename) . '" title="View all posts by ' . $authordata->display_name . '">' . get_the_author() . '</a></span>';
			} else {
				echo '<span class="entry-author author vcard"><a class="url fn" href="' . get_author_link(false, $authordata->ID, $authordata->user_nicename) . '" title="View all posts by ' . $authordata->display_name . '">' . get_the_author() . '</a></span>';
			}
		} else if ( get_settings('barthelme_authorlink') =="displayed" ) {
			if ( is_single() || is_page() ) {
				return '<span class="entry-author author vcard"><a class="url fn" href="' . get_author_link(false, $authordata->ID, $authordata->user_nicename) . '" title="View all posts by ' . $authordata->display_name . '">' . get_the_author() . '</a></span>';
			} else {
				echo '<span class="entry-author author vcard"><a class="url fn" href="' . get_author_link(false, $authordata->ID, $authordata->user_nicename) . '" title="View all posts by ' . $authordata->display_name . '">' . get_the_author() . '</a></span>';
			}
		} else if ( get_settings('barthelme_authorlink') =="hidden" ) {
			if ( is_single() || is_page() ) {
				return '<span class="entry-author author vcard"><span class="fn n">' . get_the_author() . '</span></span>';
			} else {
				echo '';
			}
		};
	}

	if ( get_settings('barthelme_basefontsize') == "" ) {
		$basefontsize = '75%';
	} else {
		$basefontsize = stripslashes( get_settings('barthelme_basefontsize') ); 
	};
	if ( get_settings('barthelme_basefontfamily') == "" ) {
		$basefontfamily = 'arial,helvtica,sans-serif';
	} else {
		$basefontfamily = stripslashes( get_settings('barthelme_basefontfamily') ); 
	};
	if ( get_settings('barthelme_headingfontfamily') == "" ) {
		$headingfontfamily = 'georgia,times,serif';
	} else {
		$headingfontfamily = stripslashes( get_settings('barthelme_headingfontfamily') ); 
	};
	if ( get_settings('barthelme_layoutwidth') == "" ) {
		$layoutwidth = 'auto';
	} else {
		$layoutwidth = stripslashes( get_settings('barthelme_layoutwidth') );
	};
	if ( get_settings('barthelme_posttextalignment') == "" ) {
		$posttextalignment = 'left';
	} else {
		$posttextalignment = stripslashes( get_settings('barthelme_posttextalignment') ); 
	};
	if ( get_settings('barthelme_uppercolor') == "" ) {
		$uppercolor = '8a9aae';
	} else {
		$uppercolor = stripslashes( get_settings('barthelme_uppercolor') ); 
	};
	if ( get_settings('barthelme_lowercolor') == "" ) {
		$lowercolor = 'bac8da';
	} else {
		$lowercolor = stripslashes( get_settings('barthelme_lowercolor') ); 
	};
	if ( get_settings('barthelme_headerfontcolor') == "" ) {
		$headerfontcolor = 'fefefe';
	} else {
		$headerfontcolor = stripslashes( get_settings('barthelme_headerfontcolor') ); 
	};

?>
<style type="text/css" media="all">
/*<![CDATA[*/
/* CSS inserted by theme options */
body{font-family:<?php echo $basefontfamily; ?>;font-size:<?php echo $basefontsize; ?>;}
div#content h2,div#content h3,div#content h4,div#content h5,div#content h6,body.archive div.archive-meta,body.attachment div.entry-content div.attachment-content p.attachment-name,body.home div#content div.entry-meta span,body.archive div#content div.entry-meta span,body.search div#content div.entry-meta span,body.single div.entry-date,body.single div.entry-meta,div#content blockquote,div.comments ol.commentlist li div.comment-meta,div.entry-content div.page-link,body.page div.archive-meta,div.formcontainer form#commentform div.form-input input,div.formcontainer form#commentform div.form-textarea textarea#comment,input#s,div.contactform form textarea#wpcf_msg,div.contactform form input#wpcf_your_name,div.contactform form input#wpcf_email,div.contactform form input#wpcf_website{font-family:<?php echo $headingfontfamily; ?>;}
body div#content div.hentry{text-align:<?php echo $posttextalignment; ?>;}
body div#wrapper{width:<?php echo $layoutwidth; ?>;}
div#header,div#header h1#blog-title a,div#header h1#blog-title a:link,div#header h1#blog-title a:visited{color:#<?php echo $headerfontcolor; ?>;outline:none;text-decoration:none;}
body div#header{background:#<?php echo $lowercolor; ?> url("<?php echo get_template_directory_uri(); ?>/images/header-img.php?upper=<?php echo $uppercolor; ?>&lower=<?php echo $lowercolor; ?>") repeat-x left top;}
/*]]>*/
</style>
<?php
}
add_action('admin_menu', 'barthelme_add_admin');
add_action('wp_head', 'barthelme_wp_head');

add_action('init', 'barthelme_widgets_init');
add_filter('archive_meta', 'wptexturize');
add_filter('archive_meta', 'convert_smilies');
add_filter('archive_meta', 'convert_chars');
add_filter('archive_meta', 'wpautop');
?>