<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN" "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en">
<head profile="http://gmpg.org/xfn/11">

<!-- Meta Properties -->
<meta http-equiv="Content-Type" content="<?php bloginfo('html_type'); ?>; charset=<?php bloginfo('charset'); ?>" />
<meta name="generator" content="WordPress <?php bloginfo('version'); ?>" />
<meta name="description" content="<?php bloginfo('description'); ?>" />
<!-- Add Keywords, etc.-->

<title><?php wp_title(''); ?> <?php if ( is_home() == false ) { ?> :: <?php } ?> <?php bloginfo('name'); ?></title>

<!-- Add Stylesheets for screen,print,etc.-->
<link rel="stylesheet" type="text/css" media="screen" href="<?php bloginfo('stylesheet_url'); ?>" />
<?php ImportPaintStyle(); ?>
<link rel="stylesheet" type="text/css" media="print" href="<?php bloginfo('template_url'); ?>/styles/print.css" />
<!--[if gt IE 6]><link rel="stylesheet" type="text/css" href="<?php bloginfo('template_url'); ?>/styles/iehacks.css" /><![endif]-->


<!-- Blog Specific Stuff like rss and pingback.-->
<link rel="alternate" type="application/rss+xml" title="<?php bloginfo('name'); ?> RSS Feed" href="<?php bloginfo('rss2_url'); ?>" />
<link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />

<!-- Scripts (mostly plugins, etc.)-->


<!-- Generated-->
<?php wp_head(); ?>
<?php include_once(dirname(__FILE__) . '/functions.php'); ?>

</head>

<body id="recycledblog">	
	<div id="topbar"> 
		<div id="topbar-inner">
			<ul id="menu" class="left">
				<li id="title-menu"><a href="<?php bloginfo('url'); ?>"><?php bloginfo('name'); ?></a> - </li>
				
				<?php wp_list_pages('title_li=&depth=1');?> 
				<li><a href="<?php bloginfo('rss2_url'); ?>">Feed</a></li> <li><img alt="RSS Feed Icon" src="<?php bloginfo('template_url')?>/images/feed.png" style="vertical-align:top; display:inline; border:none;"/></li>
			</ul>		
			<div id="extra-menu" class="right">
				<span><?php wp_loginout(); ?></span>  <span><?php wp_register(' | ', ''); ?> | </span>
				<span><a href="#content">Jump</a> | </span> <?php include (TEMPLATEPATH . "/includes/searchform.php"); ?>
			</div> 
		
		</div>

	</div>
	<?php if(GetFunctionality() == 'image') {?>
	<div id="secondary-topbar"> 
		<li class="title">Categories:</li> <?php wp_list_categories('title_li='); ?> 
		
	</div> <?php } ?>
	
	<div id="wrapper">

	<div id="page">		
			<?php if(GetHeaderType() != 'none') {?>
			<?php
				$title = ChunkTitle();
			?>
			<div id="headerblock">
				<?php if(GetHeaderType() == 'image') {?><img style="max-width:68.57em;" src="<?php bloginfo('template_url');?>/images/header.jpg"/><?php }?>
				<h1 <?php if(GetHeaderType() == 'image') {?>class="image-adjust"<?php } ?>><span id="title-front"><a href="<?php bloginfo('url'); ?>"><?php echo $title['front']; ?></a></span> <span id="title-rest"><a href="<?php bloginfo('url'); ?>"><?php echo $title['rest']; ?></a></span>
				</h1>
				<div id="header-secondary" <?php if(GetHeaderType() == 'image') {?>style="margin-top:2.86em;"<?php } ?>>

					<div class="left"><?php bloginfo('description'); ?></div>
					<div class="right"><!-- put something here if you'd like--></div>
					<div class="clear"></div>					
								
				</div>
			</div>
			<?php } else {?><div class="spacer"></div><?php } ?>
			
		</div>				
			