<div id="comments">
    <ol>
    <?php if ( $comments ) : ?>

    <?php foreach ($comments as $comment) : ?>
        <li>
            <h2><?php comment_author_link() ?></h2>
            <br/>
            <?php comment_text() ?>
        </li>    
    <?php endforeach; ?>
    <?php else : ?>
        <li>
            No Comments yet!
        </li>
    <?php endif; ?>
    
    <?php if ( comments_open() ) : ?>
        <li>
            <h2>Leave a comment</h2>
            <br/>
            <?php if ( get_option('comment_registration') && !$user_ID ) : ?>
                <?php printf(__('You must be <a href="%s">logged in</a> to post a comment.'), get_option('siteurl')."/wp-login.php?redirect_to=".urlencode(get_permalink()));?>
            <?php else : ?>

                <form action="<?php echo get_option('siteurl'); ?>/wp-comments-post.php" method="post" id="commentform">

                <?php if ( $user_ID ) : ?>

                <?php printf(__('Logged in as %s.'), '<a href="'.get_option('siteurl').'/wp-admin/profile.php">'.$user_identity.'</a>'); ?> <a href="<?php echo get_option('siteurl'); ?>/wp-login.php?action=logout" title="<?php _e('Log out of this account') ?>"><?php _e('Logout &raquo;'); ?></a>

                <?php else : ?>

                <p class="com_forms">
                    <input type="text" name="author" id="author" value="<?php echo $comment_author; ?>" size="22" tabindex="1" />
                    <label for="author"><small><?php _e('Name'); ?> <?php if ($req) _e('(required)'); ?></small></label>
                </p>

                <p class="com_forms">
                    <input type="text" name="email" id="email" value="<?php echo $comment_author_email; ?>" size="22" tabindex="2" />
                    <label for="email"><small><?php _e('Mail (will not be published)');?> <?php if ($req) _e('(required)'); ?></small></label>
                </p class="com_forms">

                <p class="com_forms">
                    <input type="text" name="url" id="url" value="<?php echo $comment_author_url; ?>" size="22" tabindex="3" />
                    <label for="url"><small><?php _e('Website'); ?></small></label>
                </p>
            <?php endif; ?>              
                <!--<p><small><strong>XHTML:</strong> <?php printf(__('You can use these tags: %s'), allowed_tags()); ?></small></p>-->

                <textarea name="comment" id="combox" cols="100%" rows="10" tabindex="4"></textarea>

                <input name="submit" type="submit" id="submit" tabindex="5" value="<?php echo attribute_escape(__('Submit Comment')); ?>" />
                <input type="hidden" name="comment_post_ID" value="<?php echo $id; ?>" />
        
                <?php do_action('comment_form', $post->ID); ?>

                </form>
            <?php endif; ?>
        </li>
    <?php endif; ?>
    </ol>
</div>