<?php

// quick'n'dirty hack to circumvent a security hole in all WP versions prior to 2.0.1
// that'd otherwise allow a SQL injection attack
function cleanup_useragent($input)
{
	if (preg_match('/(INSERT|DELETE|UNION|UPDATE|DROP|SELECT|EMPTY)/i',$input, $matches))
	{
		return 'SANITIZED_UA: '.$matches[1];
	} else {
		return $input;
	}
}
add_filter('pre_comment_user_agent', 'cleanup_useragent');

// =====================================================
// BEGIN SEARCH HILITE PLUGIN (ORIGINAL BY RYAN BOREN)
// =====================================================

if (!function_exists('get_search_query_terms'))
{
	function get_search_query_terms($engine = 'google')
	{
		$search = get_query_var('s');
		$search_terms = get_query_var('search_terms');

		$referer = urldecode($_SERVER['HTTP_REFERER']);
		$query_array = array();
		switch ($engine)
		{
			case 'google':
				// Google query parsing code adapted from Dean Allen's
				// Google Hilite 0.3. http://textism.com
				$query_terms = preg_replace('/^.*q=([^&]+)&?.*$/i','$1', $referer);
				$query_terms = preg_replace('/\'|"/', '', $query_terms);
				$query_array = preg_split ("/[\s,\+\.]+/", $query_terms);
				break;

			case 'lycos':
				$query_terms = preg_replace('/^.*query=([^&]+)&?.*$/i','$1', $referer);
				$query_terms = preg_replace('/\'|"/', '', $query_terms);
				$query_array = preg_split ("/[\s,\+\.]+/", $query_terms);
				break;

			case 'yahoo':
				$query_terms = preg_replace('/^.*p=([^&]+)&?.*$/i','$1', $referer);
				$query_terms = preg_replace('/\'|"/', '', $query_terms);
				$query_array = preg_split ("/[\s,\+\.]+/", $query_terms);
				break;

			case 'wordpress':
				// Check the search form vars if the search terms
				// aren't in the referer.
				if ( ! preg_match('/^.*s=/i', $referer))
				{
						if (!empty($search_terms))
						{
								$query_array = $search_terms;
						} else if (isset($search)) {
								$query_array = array($search);
						}

						break;
				}

				$query_terms = preg_replace('/^.*s=([^&]+)&?.*$/i','$1', $referer);
				$query_terms = preg_replace('/\'|"/', '', $query_terms);
				$query_array = preg_split ("/[\s,\+\.]+/", $query_terms);
				break;
		}
		return $query_array;
	}

	function is_referer_search_engine($engine = 'google')
	{
		$siteurl = get_settings('home');
		if (empty($_SERVER['HTTP_REFERER']))
		{
				return 0;
		}
		$referer = urldecode($_SERVER['HTTP_REFERER']);
			//echo "referer is: $referer<br />";
		if (!$engine)
		{
			return 0;
		}
		switch ($engine)
		{
			case 'google':
				if (preg_match('|^http://(www)?\.?google.*|i', $referer))
				{
					return 1;
				}
				break;

			case 'lycos':
				if (preg_match('|^http://search\.lycos.*|i', $referer))
				{
					return 1;
				}
				break;

			case 'yahoo':
				if (preg_match('|^http://search\.yahoo.*|i', $referer))
				{
					return 1;
				}
				break;

			case 'wordpress':
				if (preg_match("#^$siteurl#i", $referer))
				{
						return 1;
				}
				break;
		}
		return 0;
	}

	function hilite($text) {
		$search_engines = array('wordpress', 'google', 'lycos', 'yahoo');

		foreach ($search_engines as $engine) {
			if ( is_referer_search_engine($engine)) {
				$query_terms = get_search_query_terms($engine);
				foreach ($query_terms as $term) {
					if (!empty($term) && $term != ' ') {
											$term = preg_quote($term, '/');
						if (!preg_match('/<.+>/',$text)) {
							$text = preg_replace('/(\b'.$term.'\b)/i','<span class="hilite">$1</span>',$text);
						} else {
							$text = preg_replace('/(?<=>)([^<]+)?(\b'.$term.'\b)/i','$1<span class="hilite">$2</span>',$text);
						}
					}
				}
				break;
			}
		}
		return $text;
	}

	// Highlight text and comments:
	add_filter('the_content', 'hilite');
	add_filter('the_excerpt', 'hilite');
	add_filter('comment_text', 'hilite');
}

// =====================================================
// END SEARCH HILITE PLUGIN (ORIGINAL BY RYAN BOREN)
// =====================================================
// BEGIN COMMENT QUICKTAGS SUPPORT
// =====================================================

if (defined('ABSPATH') && !function_exists('comment_quicktags'))
{
	function comment_quicktags($unused)
	{
		if (file_exists(ABSPATH . 'wp-includes/js/quicktags.js'))
			$scripturl = get_settings('home') . '/wp-includes/js/quicktags.js';
		else
			$scripturl = get_settings('home') . '/wp-admin/quicktags.js';
		echo '<script src="' . $scripturl . '" type="text/javascript"></script>';
		ob_start('comment_quicktags_ob');
	}

	function comment_quicktags_ob($content)
	{
		$toolbar = '<script type="text/javascript">edToolbar();</script>';
		$activate = '<script type="text/javascript">var edCanvas = document.getElementById(\'\\2\');</script>';
		$content = preg_replace('/<textarea(.*?)id="([^"]*)"(.*?)>(.*?)<\/textarea>/', $toolbar . '<textarea\\1id="\\2"\\3>\\4</textarea>'.$activate, $content);
		return $content;
	}
	add_action('wp_head', 'comment_quicktags');
}

// =====================================================
// END COMMENT QUICKTAGS SUPPORT
// =====================================================
// BEGIN LIGHTBOX JS PLUGIN
// =====================================================

if (!function_exists('wp_lightboxJS'))
{
	function wp_lightboxJS() {
		$wp_lightboxJS_url = get_bloginfo('wpurl') . "/";
		$htmlCode = '<link rel="stylesheet" type="text/css" media="screen" href="' . get_bloginfo('template_url').'/lightbox.css" />' . "<script type=\"text/javascript\" src=\"" . get_bloginfo('template_url').'/js/lightbox.js"></script>';
		echo $htmlCode;
	}

	function wp_lightboxJS_add_quicktag()
	{
		if (strpos($_SERVER['REQUEST_URI'], 'post.php') || strpos($_SERVER['REQUEST_URI'], 'page-new.php'))
		{
	?>
			<script type="text/javascript">
			<!--
				var toolbar = document.getElementById("ed_toolbar");
	<?php
			edit_insert_button("lightbox JS", "wp_lightboxJS_handler", "Lightbox JS with Caption");
	?>

				var state_my_button = true;

				function wp_lightboxJS_handler()
				{
					if (state_my_button) {

						var myURL = prompt('<?php _e("Bitte URL des Originalbilds eingeben", "4null4.de"); ?>', 'http://');
						var myCaption = prompt('<?php _e("Bitte Caption des Bilds eingeben", "4null4.de"); ?>');
						var myIMG = prompt('<?php _e("Bitte URL des Thumbnails eingeben", "4null4.de"); ?>', 'http://');
						var myWidth = prompt('<?php _e("Bitte Image-Width des Thumbnails eingeben", "4null4.de"); ?>');
						var myHeight = prompt('<?php _e("Bitte Image-Height des Thumbnails eingeben", "4null4.de"); ?>');
						var myAlt = prompt('<?php _e("Bitte eine Kurzbeschreibung des Thumbnails eingeben", "4null4.de"); ?>');
						if (myURL && myIMG && myWidth && myHeight ) {

						myValue = '<a href="'+myURL+'" rel="lightbox" title="'+myCaption+'"><img src="'+myIMG+'" width="'+myWidth+'" height="'+myHeight+'" alt="'+myAlt+'" title="'+myAlt+'" /></a>';

						edInsertContent(edCanvas, myValue); }
					}
				}
			//-->
			</script>
	<?php
		}
	}

	if (!function_exists('edit_insert_button'))
	{
		//edit_insert_button: Inserts a button into the editor
		function edit_insert_button($caption, $js_onclick, $title = '')
		{
	?>
			if (toolbar)
			{
				var theButton = document.createElement('input');
				theButton.type = 'button';
				theButton.value = '<?php echo $caption; ?>';
				theButton.onclick = <?php echo $js_onclick; ?>;
				theButton.className = 'ed_button';
				theButton.title = "<?php echo $title; ?>";
				theButton.id = "<?php echo "ed_{$caption}"; ?>";
				toolbar.appendChild(theButton);
			}
	<?php
		}
	}

	function wp_lightbox_replace($the_content) {

		$preg = '/(<a(.*?)href="([^"]*.)(bmp|gif|jpeg|jpg|png)"(.*?)><img)/ie';
			$repl = '(strstr("\2\5","rel=") ? "\1" : "<a\2href=\"\3\4\"\5 rel=\"lightbox\"><img")';
		return preg_replace($preg,$repl,$the_content);

	}

	add_action('wp_head', 'wp_lightboxJS');
	add_filter('admin_footer', 'wp_lightboxJS_add_quicktag');
	add_filter('the_content', 'wp_lightbox_replace');
}
// =====================================================
// END OF LIGHTBOX JS PLUGIN
// =====================================================
?>