<?php
/*
Plugin Name: BB Brians Latest Comments widget
Description: Adds a sidebar widget with the most recent comments (requires Brians Latest Comment Plugin!)
Author: Carsten Albrecht
Version: 1.2.0
Author URI: http://www.4null4.de
*/

// Format of function call:
// blc_latest_comments(
//   number of posts,
//   number of commenters per post,
//   hide track/pingbacks,
//   prefix,
//   postfix,
//   fade_old,
//   range_in_days,
//   newest_color,
//   oldest_color
// )
/*
Number of posts
    The number of posts you want in the list. Default is 5.
Number of commenters per post
    How many names you want to show under each post. Default is 6.
Hide track/pingbacks
    Whether or not to hide pingbacks and trackbacks. Default is false.
Prefix and postfix
  # These are wrapped around each post and list of commenters. Default is <li> and </li>.
Fade old
    Whether to use comment temperatures. Default is true.
Range in days
    The number of days it takes for a comment to fade from the newest color to the oldest color. Default is 10 days.
New color
    The color of a completely new post. The default is a dark gray.
Old color
    The color of a post that is as old or older than the number of days given by the range in days argument. Default is light gray.
*/

if (!function_exists('register_sidebar_widget') || !function_exists('blc_latest_comments'))
	return;

function widget_bb_blc_latestcomments_control() {
	$options = $newoptions = get_option('widget_bb_blc_latestcomments');
	if ( $_POST['bb_blc_latestcomments_submit'] ) {
		$newoptions['title']         = strip_tags(stripslashes($_POST['bb_blc_latestcomments_title']));
    $newoptions['numposts']      = strip_tags(stripslashes($_POST['bb_blc_latestcomments_numposts']));
    $newoptions['numcomments']   = strip_tags(stripslashes($_POST['bb_blc_latestcomments_numcomments']));
    $newoptions['hide_tb']       = (int) $_POST['bb_blc_latestcomments_hide_tb'];
    $newoptions['fade_old']      = (int) $_POST['bb_blc_latestcomments_fade_old'];
    $newoptions['newest_color']  = strip_tags(stripslashes($_POST['bb_blc_latestcomments_newcolor']));
    $newoptions['oldest_color']  = strip_tags(stripslashes($_POST['bb_blc_latestcomments_oldcolor']));
	}
	if ( $options != $newoptions ) {
		$options = $newoptions;
		update_option('widget_bb_blc_latestcomments', $options);
	}
?>
			<div style="text-align: right;">
				<label for="bb_blc_latestcomments_title"       style="line-height:35px;">Widget title: </label><input type="text"     id="bb_blc_latestcomments_title"       name="bb_blc_latestcomments_title"       value="<?php echo htmlspecialchars($options['title']); ?>" /><br />
				<label for="bb_blc_latestcomments_numposts"    style="line-height:35px;"># Posts:      </label><input type="text"     id="bb_blc_latestcomments_numposts"    name="bb_blc_latestcomments_numposts"    value="<?php echo htmlspecialchars($options['numposts']);?>" style="width:30px;" /><br />
				<label for="bb_blc_latestcomments_numcomments" style="line-height:35px;"># Commenters: </label><input type="text"     id="bb_blc_latestcomments_numcomments" name="bb_blc_latestcomments_numcomments" value="<?php echo htmlspecialchars($options['numcomments']); ?>" style="width:30px;" /><br />
				<label for="bb_blc_latestcomments_newcolor"    style="line-height:35px;">Newest color: </label><input type="text"     id="bb_blc_latestcomments_newcolor"    name="bb_blc_latestcomments_newcolor"    value="<?php echo htmlspecialchars($options['newest_color']); ?>" style="width:60px;" /><br />
				<label for="bb_blc_latestcomments_oldcolor"    style="line-height:35px;">Oldest color: </label><input type="text"     id="bb_blc_latestcomments_oldcolor"    name="bb_blc_latestcomments_oldcolor"    value="<?php echo htmlspecialchars($options['oldest_color']); ?>" style="width:60px;" />
				<input type="hidden" name="bb_blc_latestcomments_submit" id="bb_blc_latestcomments_submit" value="1" />
			</div>
<?php
}

function widget_bb_blc_latestcomments($args) {
	extract($args);
	$options = get_option('widget_bb_blc_latestcomments');
	$widget_title = $options['title'];
	if (empty($widget_title)) $widget_title = __('Neueste Kommentare', '4null4.de');
	$numposts     = $options['numposts'];
	if (empty($numposts)) $numposts   = '5';
	$numcomments   = $options['numcomments'];
	if (empty($numcomments)) $numcomments = '6';
	$newcolor     = $options['newest_color'];
	if (empty($newcolor)) $newcolor   = "#FFFFFF";
	$oldcolor     = $options['oldest_color'];
	if (empty($oldcolor)) $oldcolor   = "#E0E0E0";

	echo $before_widget . $before_title . $widget_title . $after_title;
?>
	<ul id="blcCommentList">
<?php
	blc_latest_comments($numposts,$numcomments,true,"<li>","</li>",true,'10', $newcolor, $oldcolor);
?>
	</ul>
<?php
	echo $after_widget;
}

function widget_bb_blc_latestcomments_head() { ?>
<style type="text/css">.latestactivity small {display: block;margin: 0px;margin-left: 10px;font-size: 94%;}</style>
<?php }

register_sidebar_widget('BB Brians Latest Comments', 'widget_bb_blc_latestcomments');
register_widget_control('BB Brians Latest Comments', 'widget_bb_blc_latestcomments_control');
if ( is_active_widget('widget_bb_blc_latestcomments') )
	add_action('wp_head', 'widget_bb_blc_latestcomments_head');
?>
