<?php
/*
Plugin Name: BB Syndication widget
Description: Adds a sidebar widget to display the categories.
Author: Carsten Albrecht
Version: 1.0
Author URI: http://www.4null4.de
*/

if ( !function_exists('register_sidebar_widget') )
	return;


// This saves options and prints the widget's config form.
function widget_bb_syndication_control() {
	$options = $newoptions = get_option('widget_bb_syndication');
	if ( $_POST['bb_syndication-submit'] ) {
		$newoptions['title'] = strip_tags(stripslashes($_POST['bb_syndication-title']));
		$newoptions['rss'] = (int) $_POST['bb_syndication_rss'];
		$newoptions['rdf'] = (int) $_POST['bb_syndication_rdf'];
		$newoptions['atom'] = (int) $_POST['bb_syndication_atom'];
	}
	if ( $options != $newoptions ) {
		$options = $newoptions;
		update_option('widget_bb_syndication', $options);
	}
?>
			<div style="text-align:right">
				<label for="bb_syndication-title" style="line-height:35px;display:block;">Widget title: <input type="text" id="bb_syndication-title" name="bb_syndication-title" value="<?php echo htmlspecialchars($options['title']); ?>" /></label>
				<label for="bb_syndication_rss" style="line-height:35px;display:block;">Show RSS Link: <input type="checkbox" id="bb_syndication_rss" name="bb_syndication_rss" value="1" <?php checked('1',$options['rss']); ?> /></label>
				<label for="bb_syndication_rdf" style="line-height:35px;display:block;">Show RDF Link: <input type="checkbox" id="bb_syndication_rdf" name="bb_syndication_rdf" value="1" <?php checked('1',$options['rdf']); ?> /></label>
				<label for="bb_syndication_atom" style="line-height:35px;display:block;">Show ATOM Link: <input type="checkbox" id="bb_syndication_atom" name="bb_syndication_atom" value="1" <?php checked('1',$options['atom']); ?> /></label>
				<input type="hidden" name="bb_syndication-submit" id="bb_syndication-submit" value="1" />
			</div>
<?php
}

function widget_bb_syndication($args) {
	extract($args);
	$options = get_option('widget_bb_syndication');
	$title   = $options['title'];
	$rss     = $options['rss'];
	$rdf     = $options['rdf'];
	$atom    = $options['atom'];
	
	if (empty($title)) {
		$widget_title = __("Syndication", '4null4.de');
	} else {
		$widget_title = $title;
	}
	echo $before_widget . $before_title . $widget_title . $after_title;
?>
	<ul id="feedList">
		<?php if ($rdf) { ?>
		<li><strong><a href="<?php bloginfo('rss_url'); ?>" title="RDF-Feed"><?php _e('RDF Eintr&auml;ge', '4null4.de'); ?></a></strong></li>
		<?php } ?>
		<?php if ($rss) { ?>
		<li><strong><a href="<?php bloginfo('rss2_url'); ?>" title="RSS2.0-Feed"><?php _e('RSS2 Eintr&auml;ge', '4null4.de'); ?></a></strong></li>
		<?php } ?>
		<?php if ($atom) { ?>
		<li><strong><a href="<?php bloginfo('atom_url'); ?>" title="Atom-Feed"><?php _e('ATOM Eintr&auml;ge', '4null4.de'); ?></a></strong></li>
		<?php } ?>
	</ul>
<?php
	echo $after_widget;
}

register_sidebar_widget('BB Syndication', 'widget_bb_syndication');
register_widget_control('BB Syndication', 'widget_bb_syndication_control');
?>