<?php
// =====================================================
// BEGIN AJAX PAGED COMMENTS FANCYURL SETUP
// =====================================================

if (get_option('bb_paged_comments_fancyurl') == 0) {
    add_action('init', 'bb_pc_fancyurl');
}

// check for URL segment identifying the comment page number (or a request for all comments).
// note the page number and strip the segment from REQUEST_URI ready for WP to do its
// own parsing. url_to_postid() is used to prevent false positives (cases where a post/page
// happens to have a slug identical to one of the plugin's comment page identifiers).
// Function taken originally from keyvan's paged comments plugin
function bb_pc_fancyurl()
{
    $req = rtrim($_SERVER['REQUEST_URI'], '/');
    if (preg_match('!^(.+/)comment-page-([0-9]+)$!', $req, $match) && (url_to_postid($req) == 0)) {
        $_GET['cp'] = $match[2];
        $req = $match[1];
        $_SERVER['REQUEST_URI'] = $req;
    } elseif (preg_match('!^(.+/)all-comments$!', $req, $match) && (url_to_postid($req) == 0)) {
        $_GET['cp'] = 'all';
        $req = $match[1];
        $_SERVER['REQUEST_URI'] = $req;
    }
}

// =====================================================
// END AJAX PAGED COMMENTS FANCYURL SETUP
// =====================================================
// BEGIN AJAX PAGED COMMENTS FUNCTIONS
// =====================================================

// returns true if paged comments are enabled for this post
function bb_paged_comments()
{
  $paged_comments = get_option('bb_enable_paged_comments');

  // paged comments only when viewing a single post or a single page
  if (!is_single() && !is_page()) return false;
	// has user chosen to view all comments?
	// if so, disable paged comments for this post
  if (!(strpos($_GET['cp'], 'all' ) === false)) return false;
  // is paging enabled for all posts?
  if ($paged_comments == 'paged') return true;
	// nothing matched, ergo false
  return false;
}

// Load paged comments template (function based on comments_template() in comment-functions.php).
//
function bb_paged_comments_template($file = '/comments.php')
{
	global $wp_query, $withcomments, $post, $wpdb, $id, $comment, $user_login, $user_ID, $user_identity;
	
	$commentsArePaged = bb_paged_comments();
	$commentsOrder = get_option('bb_paged_comments_order');
	$include = apply_filters('comments_template', TEMPLATEPATH . $file);
	if (!file_exists($include)) $include = ABSPATH.'wp-content/themes/default/comments.php';

	// revert to original comment template if:
	// + plugin is not enabled for this post/page
	// + the current context is inappropriate (e.g. post listing)
	// + template for paged comments does not exist
	if (!file_exists($include)) {
		echo 'Sorry, but I can\'t find the comments.php file - neither in the theme directory nor the default one!';
		return;
	}

	$req = get_settings('require_name_email');
	$comment_author = isset($_COOKIE['comment_author_'.COOKIEHASH]) ? trim(stripslashes($_COOKIE['comment_author_'.COOKIEHASH])) : '';
	$comment_author_email = isset($_COOKIE['comment_author_email_'.COOKIEHASH]) ? trim(stripslashes($_COOKIE['comment_author_email_'.COOKIEHASH])) : '';
	$comment_author_url = isset($_COOKIE['comment_author_url_'.COOKIEHASH]) ? trim(stripslashes($_COOKIE['comment_author_url_'.COOKIEHASH])) : '';

	if (empty($comment_author)) {
		$approved_condition = "comment_approved = '1'";
	} else {
		$author_db = addslashes($comment_author);
		$email_db  = addslashes($comment_author_email);
		$approved_condition = "(comment_approved = '1' OR (comment_author = '$author_db' AND comment_author_email = '$email_db' AND comment_approved = '0'))";
	}

	// SQL for paged comments
	$comment_count = (int)$wpdb->get_var('SELECT COUNT(*) FROM '.$wpdb->comments.' WHERE comment_post_ID = \''.$post->ID.'\' AND '.$approved_condition);
	$basicQuery = 'SELECT * FROM '.$wpdb->comments.' WHERE comment_post_ID = \''.$post->ID.'\' AND '.$approved_condition.' ORDER BY comment_date ';
	if ($commentsArePaged)
	{
		$pager = bb_pc_init_pager($comment_count);
		$limit_clause = implode(', ', bb_pc_sql_limit($pager));
		$fullCommentsQuery = $basicQuery . $commentsOrder.' LIMIT '.$limit_clause;
	} else {
		$fullCommentsQuery = $basicQuery;
	}
	$comments = $wpdb->get_results($fullCommentsQuery);
	// end SQL for paged comments

	// comment numbering
	$comment_number = ($commentsArePaged) ? ($pager->get_current_page() - 1) * $pager->get_items_per_page() : 0;
	if ($commentsArePaged && ($commentsOrder == 'DESC'))
	{
    $comment_mod = (($comment_count == $pager->get_items_per_page())||($comment_count % $pager->get_items_per_page() == 0)) ? $pager->get_items_per_page() : ($comment_count % $pager->get_items_per_page());
    $comment_number += $comment_mod;
    $comment_delta = -1;
	} else {
    $comment_number += 1;
    $comment_delta = 1;
	}

	get_currentuserinfo();

	define('COMMENTS_TEMPLATE', true);
	require($include);
}

// initialise pager
function bb_pc_init_pager($total_comments)
{
  $newpager = new Pager(get_option('bb_paged_comments_amount'), $total_comments);
  $pager =& $newpager;
  if (get_option('bb_paged_comments_order') == 'DESC')
  {
    $pager =& new InvertedPager($newpager);
  }
  // set page number
  $page = (int)@$_GET['cp'];
  if ($page > 0) $pager->set_current_page($page);
  return $pager;
}

// for mysql LIMIT clause (returns array with offset and limit)
function bb_pc_sql_limit($pager)
{
  $order = get_option('bb_paged_comments_order');
  $perPage = (int) get_option('bb_paged_comments_amount');
  $remainder = $pager->get_total_items() % $perPage;
  $offset = ($pager->isInverted) ?  ($pager->_invert_Page($pager->get_current_page()) - 1) * $perPage : ($pager->get_current_page() - 1) * $perPage;

  // alternate descending mode where the last page always contains a fixed number of comments
  if ($order == 'DESC') {
    return array($offset, $perPage);
  }
  // limit clause for comments in ascending order (or if total-comments multiple of comments-per-page)
  if (($order == 'ASC') || ($remainder == 0)) {
    return array($offset, $perPage);
  }
  // limit clause for comments in descending order (if we're on the last page)
  if ($pager->get_current_page() == $pager->num_pages()) {
    return array(0, $remainder);
  } else {
    return array($offset + $remainder - $perPage, $perPage);
  }
}

// Returns URL to comment $page with the $fragment appended.
// If $page is null the current comment page is used or a relative 
// URL (consisting of only the fragment) is returned.
function bb_pc_url($pager, $fragment = 'comments', $page = null)
{
	global $post;
	if (!isset($page) && (get_option('bb_paged_comments_order') == 'ASC' || isset($_GET['cp']))) return "#$fragment";
	if (!isset($page) && isset($pager))	$page = $pager->get_current_page();
	$id = $post->ID;
	$qparam = is_page() ? 'page_id' : 'p';

  if ((get_option('bb_paged_comments_fancyurl') == 0) && (get_settings('permalink_structure') != ''))
  {
    if ($page == 'all')
    {
      return rtrim(get_permalink(), '/')."/all-comments/#$fragment";
		} else {
			return rtrim(get_permalink(), '/')."/comment-page-$page/#$fragment";
		}
  } else {
		if ($page == 'all')
		{
	        return get_settings('siteurl').'/'.get_settings('blogfilename')."?$qparam=$id&amp;cp=all#$fragment";
		} else {
	        return get_settings('siteurl').'/'.get_settings('blogfilename')."?$qparam=$id&amp;cp=$page#$fragment";
		}
  }
}

// output page numbers
function bb_pc_pages($pager)
{
    global $post;
		$url = bb_pc_url($pager, 'comments', '%u');
		$allurl = bb_pc_url($pager, 'comments', 'all');
    $printer =& new PagePrinter($pager, $url, get_option('bb_paged_comments_range'));
    $left = '&laquo;';
    $right = '&raquo;';
    $older = __('&Auml;ltere Kommentare', '4null4.de');
    $newer = __('Neuere Kommentare', '4null4.de');
    $sep = ' ';
    $link_left = (get_option('bb_paged_comments_order') == 'ASC') ? $printer->get_prev_link($left, $older) : $printer->get_next_link($left, $newer);
		// left arrow link
    if (!empty($link_left)) echo $link_left, $sep;
		// page number links
    echo $printer->get_links($sep);
		// right arrow link
    $link_right = (get_option('bb_paged_comments_order') == 'ASC') ? $printer->get_next_link($right, $newer) : $printer->get_prev_link($right, $older);
    if (!empty($link_right)) echo $sep, $link_right;
    //if ($paged_comments->show_all_option) echo $sep, '(<a href="'.$allurl.'">Show All</a>)';
}

// The classes below are used to calculate page numbers and print pages numbers

/*****************************************
* Class: Pager 
* Originally by: Tsigo <tsigo@tsiris.com>
* Modified: Keyvan
* Redistribute as you see fit. 
*****************************************/
class Pager 
{
    /**
    * Items per page.
    *
    * This is used, along with <var>$item_total</var>, to calculate how many
    * pages are needed.
    * @var int
    */
    var $items_per_page;

    /**
    * Total number of items 
    *
    * This is used, along with <var>$items_per_page</var>, to calculate how many
    * pages are needed.
    * @var int
    */
    var $item_total;

    /**
    * Current page
    * @var int
    */
    var $current_page;
  
    /**
    * Number of pages needed
    * @var int
    */
    var $num_pages;

    /**
    * Constructor
    */
	function Pager($items_per_page, $item_total)
	{
        $this->items_per_page = $items_per_page;
        $this->item_total = $item_total;
        $this->num_pages = (int)ceil($this->item_total / $this->items_per_page);
        $this->set_current_page(1);
	}

    /**
    * Set current page number
    * @param int $page
    */
    function set_current_page($page)
    {
		$this->current_page = min($page, $this->num_pages());
		$this->current_page = max($this->current_page, 1);
    }

    /**
    * Get current page
    * @return int
    */
    function get_current_page()
    {
        return $this->current_page;
    }

    /**
    * Get items per page
    * @return int
    */
    function get_items_per_page()
    {
        return $this->items_per_page;
    }

    /**
    * Get total items
    * @return int
    */
    function get_total_items()
    {
        return $this->item_total;
    }
    
    /**
    * Number of pages needed
    * @return int
    */
    function num_pages() 
    {
        return $this->num_pages;
    }

    /**
    * Is last page
    * @return boolean
    */
    function is_last_page()
    {
        return ($this->get_current_page() == $this->num_pages());
    }

    /**
    * Is first page
    * @return boolean
    */
    function is_first_page()
    {
        return ($this->get_current_page() == 1);
    }

    /**
    * Get page numbers within range
    * @param int $page_range number of pages to display at one time, default: all pages
    * @return array
    */
    function get_page_numbers($page_range=null)
    {
        if (!isset($page_range)) {
            return range(1, $this->num_pages());
        } else {
            // set boundaries
            $pages = $this->num_pages();
            $range_halved = (int)floor($page_range / 2);
            $count_start = $this->current_page - $range_halved;
            $count_end = $this->current_page + $range_halved;

            // adjust boundaries
            while ($count_start < 1) {
                $count_start++;
                $count_end++;
            }
            while ($count_end > $pages) {
                $count_end--;
                $count_start--;
            }
            $count_start = max($count_start, 1);
            return range($count_start, $count_end);
        }
    }
}


// Implements the Pager interface but inverts numbers. (Decorator pattern)
class InvertedPager
{
    var $pager;
    var $isInverted = true;

    function InvertedPager(&$pager)
    {
        $this->pager =& $pager;
    }

    function _invert_page($page)
    {
        return $this->pager->num_pages() + 1 - $page;
    }

    /**
    * Set current page number
    * @param int $page
    */
    function set_current_page($page)
    {
		$this->pager->set_current_page($this->_invert_page($page));
    }

    /**
    * Get current page
    * @return int
    */
    function get_current_page()
    {
        return $this->_invert_page($this->pager->get_current_page());
    }

    /**
    * Get page numbers within range
    * @param int $page_range number of pages to display at one time, default: all pages
    * @return array
    */
    function get_page_numbers($page_range=null)
    {
        return array_map(array(&$this, '_invert_page'), $this->pager->get_page_numbers($page_range));
    }

    /**
    * Get items per page
    * @return int
    */
    function get_items_per_page()
    {
        return $this->pager->get_items_per_page();
    }
   
    /**
    * Get total items
    * @return int
    */
    function get_total_items()
    {
        return $this->pager->get_total_items();
    }

    /**
    * Number of pages needed
    * @return int
    */
    function num_pages() 
    {
        return $this->pager->num_pages();
    }

    /**
    * Is last page
    * @return boolean
    */
    function is_last_page()
    {
        return ($this->get_current_page() == $this->num_pages());
    }

    /**
    * Is first page
    * @return boolean
    */
    function is_first_page()
    {
        return ($this->get_current_page() == 1);
    }
}

// Prints page number links using a Pager instance
class PagePrinter
{
    var $pager;

    /**
    * URL formatting string for building page links
    *
    * This should be a formatting string which will be passed to sprintf()
    * (see: <http://uk.php.net/sprintf>), it should include 1 conversion 
    * specification: %u (to hold the page number)
    * @string
    */
    var $url;

    /**
    * Number of pages to show at one time
    * @var int
    */
    var $page_range;

    function PagePrinter(&$pager, $url='', $page_range=null)
    {
        $this->pager =& $pager;
        $this->set_page_range($page_range);
        $this->set_url($url);
    }

    function get_prev_link($text='&laquo;', $title='')
    {
    		global $post;
    		if (!$title)
    			$title = __('Vorherige Seite', '4null4.de');
        if ($this->pager->is_first_page()) return '';
        return '<a onClick="loadPagedComments('.$post->ID.','.($this->pager->get_current_page() - 1).');return false;" href="'.$this->get_url($this->pager->get_current_page() - 1).'" title="'.$title.'">'.$text.'</a>';
    }

    function get_next_link($text='&raquo;', $title='')
    {
    		global $post;
    		if (!$title)
    			$title = __('N&auml;chste Seite', '4null4.de');
        if ($this->pager->is_last_page()) return '';
        return '<a onClick="loadPagedComments('.$post->ID.','.($this->pager->get_current_page() + 1).');return false;" href="'.$this->get_url($this->pager->get_current_page() + 1).'" title="'.$title.'">'.$text.'</a>';
    }

    /**
    * Get page links
    * @return string HTML
    */
    function get_links($separator=' ', $pre_cur_page='<strong>[', $post_cur_page=']</strong>')
    {
        global $post;
        
        $pages = $this->pager->num_pages();
        $page_links  = ''; 
       
        // print page numbers
        $cur_page = $this->pager->get_current_page();
        $num_links = array();
        $page_numbers = $this->pager->get_page_numbers($this->page_range);
				$asc = ($page_numbers[0] < $page_numbers[1]);
        if( $asc ) {
            if( $page_numbers[0] != 1 ) {
                $num_links[] = '<a onClick="loadPagedComments('.$post->ID.',1);return false;" href="'.$this->get_url(1)."\">1</a> &#8230;"; 
            }
        } else {
            if( $page_numbers[0] != $this->pager->num_pages() ) {
                $num_links[] = '<a onClick="loadPagedComments('.$post->ID.','.$this->pager->num_pages().');return false;" href="'.$this->get_url($this->pager->num_pages())."\">".$this->pager->num_pages()."</a> &#8230;"; 
            }
        }
        foreach ( $page_numbers as $i) { 
            if ($i == $cur_page) { 
                $num_links[] = $pre_cur_page.$i.$post_cur_page; 
            } else { 
                $num_links[] = '<a onClick="loadPagedComments('.$post->ID.','.$i.');return false;" href="'.$this->get_url($i)."\">$i</a>"; 
            } 
        } 
        if( $asc ) {
            if( $page_numbers[count($page_numbers)-1] != $this->pager->num_pages() ) {
                $num_links[] = '&#8230; <a onClick="loadPagedComments('.$post->ID.','.$this->pager->num_pages().');return false;" href="'.$this->get_url($this->pager->num_pages())."\">".$this->pager->num_pages()."</a>"; 
            }
        } else {
            if( $page_numbers[count($page_numbers)-1] != 1 ) {
                $num_links[] = '&#8230; <a onClick="loadPagedComments('.$post->ID.',1);return false;" href="'.$this->get_url(1)."\">1</a>"; 
            }
        }
        $page_links .= implode($separator, $num_links);
        
        return $page_links; 
    }

    /**
    * Set page range
    * @param int $max
    */
    function set_page_range($max)
    {
        $this->page_range = $max;
    }

    /**
    * Set URL
    * @param string $url
    */
    function set_url($url)
    {
        $this->url = $url;
    }

    /**
    * Get formatted URL (including page number)
    * @param int $page page number
    * @return string
    */
    function get_url($page)
    {
        return sprintf($this->url, $page);
    }
}
// =====================================================
// END AJAX PAGED COMMENTS FUNCTIONS
// =====================================================
?>