<?php get_header(); ?>

<div id="content"><a name="content"></a>

<?php if (have_posts()) : ?>

<div class="navigation">
<div class="align-left"><?php next_posts_link('&laquo; Previous Entries') ?></div>
<div class="align-right"><?php previous_posts_link('Next Entries &raquo;') ?></div>
</div>

<?php while (have_posts()) : the_post(); ?>

<div class="post">

<div class="date"><span><?php the_time('d M Y') ?></span></div>

<h2 id="post-<?php the_ID(); ?>"><a href="<?php the_permalink() ?>" rel="bookmark" title="Permanent Link to <?php the_title(); ?>"><?php the_title(); ?></a></h2>

<div class="entry">
<?php the_excerpt(); ?>
<p><a href="<?php the_permalink() ?>" rel="bookmark" title="Permanent Link to <?php the_title(); ?>">Continue reading &quot;<?php the_title(); ?>&quot; &raquo;</a></p>
</div>

<div class="postmetadata">
<span class="post-comments"><?php comments_popup_link('No Comment', '1 Comment', '% Comments'); ?></span><br />
<span class="post-auth-date">Posted by <?php the_author(); ?> at <?php the_time() ?></span><br />
<span class="post-cat">Category: <?php the_category(', ') ?></span>
</div>

</div>

<?php endwhile; ?>

<div class="navigation">
<div class="align-left"><?php next_posts_link('&laquo; Previous Entries') ?></div>
<div class="align-right"><?php previous_posts_link('Next Entries &raquo;') ?></div>
</div>

<?php else : ?>

<div class="post">
<div class="date"><span>&nbsp;</span></div>
<h2>Not Found</h2>
<div class="entry">
<p>Sorry, no posts matched your query. Please try a different search.</p>
</div>
<div class="postmetadata"><span>&nbsp;</span></div>
</div>

<?php endif; ?>

</div> <!-- div#content -->

<?php get_sidebar(); ?>

<?php get_footer(); ?>