<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head profile="http://gmpg.org/xfn/11">
<meta http-equiv="Content-Type" content="<?php bloginfo('html_type'); ?>; charset=<?php bloginfo('charset'); ?>" />
<title>
<?php bloginfo('name'); ?>
<?php if ( is_single() ) { ?>
&raquo; Blog Archive
<?php } ?>
<?php wp_title(' &raquo; '); ?>
</title>
<meta name="generator" content="WordPress <?php bloginfo('version'); ?>" />
<!-- leave this for stats -->
<link rel="stylesheet" href="<?php bloginfo('stylesheet_url'); ?>" type="text/css" media="screen" />
<link rel="alternate" type="application/rss+xml" title="RSS 2.0" href="<?php bloginfo('rss2_url'); ?>" />
<link rel="alternate" type="text/xml" title="RSS .92" href="<?php bloginfo('rss_url'); ?>" />
<link rel="alternate" type="application/atom+xml" title="Atom 0.3" href="<?php bloginfo('atom_url'); ?>" />
<link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />
<?php wp_get_archives('type=monthly&format=link'); ?>
<?php wp_head(); ?>
</head>
<body>
<div id="main">
  <div id="main_left">
    <!-- header -->
	<?php get_header(); ?>
    <!-- navigation -->
    <div id="navigation">
      <ul>
        <li><a href="<?php bloginfo('url'); ?>/">Home</a></li>
        <?php wp_list_pages('depth=3&title_li='); ?>
      </ul>
    </div>
    <!-- content -->
    <div id="content">
      <?php if (have_posts()) : ?>
	  <?php while (have_posts()) : the_post(); ?>
      <div class="post"  id="post-<?php the_ID(); ?>">
        <h1><a href="<?php the_permalink() ?>" title="<?php the_title(); ?>">
          <?php the_title(); ?>
          </a></h1>
        <div class="descr">
          <?php the_time('F jS, Y') ?>
          by
          <?php the_author() ?>
        </div>
        <div class="post_body">
          <?php the_content('Read the rest of this entry &raquo;'); ?>
		  <?php link_pages('<p><strong>Pages:</strong> ', '</p>', 'number'); ?>
		  <?php edit_post_link('Edit', '<p>', '</p>'); ?>
        </div>
        <div class="post_info"> <span class="comment">
          <?php comments_popup_link('No Comments', '1 Comment', '% Comments'); ?>
          </span> | Posted in
          <?php the_category(', ') ?>
          <?php edit_post_link('Edit',' | ',''); ?>
        </div>
      </div>
      <?php comments_template(); ?>
      <?php endwhile; ?>
      <p>
        <?php next_posts_link('&laquo; Previous Entries') ?>
        <?php previous_posts_link('Next Entries &raquo;') ?>
      </p>
      <?php else : ?>
      <h1>Not Found</h1>
      <p>Sorry, but you are looking for something that isn't here.</p>
      <?php endif; ?>
    </div> 
  </div>
    <!-- sidebar -->
    <div id="main_right">
    <?php get_sidebar(); ?>
    </div>
	<?php get_footer(); ?>
</div>
</body>
</html>