<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="<?php bloginfo('html_type'); ?>; charset=<?php bloginfo('charset'); ?>" />
<title>
<?php bloginfo('name'); ?>
<?php if ( is_single() ) { ?>
&raquo; Blog Archive
<?php } ?>
<?php wp_title(); ?>
</title>
<meta name="generator" content="WordPress <?php bloginfo('version'); ?>" />
<!-- leave this for stats -->
<link rel="stylesheet" href="<?php bloginfo('stylesheet_url'); ?>" type="text/css" media="screen" />
<link rel="alternate" type="application/rss+xml" title="RSS 2.0" href="<?php bloginfo('rss2_url'); ?>" />
<link rel="alternate" type="text/xml" title="RSS .92" href="<?php bloginfo('rss_url'); ?>" />
<link rel="alternate" type="application/atom+xml" title="Atom 0.3" href="<?php bloginfo('atom_url'); ?>" />
<link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />
<?php wp_get_archives('type=monthly&format=link'); ?>
<?php wp_head(); ?>
<link rel="stylesheet" href="style.css" type="text/css" media="screen" />
</head>
<body>
<div id="wrapper">
  <?php get_header(); ?>
  <!-- end div#menu -->
  <div id="page">
    <div id="content">
      <?php if (have_posts()) : ?>
      <?php while (have_posts()) : the_post(); ?>
      <div class="post" id="post-<?php the_ID(); ?>">
        <h1><a href="<?php the_permalink() ?>" rel="bookmark" title="Permanent Link to <?php the_title(); ?>">
          <?php the_title(); ?>
          </a></h1>
        <?php the_time('F jS, Y') ?>
        by
        <?php the_author() ?>
        <div class="entry">
          <?php the_content('Read the rest of this entry &raquo;'); ?>
		  <?php link_pages('<p><strong>Pages:</strong> ', '</p>', 'number'); ?>
		  <?php edit_post_link('Edit', '<p>', '</p>'); ?>
        </div>
        <p class="info">Posted in
          <?php the_category(', ') ?>
          <strong>&nbsp;|&nbsp;</strong>
          <?php edit_post_link('Edit','','<strong>&nbsp;|&nbsp;</strong>'); ?>
          <?php comments_popup_link('No Comments &raquo;', '1 Comment &raquo;', '% Comments &raquo;'); ?>
        </p>
      </div>
      <?php comments_template(); ?>
      <?php endwhile; ?>
      <p align="center">
        <?php next_posts_link('&laquo; Previous Entries') ?>
        <?php previous_posts_link('Next Entries &raquo;') ?>
      </p>
      <?php else : ?>
      <h2 align="center">Not Found</h2>
      <p align="center">Sorry, but you are looking for something that isn't here.</p>
      <?php endif; ?>
      <!-- end div#welcome -->
    </div>
    <!-- end div#content -->
    <?php get_sidebar(); ?>
    <!-- end div#sidebar -->
    <div style="clear: both; height: 1px"></div>
  </div>
  <!-- end div#page -->
  <?php get_footer(); ?>
  <!-- end div#footer -->
</div>
<!-- end div#wrapper -->
</body>
</html>