<?php
if (basename($_SERVER['SCRIPT_FILENAME']) == 'comments.php') {
    exit('Please do not load this page directly. Thankyou.');
}

if (!empty($post->post_password)) {
    if ($post->post_password != $_COOKIE['wp-postpass_' . COOKIEHASH]) {
        return;
    }
}
?>

<div id="comments">

<?php if ($comments) { ?>

    <h2><?php comments_number();?> on <cite><?php the_title(); ?></cite></h2>

    <?php $i = 1; ?>

    <?php foreach ($comments as $comment) { ?>

        <?php
        $class = 'comment';
        $class .= (get_comment_author_email() == get_the_author_email()) ? ' author' : '';
        $class .= ($i % 2) ? '' : ' alt';
        ?>

        <div id="comment-<?php comment_ID() ?>" class="<?php echo $class; ?>">

            <p>By <?php comment_author_link(); ?> on <?php comment_date(); ?> at <?php comment_time(); ?><?php edit_comment_link('Edit', ' | ', ''); ?></p>

            <?php if ($comment->comment_approved == 0) { ?>

                <p id="comment-pending">Your comment is awaiting moderation.</p>

            <?php } ?>

            <?php comment_text(); ?>

        </div><!-- /comment-<?php comment_ID() ?> -->

        <?php $i++; ?>

    <?php } ?>

<?php } ?>

<?php if ($post->comment_status == 'open') { ?>

    <?php if (get_option('comment_registration') && !$user_ID ) { ?>

        <div id="comment-registration">

            <h2>Comment</h2>

            <p><a href="<?php echo get_option('siteurl'); ?>/wp-login.php?redirect_to=<?php the_permalink(); ?>">Log in</a> or <a href="<?php echo get_option('siteurl'); ?>/wp-login.php?action=register">Register</a> to post a comment.</p>

        </div><!-- /comment-registration -->

    <?php } else { ?>

        <div id="respond">

            <h2>Write a Comment on <cite><?php the_title(); ?></cite></h2>

            <form id="comment-form" action="<?php echo get_option('siteurl'); ?>/wp-comments-post.php" method="post">

                <fieldset>

                <?php if ($user_ID) { ?>

                    <p>Logged in as <a href="<?php echo get_option('siteurl'); ?>/wp-admin/profile.php"><?php echo $user_identity; ?></a> | <a href="<?php echo get_option('siteurl'); ?>/wp-login.php?action=logout">Logout</a></p>

                <?php } else { ?>


                    <label for="name"<?php echo ($req) ? ' class="required"' : ''; ?>>Name (Required)</label>
                    <input id="name" type="text" name="author" value="<?php echo $comment_author; ?>" maxlength="100" />

                    <label for="email"<?php echo ($req) ? ' class="required"' : ''; ?>>Email (Required - will not be published)</label>
                    <input id="email" type="text" name="email" value="<?php echo $comment_author_email; ?>" maxlength="100" />

                    <label for="url">Website</label>
                    <input id="url" type="text" name="url" value="<?php echo $comment_author_url; ?>" maxlength="100" />

                <?php } ?>

                <label for="comment">Comment</label>
                <textarea id="comment" name="comment" rows="7" cols="80"></textarea>

                <input id="submit" name="submit" type="submit" value="Submit Comment" />
                <input type="hidden" name="comment_post_ID" value="<?php echo $id; ?>" />

                <?php do_action('comment_form', $post->ID); ?>

            </fieldset>

            </form>

        </div><!-- /respond -->

        <div id="post-comments-rss">

            <h2>Subscribe</h2>

            <p>Follow comments by subscribing to the <?php comments_rss_link(get_the_title() . ' Comments RSS'); ?> feed.</p>

        </div><!-- /post-comments-rss -->

    <?php } ?>

<?php } else { ?>

    <div id="comments-closed">

        <h2>Write a Comment on <cite><?php the_title(); ?></cite></h2>

        <p><a href="#comments">Comments on <cite><?php the_title(); ?></cite></a> are now closed.</p>

    </div><!-- /comment-closed -->

<?php } ?>

</div><!-- /comments -->
