<?php get_header(); /* include header.php template */ ?>

<?php get_sidebar(); /* include sidebar.php template */ ?>

<div id="content">
<?php if (have_posts()) : while (have_posts()) : the_post(); /* The Loop starts */ ?>

	<?php the_date('','<div class="post-header"><h2>','</h2></div>'); ?>
	<div class="post">
	<h3 class="post-title" id="post-<?php the_ID(); ?>"><a href="<?php the_permalink() ?>" rel="bookmark"><?php the_title(); ?></a></h3>
		<div class="post-content">
		<?php the_content(__('[read more...]')); ?>
		</div>

		<div class="post-meta">
		<?php wp_link_pages(); ?>
		<?php _e('Posted by'); ?> <?php the_author() ?> @ <?php the_time() ?> :: <?php the_category(',') ?>
		<?php edit_post_link(__("Edit post"), ' :: '); ?>
		:: <?php comments_popup_link(__('No comments'), __('1 comment'), __('% comments'), __('Comments off')); ?>
		</div>

<!--
<?php trackback_rdf(); ?>
-->
	</div>

<?php endwhile; else: /* if there are no posts in The Loop */ ?>

	<div class="post-header"><h2><?php _e('Not Found'); ?></h2></div>
	<div class="post">
	<p><?php _e('Sorry, no posts matched your criteria.'); ?></p>
	</div>

<?php endif; /* The Loop ends */ ?>

	<div id="nav">
		<div id="nav-forward">
		<?php next_posts_link(__('Earlier posts &#187;')); ?>
		</div>
		<div id="nav-backward">
		<?php previous_posts_link(__('&#171; Recent posts')); ?>
		</div>
	</div>

</div>

<?php get_footer(); /* include footer.php template */ ?>