<?php get_header(); /* include header.php template */ ?>

<?php get_sidebar(); /* include sidebar.php template */ ?>

<div id="content">
<?php if (have_posts()) : while (have_posts()) : the_post(); /* The Loop starts */ ?>

	<?php the_date('','<div class="post-header"><h2>','</h2></div>'); ?>
	<div class="post">
	<h3 class="post-title" id="post-<?php the_ID(); ?>"><a href="<?php the_permalink() ?>" rel="bookmark"><?php the_title(); ?></a></h3>
		<div class="post-content">
		<?php the_content(__('[read more...]')); ?>
		</div>

		<div class="post-meta">
		<?php wp_link_pages(); ?>
		<?php _e('Posted by'); ?> <?php the_author() ?> @ <?php the_time() ?> :: <?php the_category(',') ?> <?php edit_post_link(__("Edit post"), ':: '); ?><br />
		<a href="<?php echo comments_rss(); ?>" title="<?php _e('RSS 2.0 feed for comments to this post.') ?>"><?php _e('Comment RSS') ?></a>
		<?php if ('open' == $post->ping_status) : /* if pings/trackbacks are open */ ?>
		:: <a href="<?php trackback_url(display); ?>" title="<?php _e('Copy link to send Trackback to this post.'); ?>"><?php _e('Trackback URI'); ?></a>
		<?php endif; ?>	
		</div>

<!--
<?php trackback_rdf(); ?>
-->
	<?php comments_template(); /* display comments.php template */ ?>
	</div>

<?php endwhile; else: /* if there are no posts in The Loop */ ?>

	<div class="post-header"><h2><?php _e('Not Found'); ?></h2></div>
	<div class="post">
	<p><?php _e('Sorry, no posts matched your criteria.'); ?></p>
	</div>

<?php endif; /* The Loop ends */ ?>

	<div id="nav">
		<div id="nav-forward">
		<?php previous_post('%',__('Previous post') . ' &#187;', 'no'); ?>
		</div>
		<div id="nav-backward">
		<?php next_post('%', '&#171; ' . __('Next post'), 'no'); ?>
		</div>
	</div>

</div>

<?php get_footer(); /* include footer.php template */ ?>