<?php

class braille {
	function init() {
		load_theme_textdomain('braille');
	
		include(TEMPLATEPATH . '/options/include/options.php');
		include(TEMPLATEPATH . '/options/include/archive.php');

		$last_modified = filemtime(dirname(__FILE__));
		$last_modified_check = get_option('braillelastmodified');

		if($last_modified_check === false || $last_modified_check < $last_modified) {
			braille::install($last_modified);
		}

		do_action('brailleinit');
	}

	function install($last_modified) {
		global $themeVersion;

		if(get_option('brailleversion') === false) {
			add_option('brailleversion', $themeVersion, 'This option stores Braille\'s version number');
		} else {
			update_option('brailleversion', $themeVersion);
		}

		if(get_option('braillelastmodified') === false) {
			add_option('braillelastmodified', $last_modified, 'This option stores Braille\'s last application modification. Used for version checking');
		} else {
			update_option('braillelastmodified', $last_modified);
		}

		do_action('brailleinstall');
	}

	function uninstall() {
		do_action('brailleuninstall');

		delete_option('brailleversion');
		delete_option('braillelastmodified');

		wp_cache_flush();

		update_option('template', 'default');
		update_option('stylesheet', 'default');
		do_action('switch_theme', 'Default');

		header('location: themes.php');
		exit;
	}

	function files_scan($path, $ext = false, $depth = 1, $relative = true) {
		$files = array();
		braille::_files_scan($path, '', $ext, $depth, $relative, $files);
		return $files;
	}

	function _files_scan($base_path, $path, $ext, $depth, $relative, &$files) {
		if(($dir = @dir($base_path . $path)) !== false) {
			while(($file = $dir->read()) !== false) {
				$file_path = $path . $file;
				$file_full_path = $base_path . $file_path;

				if(is_dir($file_full_path) and $depth > 1 and !($file == '.' or $file == '..')) {
					braille::_files_scan($base_path, $file_path . '/', $ext, $depth - 1, $relative, $files);
				} elseif(is_file($file_full_path) and (!$ext or preg_match('/\.' . $ext . '$/i', $file))) {
					$files[] = $relative ? $file_path : $file_full_path;
				}
			}

			$dir->close();
		}
	}
}

?>
