<?php
	global $wpdb;

	// Update
	$update = braille_options::update();

	// Get the current Braille scheme
	$scheme_name = get_option('braillescheme');
	$scheme_title = $scheme_name !== false ? $scheme_name : __('No Scheme', 'braille');

	// Get the scheme files
	$scheme_files = braille::files_scan(TEMPLATEPATH . '/schemes/', 'css', 2);

?>

<?php if(isset($_POST['submit'])) { ?>
<div id="message" class="updated fade">
	<p><?php _e('Braille Options have been updated', 'braille'); ?></p>
</div>
<?php } ?>

<div class="wrap">

	<form name="dofollow" action="" method="post">
		<input type="hidden" name="action" value="<?php echo($update); ?>" />
		<input type="hidden" name="page_options" value="'dofollow_timeout'" />

		<p class="submit">
			<input type="submit" name="submit" value="<?php _e('Update Options', 'braille'); ?> &raquo;" />
		</p>



		<div class="configure">

			<h3><?php _e('Braille Options', 'braille'); ?></h3>

			<p><small><?php _e('Here you can select a custom style or you can write an about blurp which appears in the sidebar on the front page and decide the text to be displayed in the first tab in the main menu in the header.', 'braille'); ?></small></p>

			<table cellpadding="5">

			<tr valign="top">
				<th><?php _e('Custom Scheme', 'braille') ?></th>
				<td>
					<select id="braille-scheme" name="braille[scheme]">
						<option value=""<?php selected($scheme_name, ''); ?>><?php _e('No Scheme', 'braille'); ?></option>
					<?php foreach($scheme_files as $scheme_file) { ?>
						<option value="<?php echo($scheme_file); ?>"<?php selected($scheme_name, $scheme_file); ?>><?php echo($scheme_file); ?></option>
					<?php } ?>
					</select>
				</td>
			</tr>

			<tr valign="top">
				<th><?php _e('About Text', 'braille') ?></th>
				<td><textarea id="braille-about" name="braille[about]" rows="5"><?php echo stripslashes(get_option('brailleabout')); ?></textarea></td>
			</tr>

			<tr valign="top">
				<th><?php _e('Menu Home Link', 'braille') ?></th>
				<td><input id="braille-menu" name="braille[menu]" value="<?php echo stripslashes(get_option('braillemenu')); ?>" /></td>
			</tr>
			
			<?php /*<tr valign="top">
				<th><?php _e('Archives', 'braille'); ?></th>
				<td>
					<input name="archives" id="add-archive" type="checkbox" value="add_archive" <?php checked('add_archive', get_option('braillearchives')); ?> />
					<label for="add-archives"><?php _e('Enable the Braille Archives', 'braille'); ?></label>
				</td>
			</tr> */ ?>

			</table>
			
		</div>
		
		<p class="submit">
			<input type="submit" name="submit" value="<?php _e('Update Options', 'braille'); ?> &raquo;" />
		</p>
		
		<div class="configure">

			<h3><?php _e('Uninstall Braille', 'braille'); ?></h3>

			<p><small><?php _e('Pressing the delete button doesn\'t delete any of the Braille theme files nor the Braille theme directory. It simply removes all the Braille settings from the database and reverts back to the default theme.', 'braille'); ?></small></p>

		</div>

<p class="submit">
	<input id="uninstall" name="uninstall" type="submit" value="<?php _e('Delete Options', 'braille'); ?> &raquo;" />
</p>

	</form>
</div>
<div class="wrap">
	<center><p><?php printf(__('Braille is mainly developed by %1$s and %2$s.', 'braille'), '<a href="http://martinhipp.com" title="Martin Hipp">Martin Hipp</a>', '<a href="http://vernetzt.ws/" title="Ralph Inselsbacher">Ralph Inselsbacher</a>'); ?></p></center>
</div>