<?php

class braille_options {
	function init() {
		add_action('admin_menu', array('braille_options', 'add_menu'));

		if($_GET['page'] == 'customize' and isset($_POST['uninstall'])) {
			braille::uninstall();
		}
	}

	function add_menu() {
		add_theme_page(__('Braille Options', 'braille'), __('Braille Options', 'braille'), 5, 'customize', array('braille_options', 'admin'));
	}

	function admin() {
		include(TEMPLATEPATH . '/options/include/display.php');
	}

	function update() {
		if(!empty($_POST)) {
			if(isset($_POST['braille'])) {
				
				if(isset($_POST['about_text'])) {
					update_option('brailleabout', $_POST['about_text'], '','');
				}
				
				if ( isset($_POST['archives']) ) {
					$add = $_POST['archives'];
					update_option('braillearchives', $add, '','');
					archive::create_archive();
				} else {
				// thanks to Michael Hampton, http://www.ioerror.us/ for the assist
					$remove = '';
					update_option('braillearchives', $remove, '','');
					archive::delete_archive();
				}
				
				foreach($_POST['braille'] as $option => $value) {
					update_option('braille' . $option, $value);
				}
				
			}
		}
	}

	function install() {
		add_option('brailleabout', '', 'Allows you to write an about you and your blog.');
		add_option('braillescheme', '', 'Choose the Scheme you want Braille to use.');
		add_option('braillemenu', 'Blog', 'The text on the first tab in the header navigation.');
		add_option('braillearchives', '', 'Setup Braille Archive page');
	}

	function uninstall() {
		delete_option('brailleabout');
		delete_option('braillescheme');
		delete_option('braillemenu');
		// Delete the Archives Page when unistalling Braille
		if ( isset($_POST['archives']) ) {
			delete_option('braillearchives', '', '','');
			archive::delete_archive();
		}
	}
}

add_action('brailleinit', array('braille_options', 'init'), 1);
add_action('brailleinstall', array('braille_options', 'install'));
add_action('brailleuninstall', array('braille_options', 'uninstall'));

?>
