<?php load_theme_textdomain('braille'); ?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN" "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" <?php if ( function_exists('language_attributes') ) { language_attributes(); } ?>>
<head profile="http://gmpg.org/xfn/1">
	<title><?php if (is_single()) { wp_title(''); ?> &middot; <? bloginfo('name'); ?><?php } else { bloginfo('name'); } ?></title>
	<meta http-equiv="Content-Type" content="<?php bloginfo('html_type') ?>; charset=<?php bloginfo('charset'); ?>" />
	<meta name="generator" content="WordPress <?php bloginfo('version'); ?>" />
	<meta name="template" content="Braille <?php braille_info('version'); ?>" />
	<link rel="alternate" type="application/rss+xml" title="<?php _e('RSS 2.0', 'braille'); ?>" href="<?php bloginfo('rss2_url'); ?>" />
	<link rel="alternate" type="application/atom+xml" title="<?php _e('Atom 0.3', 'braille'); ?>" href="<?php bloginfo('atom_url'); ?>" />
	<link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />
	<link rel="stylesheet" type="text/css" media="screen" href="<?php bloginfo('stylesheet_url'); ?>" />
<?php if (get_option('braillescheme') != '') { ?>
	<link rel="stylesheet" type="text/css" media="screen" href="<?php braille_info('scheme'); ?>" />
<?php } ?>
	<link rel="stylesheet" type="text/css" media="print" href="<?php bloginfo('stylesheet_directory'); ?>/print.css" />
	<script src="<?php bloginfo('stylesheet_directory'); ?>/scripts/main.js.php" type="text/javascript"></script>
	<?php wp_head(); ?>
</head>
<body class="<?php braille_body_class(); ?>">
<div id="wrapper">
<div id="header">
	<div id="mast">
		<h1 id="blog-title"><a href="<?php echo get_option('home'); ?>/"><?php bloginfo('name'); ?></a></h1>
		<p id="blog-description"><?php bloginfo('description'); ?></p>
	</div>
	<div id="nav">
		<ul>
		<?php if (get_option('braillemenu') != '') { ?>
			<li class="<?php if ( is_home() or is_archive() or is_single() or is_paged() or is_search()) { ?>current_page_item<?php } else { ?>page_item<?php } ?>"><a href="<?php echo get_settings('home'); ?>/" title="<?php echo get_option('braillemenu'); ?>"><?php echo get_option('braillemenu'); ?></a></li>
		<?php } ?>
			<?php wp_list_pages('sort_column=menu_order&depth=1&title_li='); ?>
		</ul>
	</div>
</div>