<?php

/* Braille Nice Categories - Thanks Mark Jaquith */
function braille_categories($normal_separator = ', ', $penultimate_separator = ' and ') { 
	$categories = get_the_category(); 

	if (empty($categories)) { 
		_e('Uncategorized', 'braille'); 
		return; 
	} 

	$thelist = ''; 
	$i = 1; 
	$n = count($categories); 

	foreach ($categories as $category) { 
		if (1 < $i and $i != $n) {
			$thelist .= $normal_separator;
		}

		if (1 < $i and $i == $n) {
			$thelist .= $penultimate_separator;
		}

		$thelist .= '<a href="' . get_category_link($category->cat_ID) . '" title="' . sprintf("%s", $category->cat_name) . '" rel="tag">'.$category->cat_name.'</a>';
		++$i; 
	} 
	return apply_filters('the_category', $thelist, $normal_separator);
}

/* Braille Admin Bar - Thanks Matt Read */
function braille_admin_control() {
	global $user_identity, $posts;
	
	if ( current_user_can('read') ) { ?>
		<li>
			<h3><?php _e('Admin', 'braille'); ?></h3>
			<ul class="admin-controls">
		<?php if (is_single())
		
		$edit_array = array('<strong>'.__('Edit Post', 'braille').'</strong>', array('edit_post', $posts[0]->ID), 'post.php?action=edit&amp;post='.$posts[0]->ID, 'edit-link');
		
		if (is_page())
		
		$edit_array = array('<strong>'.__('Edit Page', 'braille').'</strong>', array('edit_post', $posts[0]->ID), 'post.php?action=edit&amp;post='.$posts[0]->ID, 'edit-link');
		
		$write_text = (is_single() || is_page()) ? __('Write Post', 'braille') : '<strong>'.__('Write Post', 'braille').'</strong>';
	
		$menu = array(
			array(__('Dashboard', 'braille'), 'read', 'index.php', ''),
			array($write_text, 'edit_posts', 'post-new.php', 'write-link', ''),
			array(__('Add Link', 'braille'), 'manage_links', 'link-add.php', ''),
			$edit_array
			);
		$menu = apply_filters('braille_admin_bar', $menu);
	
		foreach ($menu as $item) {
			list ($name, $user_caps, $url, $class) = $item;
			$class = $class ? ' class="'. $class .'"' : '';
			if (!is_array($user_caps)) $user_caps = array($user_caps);
			
			if ( call_user_func_array('current_user_can', $user_caps) )
				echo "\n\t<li$class><a href='".get_settings('siteurl')."/wp-admin/$url'>$name</a></li>";
		} ?>
			</ul>
		</li>
	<?php }
}

/* Braille Excerpt - Thanks Denis de Bernardy */
function braille_excerpt($text) {
	global $post;
	if ( $text == '' ) {
		$excerpt = apply_filters('the_content', $post->post_content);
		$excerpt = strip_tags($excerpt, '<a><p>');
		str_replace("&#8212;", "-", $excerpt);
		$words = preg_split("/(?<=(\.|!|\?)+)\s/", $excerpt, -1, PREG_SPLIT_NO_EMPTY);
		foreach ( $words as $word ) {
			$new_text = $text . substr($excerpt, 0, strpos($excerpt, $word) + strlen($word));
			$excerpt = substr($excerpt, strpos($excerpt, $word) + strlen($word), strlen($excerpt));
			if ( ( strlen($text) != 0 ) && ( strlen($new_text) > 350 ) ) {
				$text .= "..";
				break;
			}
			$text = $new_text;
		}
	}
	return $text;
}

remove_filter('get_the_excerpt', 'wp_trim_excerpt');
add_filter('get_the_excerpt', 'braille_excerpt');

?>