<?php get_header(); ?>
<?php if (have_posts()) : ?>
<?php $post = $posts[0]; // Hack. Set $post so that the_date() works. ?>
<?php /* If this is a category archive */ if (is_category()) { ?>
<h1 class="headline">Archive for the <?php echo single_cat_title(); ?> category</h1>
<?php /* If this is a daily archive */ } elseif (is_day()) { ?>
<h1 class="headline">Archive for 
  <?php the_time('F jS, Y'); ?>
</h1>
<?php /* If this is a monthly archive */ } elseif (is_month()) { ?>
<h1 class="headline">Archive for 
  <?php the_time('F, Y'); ?>
</h1>
<?php /* If this is a yearly archive */ } elseif (is_year()) { ?>
<h1 class="headline">Archive for 
  <?php the_time('Y'); ?>
</h1>
<?php /* If this is a search */ } elseif (is_search()) { ?>
<h1 class="headline">Search results</h1>
<?php /* If this is an author archive */ } elseif (is_author()) { ?>
<h1 class="headline">Author archive</h1>
<?php /* If this is a paged archive */ } elseif (isset($_GET['paged']) && !empty($_GET['paged'])) { ?>
<h1 class="headline">Blog Archives</h1>
<?php } ?>
<div id="navigation"> 
  <div class="alignleft"> 
    <?php next_posts_link('Previous articles') ?>
  </div>
  <div class="alignright"> 
    <?php previous_posts_link('Next articles') ?>
  </div>
</div>
<?php while (have_posts()) : the_post(); ?>
<div class="article" id="post-<?php the_ID(); ?>"> 
  <h1><a href="<?php the_permalink() ?>" rel="bookmark" title="Permanent link to <?php the_title(); ?>"> 
    <?php the_title(); ?>
    </a></h1>
  <h2>by 
    <?php the_author() ?>
    on 
    <?php the_time('F jS, Y') ?>
  </h2>
  <?php the_content('More'); ?>
  <div class="feedback"> 
    <?php wp_link_pages(); ?>
	 <span class="link-categorie">posted in <?php the_category(', ') ?></span>
    <?php comments_popup_link(__('Comments'), __('1 comments'), __('% comments'), 'link-comentariu', __('Comments off')); ?>
  </div>
</div>
<div class="line"></div>
<?php endwhile; ?>
<div id="navigation"> 
  <div class="alignleft"> 
    <?php next_posts_link('Previous articles') ?>
  </div>
  <div class="alignright"> 
    <?php previous_posts_link('Next articles') ?>
  </div>
</div>
<?php else : ?>
<h2>Not found!</h2>
<?php include (TEMPLATEPATH . '/searchform.php'); ?>
<?php endif; ?></div>
<?php get_footer(); ?>
