<?php get_header(); ?>
<?php if (have_posts()) : while (have_posts()) : the_post(); ?>
<?php $attachment_link = get_the_attachment_link($post->ID, true, array(450, 800)); // This also populates the iconsize for the next line ?>
<?php $_post = &get_post($post->ID); $classname = ($_post->iconsize[0] <= 128 ? 'small' : '') . 'attachment'; // This lets us style narrow icons specially ?>
<div class="article" id="post-<?php the_ID(); ?>"> 
  <h1><a href="<?php echo get_permalink($post->post_parent); ?>" rev="attachment"><?php echo get_the_title($post->post_parent); ?></a> 
    &raquo; <a href="<?php echo get_permalink() ?>" rel="bookmark" title="Permanent link: <?php the_title(); ?>"> 
    <?php the_title(); ?>
    </a></h1>
  <h2>Posted in 
    <?php the_category(', ') ?>
    by 
    <?php the_author() ?>
    on 
    <?php the_time('F jS, Y') ?>
  </h2>
  <div class="entrytext"> 
    <p class="<?php echo $classname; ?>"><?php echo $attachment_link; ?><br />
      <?php echo basename($post->guid); ?></p>
    <?php the_content('More'); ?>
    <?php link_pages('<p><strong>Pages:</strong> ', '</p>', 'number'); ?>
    <div id="metadata"> 
      <?php if (('open' == $post-> comment_status) && ('open' == $post->ping_status)) {
							// Both Comments and Pings are open ?>
      You can <a href="#respond">leave a response</a>, or <a href="<?php trackback_url(true); ?>" rel="trackback">trackback</a> 
      from your own site. 
      <?php } elseif (!('open' == $post-> comment_status) && ('open' == $post->ping_status)) {
							// Only Pings are Open ?>
      Responses are currently closed, but you can <a href="<?php trackback_url(true); ?> " rel="trackback">trackback</a> 
      from your own site. 
      <?php } elseif (('open' == $post-> comment_status) && !('open' == $post->ping_status)) {
							// Comments are open, Pings are not ?>
      You can skip to the end and leave a response. Pinging is currently not allowed. 
      <?php } elseif (!('open' == $post-> comment_status) && !('open' == $post->ping_status)) {
							// Neither Comments, nor Pings are open ?>
      Both comments and pings are currently closed. 
      <?php } comments_rss_link('RSS 2.0'); ?>
      <?php  edit_post_link('Edit','',''); ?>
    </div>
  </div>
  <?php comments_template(); ?>
  <?php endwhile; else: ?>
  <p><span class="highlight">Sorry, no attachments matched your criteria!</span></p>
  <?php endif; ?>
</div>
<?php get_footer(); ?>
