<?php get_header() ?>

<div id="body">

<?php if (have_posts()) : ?>

<?php $post = $posts[0]; // Hack. Set $post so that the_date() works. ?>

<?php /* If this is a category archive */ if (is_category()) { ?>				
<h2 class="pagetitle">Archive for the '<?php echo single_cat_title(); ?>' Category</h2>
		
<?php /* If this is a daily archive */ } elseif (is_day()) { ?>
<h2 class="pagetitle">Archive for <?php the_time('F jS, Y'); ?></h2>
		
<?php /* If this is a monthly archive */ } elseif (is_month()) { ?>
<h2 class="pagetitle">Archive for <?php the_time('F, Y'); ?></h2>

<?php /* If this is a yearly archive */ } elseif (is_year()) { ?>
<h2 class="pagetitle">Archive for <?php the_time('Y'); ?></h2>
		
<?php /* If this is a search */ } elseif (is_search()) { ?>
<h2 class="pagetitle">Search Results</h2>
		
<?php /* If this is an author archive */ } elseif (is_author()) { ?>
<h2 class="pagetitle">Author Archive</h2>

<?php /* If this is a paged archive */ } elseif (isset($_GET['paged']) && !empty($_GET['paged'])) { ?>
<h2 class="pagetitle">Blog Archives</h2>

<?php } ?>

<?php while (have_posts()) : the_post(); ?>

<div class="post" id="post-<?php the_ID(); ?>">
	<h2 class="postitle"><a href="<?php the_permalink() ?>" rel="bookmark" title="Permanent Link to <?php the_title(); ?>"><?php the_title(); ?></a></h2>
	<p class="postmeta"><?php the_time('l, j F Y @ g:ia') ?> &bull; <a href="#">My Weblog</a><?php edit_post_link('Edit',' &bull;',''); ?></p>

	<div class="postentry">
		<?php the_content('More...'); ?>
	</div>

	<p class="postfeedback">
		written by <?php the_author_posts_link() ?>  &bull; 
		<a href="<?php the_permalink() ?>" rel="bookmark" title="Permanent Link to <?php the_title(); ?>">Permalink</a> &bull; 
		<?php comments_popup_link('Comments (0)', 'Comments (1)', 'Comments (%)'); ?> &bull; 
		<a href="<?php the_permalink() ?>#respond" title="Leave a Comment">Leave a Comment &raquo;</a><!-- &bull; <a href="#">New Window</a> -->
	</p>
</div>

<?php endwhile; ?>

<?php posts_nav_link(' &#8212; ', __('&laquo; Previous Page'), __('Next Page &raquo;')); ?>

<?php else : ?>

<h2>Not Found</h2>
<p>Sorry, but you are looking for something that isn't here.</p>
<?php include (TEMPLATEPATH . "/searchform.php"); ?>

<?php endif; ?>
</div>

<?php get_sidebar(); ?>

<?php get_footer(); ?>