<?php
/*
Plugin Name: Del.icio.us widget modded
Description: Adds a sidebar widget to display delicious links with favicon.
Author: Nikynik
Version: 1.0
Author URI: http://www.nikynik.com
*/

if ( !function_exists('register_sidebar_widget') || !function_exists('register_widget_control') )
                return;

 function widget_citrus_delicious_control() {
                $options = $newoptions = get_option('widget_citrus_delicious');
                if ( $_POST['delicious-submit'] ) {
                        $newoptions['title'] = strip_tags(stripslashes($_POST['delicious-title']));
                        $newoptions['username'] = strip_tags(stripslashes($_POST['delicious-username']));
                        $newoptions['count'] = (int) $_POST['delicious-count'];
                        $newoptions['tags'] = explode(' ', trim(strip_tags(stripslashes($_POST['delicious-tags']))));
                }
                if ( $options != $newoptions ) {
                        $options = $newoptions;
                        update_option('widget_citrus_delicious', $options);
                }
        ?>
                                <div style="text-align:right">
                                <label for="delicious-title" style="line-height:35px;display:block;">Widget title: <input type="text" id="delicious-title" name="delicious-title" value="<?php echo htmlspecialchars($options['title']); ?>" /></label>
                                <label for="delicious-username" style="line-height:35px;display:block;">del.icio.us login: <input type="text" id="delicious-username" name="delicious-username" value="<?php echo htmlspecialchars($options['username']); ?>" /></label>
                                <label for="delicious-count" style="line-height:35px;display:block;">Number of links: <input type="text" id="delicious-count" name="delicious-count" value="<?php echo $options['count']; ?>" /></label>
                                <label for="delicious-tags" style="line-height:35px;display:block;">Show only these tags (separated by spaces): <textarea id="delicious-tags" name="delicious-tags" style="width:290px;height:20px;"><?php echo htmlspecialchars(implode(' ', (array) $options['tags'])); ?></textarea></label>
                                <input type="hidden" name="delicious-submit" id="delicious-submit" value="1" />
                                </div>
        <?php
        }

        // This prints the widget
        function widget_citrus_delicious($args) {
                extract($args);
                $defaults = array('count' => 10, 'username' => 'wordpress');
                $options = (array) get_option('widget_citrus_delicious');

                foreach ( $defaults as $key => $value )
                        if ( !isset($options[$key]) )
                                $options[$key] = $defaults[$key];

                $json_url = 'http://del.icio.us/feeds/json/' . rawurlencode($options['username']);
                $json_url.= count($options['tags']) ? '/' . rawurlencode(implode('+', $options['tags'])) : '';
                $json_url.= '?count=' . ((int) $options['count']) . ';';
                ?>

                        <?php echo $before_title . "{$options['title']}" . $after_title; ?><div id="delicious-box" style="margin:0;padding:0;border:none;"> </div>
                        <script type="text/javascript" src="<?php echo $json_url; ?>"></script>
                        <script type="text/javascript">
function showImage(img){ return (function(){ img.style.display='inline' }) }

var ul = document.createElement('ul')
for (var i=0, post; post = Delicious.posts[i]; i++) {
        var li = document.createElement('li')
        var a = document.createElement('a')
        a.style.marginLeft = '20px'
        var img = document.createElement('img')
        img.style.position = 'absolute'
        img.style.display = 'none'
        img.height = img.width = 16
        img.src = post.u.split('/').splice(0,3).join('/')+'/favicon.ico'
        img.onload = showImage(img);
        a.setAttribute('href', post.u)
        a.appendChild(document.createTextNode(post.d))
        li.appendChild(img)
        li.appendChild(a)
        ul.appendChild(li)

}
                        ul.setAttribute('id', 'delicious-list');
                        document.getElementById('delicious-box').appendChild(ul);
</script>

 <?php
}
if ( function_exists('register_sidebar_widget') )
    register_sidebar_widget('Citrus del.icio.us', 'widget_citrus_delicious');
        register_widget_control('Citrus del.icio.us', 'widget_citrus_delicious_control');


?>