<?php
/*
Filename: 		functions.php
Date: 			07-05-01
Copyright: 		2007, CleanJS
Author: 		Adam Walentynowicz (adam@adamw.pl)
Description: 	Wordpress Template with clean look
Requires:
*/

load_theme_textdomain('cleanJS');

class themecleanJS {

	function addOptions () {

		if (isset($_POST['cleanJS_reset'])) { themecleanJS::initOptions(true); }

		if (isset($_POST['cleanJS_save'])) {

			$cleanOptions = themecleanJS::initOptions(false);

			$cleanOptions['errors'] = array();

			$cleanOptions['description'] = stripslashes($_POST['cleanJS_description']);

			$cleanOptions['feedburner'] = $_POST['cleanJS_feedburner'];
			$cleanOptions['feedburner_comments'] = $_POST['cleanJS_feedburner_comments'];
			$cleanOptions['feedburner_id'] = $_POST['cleanJS_feedburner_id'];


			if ($_POST['cleanJS_show_icons'] == 'true') {
				$cleanOptions['show_icons'] = true;
			} else {
				$cleanOptions['show_icons'] = false;
			}
			
			if ($_POST['cleanJS_show_bottom_widgets'] == 'true') {
				$cleanOptions['show_bottom_widgets'] = true;
			} else {
				$cleanOptions['show_bottom_widgets'] = false;
			}


			if ($_POST['cleanJS_show_subpages'] == 'true') {
				$cleanOptions['show_subpages'] = true;
			} else {
				$cleanOptions['show_subpages'] = false;
			}
			
			if ($_POST['cleanJS_show_feedflare'] == 'true') {
				$cleanOptions['show_feedflare'] = true;
			} else {
				$cleanOptions['show_feedflare'] = false;
			}

			if ($_POST['cleanJS_font_replace'] == 'true') {
				$cleanOptions['font_replace'] = true;
			} else {
				$cleanOptions['font_replace'] = false;
			}
			
			if ($_POST['cleanJS_ajax_search'] == 'true') {
				$cleanOptions['ajax_search'] = true;
			} else {
				$cleanOptions['ajax_search'] = false;
			}
			
			if ($_POST['cleanJS_ajax_comments'] == 'true') {
				$cleanOptions['ajax_comments'] = true;
			} else {
				$cleanOptions['ajax_comments'] = false;
			}

			update_option('cleanJS_theme', $cleanOptions);

		}
		
		add_theme_page("CleanJS WEB2.0 look", "CleanJS - Theme Options", 'edit_themes', basename(__FILE__), array('themecleanJS', 'displayOptions'));
	}
	
	function initOptions ($bReset) {
		$cleanOptions = get_option('cleanJS_theme');
		if (!is_array($cleanOptions) || $bReset) {

			$cleanOptions['description'] = '<span><strong>Welcome to ' . get_bloginfo('name') . '</strong></span><p>Thank you for taking the time to visit my blog!  Take a second to peek around and check out some of my previous posts.  Of course, I would love to find out what you think as well, so make sure to comment.  See you around!</p><p><a href="?page_id=2"><span>Find out more...</span></a></p>';
			$cleanOptions['feedburner'] = '';
			$cleanOptions['feedburner_comments'] = '';
			$cleanOptions['feedburner_id'] = '';
			$cleanOptions['show_icons'] = true;
			$cleanOptions['show_bottom_widgets'] = true;
			$cleanOptions['archives_cat'] = 'Uncategorized';
			$cleanOptions['show_subpages'] = true;
			$cleanOptions['show_feedflare'] = false;
			$cleanOptions['font_replace'] = true;
			$cleanOptions['ajax_search'] = true;
			$cleanOptions['ajax_comments'] = true;
			update_option('cleanJS_theme', $cleanOptions);
		}
		return $cleanOptions;
	}

	function displayOptions () {
		$cleanOptions = themecleanJS::initOptions(false);

?>
<div class="wrap">
	<h2>CleanJS - WEB 2.0 look</h2>
	
<?php
	if (count($cleanOptions['errors']) > 0) {
		echo ('<div class="error"><p>' . __('The following errors occured when saving your options:', 'cleanJS') . '</p><ul>');
		foreach($cleanOptions['errors'] as $sError) {
			echo ('<li>' . $sError . '</li>');
		}
		echo ('</ul></div>');
		$cleanOptions['errors'] = array();
		update_option('cleanJS_theme', $cleanOptions);
	}
?>
	<form action="#" method="post" enctype="multipart/form-data" name="cleanJS_form" id="cleanJS_form">
		<fieldset name="general_options" class="options">
			<legend><?php _e('Theme Specific Options', 'cleanJS'); ?></legend>
			<table width="100%" cellspacing="2" cellpadding="5" class="editform"> 

				<tr valign="top"> 
					<th width="33%" scope="row"><?php _e('Show Post Icons', 'cleanJS'); ?></th> 
					<td><?php if ($cleanOptions['show_icons'] == true) { echo ('<input name="cleanJS_show_icons" type="checkbox" value="true" checked>'); } else { echo ('<input name="cleanJS_show_icons" type="checkbox" value="true">'); } ?> <?php _e('Show Icons : author, date, comment, permalink, trackback link, comment feed on home page on the left of each Post.', 'cleanJS'); ?></td> 
				</tr>
				
				<tr valign="top"> 
					<th width="33%" scope="row"><?php _e('Show Bottom Widgets', 'cleanJS'); ?></th> 
					<td><?php if ($cleanOptions['show_bottom_widgets'] == true) { echo ('<input name="cleanJS_show_bottom_widgets" type="checkbox" value="true" checked>'); } else { echo ('<input name="cleanJS_show_bottom_widgets" type="checkbox" value="true">'); } ?> <?php _e('Show Bottom Widgets : by default, Recent Posts, Recent Comments', 'cleanJS'); ?></td> 
				</tr>

				<tr valign="top"> 
					<th width="33%" scope="row"><?php _e('Replace heading fonts', 'cleanJS'); ?></th> 
					<td><?php if ($cleanOptions['font_replace'] == true) { echo ('<input name="cleanJS_font_replace" type="checkbox" value="true" checked>'); } else { echo ('<input name="cleanJS_font_replace" type="checkbox" value="true">'); } ?> <?php _e('Replace heading fonts with flash objects', 'cleanJS'); ?></td> 
				</tr>

				<tr valign="top"> 
					<th width="33%" scope="row"><?php _e('Show Sub-Pages', 'cleanJS'); ?></th> 
					<td><?php if ($cleanOptions['show_subpages'] == true) { echo ('<input name="cleanJS_show_subpages" type="checkbox" value="true" checked>'); } else { echo ('<input name="cleanJS_show_subpages" type="checkbox" value="true">'); } ?> <?php _e('Show sub-pages when viewing a page.', 'cleanJS'); ?></td> 
				</tr>
				
				<tr valign="top"> 
					<th width="33%" scope="row"><?php _e('Enable AJAX Search', 'cleanJS'); ?></th> 
					<td><?php if ($cleanOptions['ajax_search'] == true) { echo ('<input name="cleanJS_ajax_search" type="checkbox" value="true" checked>'); } else { echo ('<input name="cleanJS_ajax_search" type="checkbox" value="true">'); } ?></td> 
				</tr>
				
				<tr valign="top"> 
					<th width="33%" scope="row"><?php _e('Enable AJAX Comments', 'cleanJS'); ?></th> 
					<td><?php if ($cleanOptions['ajax_comments'] == true) { echo ('<input name="cleanJS_ajax_comments" type="checkbox" value="true" checked>'); } else { echo ('<input name="cleanJS_ajax_comments" type="checkbox" value="true">'); } ?></td> 
				</tr>
				
				<tr valign="top"> 
					<th width="33%" scope="row"><?php _e('Site Description', 'cleanJS'); ?></th> 
					<td><textarea name="cleanJS_description" cols="50" rows="10" id="cleanJS_description"><?php echo($cleanOptions['description']); ?></textarea><br /><?php _e('If a description for the site is given here, it will be displayed as a prominent information box on the home page.', 'cleanJS'); ?></td> 
				</tr>

			</table>
		</fieldset>


		<fieldset name="feedburner_options" class="options">
			<legend><?php _e('Feedburner Options', 'cleanJS'); ?></legend>
			<p><?php _e('Make reading your RSS feeds easier for your audience by signing up with <a href="http://www.feedburner.com">FeedBurner</a>.', 'cleanJS'); ?></p>
			<table width="100%" cellspacing="2" cellpadding="5" class="editform"> 
				<!--<tr valign="top"> 
					<th width="33%" scope="row"><?php _e('E-mail Subscription (Feed ID)', 'cleanJS'); ?></th> 
					<td><input name="cleanJS_feedburner_id" type="text" id="cleanJS_feedburner_id" value="<?php echo($cleanOptions['feedburner_id']); ?>" size="50" /><br /><?php _e('If you have enabled e-mail subscriptions, type the numeric ID for your feed.  You can find this by going to "My Feeds" and then clicking on the feed for this blog.  The URL will end with "?id=XXXXXXX" - that number is the Feed ID.', 'cleanJS'); ?></td> 
				</tr>-->
				<tr valign="top"> 
					<th width="33%" scope="row"><?php _e('Feedburner Posts Link', 'cleanJS'); ?></th> 
					<td><input name="cleanJS_feedburner" type="text" id="cleanJS_feedburner" value="<?php echo($cleanOptions['feedburner']); ?>" size="50" /><br /><?php _e('The URL that people go to for Posts feed.', 'cleanJS'); ?></td> 
				</tr>
				<tr valign="top"> 
					<th width="33%" scope="row"><?php _e('Feedburner Comments Link', 'cleanJS'); ?></th> 
					<td><input name="cleanJS_feedburner_comments" type="text" id="cleanJS_feedburner_comments" value="<?php echo($cleanOptions['feedburner_comments']); ?>" size="50" /><br /><?php _e('The URL that people go to for Comments feed.', 'cleanJS'); ?></td> 
				</tr>
				<tr valign="top"> 
					<th width="33%" scope="row"><?php _e('Show Feedflare', 'cleanJS'); ?></th> 
					<td><?php if ($cleanOptions['show_feedflare'] == true) { echo ('<input name="cleanJS_show_feedflare" type="checkbox" value="true" checked>'); } else { echo ('<input name="cleanJS_show_feedflare" type="checkbox" value="true">'); } ?> <?php _e('Show FeedFlare on my posts.', 'cleanJS'); ?></td> 
				</tr>
			</table>
		</fieldset>

		<p class="submit"><input type="submit" name="cleanJS_reset" value="Reset" /></p>
		<p class="submit"><input type="submit" name="cleanJS_save" value="Save" /></p>
	</form>
</div>
<?php
	}
}

    
// Register functions
add_action('admin_menu', array('themecleanJS', 'addOptions'));

// Add widget support
if ( function_exists('register_sidebar') ) {

	register_sidebars(1, array('name' => 'Sidebar', 'before_widget' => '<div id="%1$s" class="widget sidebar %2$s">', 'after_widget' => '</div>', 'before_title' => '<h2>', 'after_title' => '</h2>') );
	register_sidebars(1, array('name' => 'Navigation', 'before_widget' => '<div id="%1$s" class="widget top %2$s">', 'after_widget' => '</div>', 'before_title' => '<h2>', 'after_title' => '</h2>') );
	register_sidebars(3, array('name' => 'Bottom_%d', 'before_widget' => '<div id="%1$s" class="widget bottom %2$s">', 'after_widget' => '</div>', 'before_title' => '<h2>', 'after_title' => '</h2>') );
	register_sidebars(3, array('name' => 'Advert_%d', 'before_widget' => '<div id="%1$s" class="advert %2$s">', 'after_widget' => '</div>', 'before_title' => '<h2>', 'after_title' => '</h2>') );
}


function widget_cleanJS_search() { ?>

	<h2><?php _e('Search', 'cleanJS'); ?></h2>

	<form method="get" id="search_box" action="<?php echo $_SERVER['PHP_SELF']; ?>">
		<input type="text" value="" name="s" id="search_input" class="input" />
		<input type="submit"  align="middle" id="searchsubmit" value="&nbsp" />
	</form>

<?php }

 

function widget_cleanJS_links() { ?>

    <h2><?php _e('Blogroll', 'cleanJS'); ?></h2>
    <ul>
    <?php get_links(-1, '<li>', '</li>', ' &raquo; ', FALSE, 'category', TRUE); ?>
    </ul>

<?php }

 

function widget_cleanJS_pages() { ?>

    <h2><?php _e('Pages', 'cleanJS'); ?></h2>
    <ul>
    <?php wp_list_pages('sort_column=menu_order&depth=1&title_li='); ?>
    </ul>

<?php }

function widget_cleanJS_recentcomments() { ?>
	<?php global $wpdb;
	$comments = $wpdb->get_results("SELECT comment_author, comment_author_url, comment_ID, comment_post_ID FROM $wpdb->comments WHERE comment_approved = '1' GROUP BY comment_post_ID ORDER BY comment_date_gmt DESC LIMIT 6"); ?>
	<h2><?php _e("Recently Commented", 'cleanJS'); ?></h2>
	<?php
	if ( $comments ) : 
		?> <ul id="recentcomments"> <?php
		foreach ($comments as $comment) :
			echo  '<li class="recentcomments">' . sprintf(__('%2$s'), get_comment_author_link(), '<a href="'. get_permalink($comment->comment_post_ID) .'#commentsLooper">' . get_the_title($comment->comment_post_ID) . '</a>') . '</li>';
		endforeach; 
		?> </ul> <?php
	endif;?>
<?php }	

					
function widget_cleanJS_recentposts() { 
	$r = new WP_Query('showposts=6');
	if ($r->have_posts()) : ?>
		<h2><?php _e('Recent Posts', 'cleanJS'); ?></h2>
		<ul id="recentposts">
		<?php  while ($r->have_posts()) : $r->the_post(); ?>
			<li><a href="<?php the_permalink() ?>"><?php if ( get_the_title() ) the_title(); else the_ID(); ?> </a></li>
		<?php endwhile; ?>
		</ul>
	<?php endif;
}	

if ( function_exists('register_sidebar_widget') ) {
register_sidebar_widget(__('Search'), 'widget_cleanJS_search');
register_sidebar_widget(__('Links'), 'widget_cleanJS_links');
register_sidebar_widget(__('Pages'), 'widget_cleanJS_pages');
register_sidebar_widget(__('Recent Comments'), 'widget_cleanJS_recentcomments');
register_sidebar_widget(__('Recent Posts'), 'widget_cleanJS_recentposts'); } 

?>