<?php
/*
Filename: 		header.php
Date: 			07-05-01
Copyright: 		2007, CleanJS
Author: 		Adam Walentynowicz (adam@adamw.pl)
Description: 	Wordpress Template with clean look
Requires:
*/

$cleanOptions = themecleanJS::initOptions(false);
$cleanOptions = get_option('cleanJS_theme');
load_theme_textdomain('cleanJS');

?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head profile="http://gmpg.org/xfn/11">
	<meta http-equiv="Content-Type" content="<?php bloginfo('html_type'); ?>; charset=<?php bloginfo('charset'); ?>" />
	<meta name="generator" content="WordPress <?php bloginfo('version'); ?>" /> <!-- leave this for stats -->
	
	<?php wp_head(); ?>
	
	<title>
		<?php if (is_home () ) { bloginfo('name'); }
		elseif ( is_category() ) { single_cat_title(); echo " in "; bloginfo('name'); }
		elseif (is_single() ) { single_post_title(); echo " on "; bloginfo('name'); }
		elseif (is_page() ) { single_post_title(); echo " - "; bloginfo('name'); }
		elseif (is_search() ) { echo wp_specialchars($s); echo " in "; bloginfo('name'); }
		elseif (is_archive() ) {  _e("Archives", 'cleanJS'); echo " on "; bloginfo('name'); }
		else { wp_title('',true); } ?>
	</title>

	<link href="<?php bloginfo('stylesheet_directory'); ?>/css/screen.css" rel="stylesheet" media="all" type="text/css" />
	
	<!--[if lte IE 6]>
	<link href="<?php bloginfo('stylesheet_directory'); ?>/css/ie-screen.css" rel="stylesheet" media="all" type="text/css" />
	<script type='text/javascript' src='<?php bloginfo('stylesheet_directory'); ?>/js/pngfix.js'></script>
	<![endif]-->

	<link rel="shortcut icon" type="image/x-icon" href="<?php bloginfo('template_directory'); ?>/favicon.ico" />
	
	<script type="text/javascript" src="<?php bloginfo('template_directory'); ?>/js/prototype.js.php"></script>
    <script type="text/javascript" src="<?php bloginfo('template_directory'); ?>/js/effects.js.php"></script>
    
    <?php if ($cleanOptions['ajax_search']) : ?>
    <script type='text/javascript' src='<?php bloginfo('stylesheet_directory'); ?>/js/search.js.php'></script>
    <?php endif; ?>
    
    
    
	<?php if (is_single() and ('open' == $post-> comment_status) or ('comment' == $post-> comment_type) ) { ?>
        <?php if ($cleanOptions['ajax_comments']) : ?>
        <script type="text/javascript" src="<?php bloginfo('template_directory'); ?>/js/ajax_comments.js"></script>
        <?php endif; ?>
	<?php } ?>
	
	<?php if ($cleanOptions['font_replace']) : ?>
	<script src="<?php bloginfo('stylesheet_directory'); ?>/js/sIFR/sifr.js" type="text/javascript"></script>
	<link href="<?php bloginfo('stylesheet_directory'); ?>/js/sIFR/sIFR-print.css" rel="stylesheet" media="print" type="text/css" />
	<link href="<?php bloginfo('stylesheet_directory'); ?>/js/sIFR/sIFR-screen.css" rel="stylesheet" media="screen" type="text/css" />
	<?php endif; ?>
	
	
	<?php if (isset($cleanOptions['feedburner']) && $cleanOptions['feedburner'] != "") : ?>
	<link rel="alternate" type="application/rss+xml" title="RSS 2.0 - Feedburner" href="<?php echo $cleanOptions['feedburner']; ?>" />
	<?php else : ?>
	<link rel="alternate" type="application/rss+xml" title="RSS 2.0" href="<?php bloginfo('rss2_url'); ?>" />
	<link rel="alternate" type="text/xml" title="RSS .92" href="<?php bloginfo('rss_url'); ?>" />
	<link rel="alternate" type="application/atom+xml" title="Atom 0.3" href="<?php bloginfo('atom_url'); ?>" />
	<?php endif; ?>

	<?php global $wp_version; global $wpmu_sitefeed; if (is_object($wpmu_sitefeed)) : ?>
	<?php global $wpmu_feed; if ($wpmu_feed == '') { $wpmu_feed = get_bloginfo('home') . "/wpmu_feed/"; } ?>
	<link rel="alternate" type="application/rss+xml" title="RSS 2.0 - Master Feed" href="<?php echo($wpmu_feed); ?>" />
	<?php endif; ?>	

	<?php if (is_single() or is_page() or is_home()) { ?>
	<link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />
	<?php } ?>
	
	<?php wp_get_archives('type=monthly&format=link'); ?>
	
</head>

<body>
<div id="container">
	<div id="container1">
		<div id="absoluteTopNavi">
			<div class="content">
				<div style="float:left;">
				
				<a href="javascript:void(0)" onclick="Element.setContentZoom('contentWrapper', 80); new Effect.Appear('contentWrapper');" title="Make the text smaller"><span class="icon Ifontsmaller">&nbsp;</span></a>
				<a href="javascript:void(0)" onclick="Element.setContentZoom('contentWrapper', 100); new Effect.Appear('contentWrapper');" title="Reset the size of text"><span class="icon Ifontnormal">&nbsp;</span></a>
				<a href="javascript:void(0)" onclick="Element.setContentZoom('contentWrapper', 130); new Effect.Appear('contentWrapper');" title="Make the text bigger"><span class="icon Ifontlarger">&nbsp;</span></a>
				
				<?php if (!is_user_logged_in()) : ?>
					<a href="<?php echo get_settings('home'); ?>/wp-login.php" title="<?php _e('Login', 'cleanJS'); ?>"><span class="iconText Ilogin"><?php _e('Login', 'cleanJS'); ?></span></a>
					<?php else : ?>
					<a href="<?php echo get_settings('home'); ?>/wp-admin/" title="<?php _e('Admin', 'cleanJS'); ?>"><span class="iconText Iadmin"><?php _e('Admin', 'cleanJS'); ?></span></a>
					<a href="<?php echo get_settings('home'); ?>/wp-login.php?action=logout" title="<?php _e('Logout', 'cleanJS'); ?>"><span class="iconText Ilogout"><?php _e('Logout', 'cleanJS'); ?></span></a>
				<?php endif; ?>
				</div>
				
				<div style="float:right;">
				<a href="javascript:void(0)" onclick="new Effect.ScrollTo('footer', {duration: 1});" title="<?php _e('Go to the bottom', 'cleanJS'); ?>"><span class="iconText Icontent"><?php _e('Bottom', 'cleanJS'); ?></span></a>
				<a href="javascript:void(0)" onclick="new Effect.ScrollTo('contentWrapper', {duration: 1});" title="<?php _e('Go to content', 'cleanJS'); ?>"><span class="iconText Icontent"><?php _e('Content', 'cleanJS'); ?></span></a>
				<a href="javascript:void(0)" onclick="location.reload(true);" title="<?php _e('Refresh the page', 'cleanJS'); ?>"><span class="iconText Irefresh"><?php _e('Refresh', 'cleanJS'); ?></span></a>
				</div>
			</div>
		</div>
		<!---->
		<div id="header" >
			<div class="content">
				

				<form method="get" id="search_box" action="<?php echo $_SERVER['PHP_SELF']; ?>">
					<input type="text" value="" name="s" id="search_input" class="input" />
					<input type="submit"  align="middle" id="searchsubmit" value="&nbsp;&nbsp;&nbsp;" />
				</form>
				
				<div id="logo">
					<a href="<?php echo get_settings('home'); ?>" title="<?php bloginfo('name'); ?> - <?php bloginfo('description'); ?>"></a>
				</div>

				<div class="title">
					<h1><a href="<?php echo get_settings('home'); ?>" title="<?php bloginfo('name'); ?> - <?php bloginfo('description'); ?>"><?php bloginfo('name'); ?></a></h1>
				</div>
				
				

				<div id="topMenu">
					
					
					<?php
					global $wp_query;
					$thePostID = $wp_query->post->ID;
					$thePost_parent = $wp_query->post->post_parent;
					
					$mainPages = $wpdb->get_results("SELECT ID, guid, post_title, post_type, post_parent FROM " . $wpdb->posts . " WHERE post_parent='0' AND post_type='page' AND post_status='publish' ORDER BY menu_order");
					if ($mainPages) {
					?> <ul class="menu"> 
							<li class="page_item <?php if (is_home()) { ?> current_page_item <?php } ?>"><a href="<?php echo get_settings('home'); ?>" title="<?php _e('Blog', 'cleanJS'); ?>"><span class="tabs"><?php _e('Blog', 'cleanJS'); ?></span></a></li>
						<?php
						foreach ($mainPages as $onePage) {
									$url = get_permalink($onePage->ID);
									$arc_title = $onePage->post_title;
			
									if ($arc_title) $text = strip_tags($arc_title);
									else $text = $arcresult2->ID;
									
									$title_text = wp_specialchars($text, 1); 
									?>
			
						<li class="page_item<?php if (is_page($onePage->ID)) {?> current_page_item<?php } ?><?php if(get_the_title($thePost_parent) == $onePage->post_title) { ?> current_page_parent<?php } ?>"><a href="<?php echo $url; ?>" title="<?php echo $title_text; ?>"><span class="tabs"><?php echo wptexturize($text); ?></span></a></li>
						<?php
						}
						?> </ul> <?php
					}
					?>

					
					
				</div>
				
				
			</div>
		</div>
		
		<div id="mainMenu" >
			<div class="content">
				<div id="subMenu">
				<ul id="menu">
					<?php 
					if ($cleanOptions['show_subpages']) : 
					if (is_page() && $thePost_parent == '0') { 
					
						global $subPages;
						$subPages = $wpdb->get_results("SELECT ID, guid, post_title, post_type, post_parent FROM " . $wpdb->posts . " WHERE post_parent='" . $thePostID . "' AND post_type='page' AND post_status='publish' ORDER BY menu_order");
						if ($subPages) {
							?><li><span class="iconText Ibulb"><?php _e("Sub-pages: ", 'cleanJS'); ?></span></li><?php
							foreach ($subPages as $secondPage) {
										$url = get_permalink($secondPage->ID);
										$arc_title = $secondPage->post_title;
				
										if ($arc_title) $text = strip_tags($arc_title);
										else $text = $arcresult2->ID;
										
										$title_text = wp_specialchars($text, 1); 
										?>
				
							<li class="page_item<?php if (is_page($secondPage->ID)) {?> current_page_item<?php } ?><?php if(get_the_title($thePost_parent) == $secondPage->post_title) { ?> current_page_parent<?php } ?>"><a href="<?php echo $url; ?>" title="<?php echo $title_text; ?>"><?php echo wptexturize($text); ?></a></li>
							<?php
							}
						}
					}
					elseif (is_page() && $thePost_parent != '0') {
						global $levelPages;
						$levelPages = $wpdb->get_results("SELECT ID, guid, post_title, post_type, post_parent FROM " . $wpdb->posts . " WHERE post_parent='" . $thePost_parent . "' AND post_type='page' AND post_status='publish' ORDER BY menu_order");
						if ($levelPages) {
							?><li><span class="iconText Ibulb"><?php _e("Sub-pages: ", 'cleanJS'); ?></span></li><?php
							foreach ($levelPages as $levelPage) {
									$url = get_permalink($levelPage->ID);
									$arc_title = $levelPage->post_title;
			
									if ($arc_title) $text = strip_tags($arc_title);
									else $text = $arcresult2->ID;
									
									$title_text = wp_specialchars($text, 1); 
									?>
			
						<li class="page_item<?php if (is_page($levelPage->ID)) {?> current_page_item<?php } ?><?php if(get_the_title($thePost_parent) == $levelPage->post_title) { ?> current_page_parent<?php } ?>"><a href="<?php echo $url; ?>" title="<?php echo $title_text; ?>"><?php echo wptexturize($text); ?></a></li>
						<?php
							}
						}
					}
					endif;
					?>
					<li class="navi"><a href="javascript:void(0)" id="navigationClick" title="<?php _e("Click to show navigation", 'cleanJS'); ?>"><span class="iconText Icontent"><?php _e("navigation", 'cleanJS'); ?></span></a></li>
				</ul>
				</div>
			</div>
		</div>
		
<!-- Top Navigation Start -->		
		

<!-- Top Navigation End -->
		
<!-- Content Start -->		
		<div id="contentWrapper">

			<div class="content">		
				
				<div id="navTop" style="display: none;"><div>
						
						<div id="categories">
							<h2><?php _e("Categories: ", 'cleanJS'); ?></h2>
							<ul>
							<?php wp_list_categories('orderby=name&hierarchical=0&show_count=1&title_li='); ?>
							</ul>
						</div>
						
						<?php if ( !function_exists('dynamic_sidebar') || !dynamic_sidebar('Navigation') ) { ?>
								<br class="clear" />
						<?php } ?>
		
						<div class="bar"></div>
				
				</div></div>
				
				
				<div id="Advert-1" class="advert">
				<?php if ( !function_exists('dynamic_sidebar') || !dynamic_sidebar('Advert_1') ) { } ?>
				</div>
				
				