<?php
/*
Filename: 		comments.php
Date: 			07-05-01
Copyright: 		2007, CleanJS
Author: 		Adam Walentynowicz (adam@adamw.pl)
Description: 	Wordpress Template with clean look
Requires:
*/
$cleanOptions = get_option('cleanJS_theme');
load_theme_textdomain('cleanJS');


// Do not delete these lines
if ('comments.php' == basename($_SERVER['SCRIPT_FILENAME'])) { die (__('Please do not load this page directly. Thanks!', 'cleanJS')); }

if (!empty($post->post_password)) { // if there's a password
	if ($_COOKIE['wp-postpass_' . COOKIEHASH] != $post->post_password) {  // and it doesn't match the cookie
		echo('<p class="nocomments">' . __("This post is password protected. Enter the password to view comments.", 'cleanJS') . '<p>');
		return;
	}
}

$iCommentCount = 0;

?>




	<div id="commentsLooper">
	
		
		<h2><?php _e("Reader Comments: ", 'cleanJS'); ?></h2>
	<ol class="commentlist" id="commentlist">	
<?php if ($comments) : ?>
	
<?php foreach ($comments as $comment) : ?>
		
		<li>
		<!--<a name="comment-<?php comment_ID() ?>"></a>-->
		<div id="comment-<?php comment_ID() ?>" 
		<?php 
		$comment_author_url = preg_replace('|/+$|', '', $comment->comment_author_url);
		if ($comment_author_url == get_settings('home')) { ?> 
		class="commentAdmin"> 
		<?php } else { ?>
		class="comment">
		<?php } ?>
			<div class="commentTopInfo">
				<ul>
					<li><a href="javascript:void(0)" onclick="new Effect.ScrollTo('container', {duration: 1});" title="<?php _e('Go to the top', 'cleanJS'); ?>"><span class="iconText Itop">&nbsp;</span></a></li>
					<li><a href="#comment-<?php comment_ID() ?>" title="<?php _e('Permalink to this comment', 'cleanJS'); ?>"><span class="iconText Idate"><?php comment_date() ?></span></a></li>
					<li><span class="iconText Itime"><?php comment_time() ?></span></li>
					<li><span class="iconText Iauthor"><?php comment_author_link(); ?></span></li>
					<li><a href="#comment-<?php comment_ID() ?>" title="<?php _e('Permalink to this comment'); ?>"><?php $iCommentCount++; echo($iCommentCount); ?></a></li>
				</ul>
			</div>
			
			<!--<div class="commentSideInfo">
				<ul>
					<li><span class="iconText Iauthor"><a href="<?php //comment_author_url(); ?>" title="<?php //comment_author(); ?>"><?php //comment_author(); ?></a></span></li>
					<li><span class="iconText Idate"><?php //comment_date() ?></span></li>
					<li><span class="iconText Itime"><?php //comment_time() ?></span></li>
					<li><div class="commentsNr"><a href="#comment-<?php //comment_ID() ?>" title="<?php //_e('Permalink to this comment'); ?>"><?php //$iCommentCount++; echo($iCommentCount); ?></a></div></li>
				</ul>
			</div>-->
			
			<div class="commentContent">
				<?php //if ($comment->comment_approved == '0') { echo('<p>Your comment is awaiting moderation.</p>'); } ?>
				<?php comment_text(); ?>
			</div>
			<br class="clear" />
		</div>
		</li>
		
	
<?php endforeach; ?>
	</ol>
<?php else : ?>
	
	<?php if ('open' == $post->comment_status) : ?> 
				<li id="hidelist" style="display:none"></li>
				</ol>
				<p><?php _e("Be the first to leave a comment!", 'cleanJS'); ?></p>
				
	<?php else :  ?>
				<li style="display:none"></li>
				</ol>
				<p><?php _e("Sorry, comments are closed.", 'cleanJS'); ?></p>
				
	<?php endif; ?>
		
<?php endif; ?>	

	</div>
	
<?php if ('open' == $post->comment_status) : ?>	
<div id="comment_area">	

<div id="loading" style="display: none;"><?php _e('Posting your comment...','cleanJS'); ?></div>
<div id="errors" class="alert" style="display: none;"></div>	
	
		<!--<h2 id="respond" class="reply"><?php //if (isset($_GET['jal_edit_comments'])) { _e('Edit Your Comment','cleanJS'); } else { _e('Leave a Reply','cleanJS'); } ?></h2>-->
		
		<?php if (get_option('comment_registration') and !$user_ID) { ?>
		
			<p><?php printf(__('You must <a href="%s">login</a> to post a comment.','cleanJS'), get_option('siteurl') . '/wp-login.php?redirect_to=' . get_permalink()); ?></p>
		
		<?php } else { ?>

<form id="commentform" action="<?php echo get_option('siteurl'); ?>/wp-comments-post.php" method="post" <?php if ($cleanOptions['ajax_comments']) : ?> onsubmit="new Ajax.Updater({success: 'commentlist'}, '<?php bloginfo('stylesheet_directory') ?>/comments-ajax.php', {asynchronous: true, evalScripts: true, insertion: Insertion.Bottom, onComplete: function(request){complete(request)}, onFailure: function(request){failure(request)}, onLoading: function(request){loading()}, parameters: Form.serialize(this)}); return false;"<?php endif; ?>>			

			<?php
				if ( isset($_GET['jal_edit_comments']) ) {
					$jal_comment = jal_edit_comment_init();

					if (!$jal_comment) {
						return;
					}
				} elseif ($user_ID) {
			?>
		
			<p class="comment-login"><?php printf(__('Logged in as %s.','cleanJS'), '<a href="'.get_option('siteurl').'/wp-admin/profile.php">'.$user_identity.'</a>'); ?> <a href="<?php echo get_option('siteurl'); ?>/wp-login.php?action=logout" title="<?php _e('Log out of this account','cleanJS'); ?>"><?php _e('Logout','cleanJS'); ?> &raquo;</a></p>
	
		<?php } elseif ('' != $comment_author) { ?>

				<p class="comment-welcomeback"><?php printf(__('Welcome back <strong>%s</strong>','cleanJS'), $comment_author); ?>
				<!--<span id="showinfo">(<a href="javascript:ShowUtils();"><?php _e('Change','cleanJS'); ?></a>)</span>
				<span id="hideinfo">(<a href="javascript:HideUtils();"><?php _e('Close','cleanJS'); ?></a>)</span>--></p>

		<?php } ?>
			
			<?php if (!$user_ID) { ?>
				<div id="comment-personaldetails">
					<p><input type="text" name="author" id="author" value="<?php echo $comment_author; ?>" size="22" tabindex="1" />
					<label for="author"><small><strong><?php _e('Name','cleanJS'); ?></strong> <?php if ($req) { __('(required)','cleanJS'); } ?></small></label></p>

					<p><input type="text" name="email" id="email" value="<?php echo $comment_author_email; ?>" size="22" tabindex="2" />
					<label for="email"><small><strong><?php _e('Mail','cleanJS'); ?></strong> (<?php _e('will not be published','cleanJS'); ?>) <?php if ($req) { __('(required)','cleanJS'); } ?></small></label></p>

					<p><input type="text" name="url" id="url" value="<?php echo $comment_author_url; ?>" size="22" tabindex="3" />
					<label for="url"><small><strong><?php _e('Website','cleanJS'); ?></strong></small></label></p>
				</div>
			<?php } ?>
				<p><small><?php printf(__('<strong>XHTML:</strong> You can use these tags %s:','cleanJS'), allowed_tags()) ?></small></p>
		
				<p><textarea name="comment" id="comment" cols="100%" rows="10" tabindex="4"><?php if (function_exists('jal_edit_comment_link')) { jal_comment_content($jal_comment); }; if (function_exists('quoter_comment_server')) { quoter_comment_server(); } ?></textarea></p>
		
				<?php if (function_exists('show_subscription_checkbox')) { show_subscription_checkbox(); } ?>
				<?php if (function_exists('quoter_page')) { quoter_page(); } ?>

				<p>
					<span class="button"><input name="submit" type="submit" id="submit" tabindex="5" value="<?php _e('Submit','cleanJS'); ?>" /></span>
					<input type="hidden" name="comment_post_ID" value="<?php echo $id; ?>" />
				</p>
				
				<br class="clear" />

				<?php do_action('comment_form', $post->ID); ?>

			</form>

		<?php } // If registration required and not logged in ?>	
	
	<br class="clear" />

</div>
<?php endif; ?>
<br class="clear" />