<hr class="low" />

<!-- subcontent ................................. -->
<div id="subcontent" class="pkg">

<?php 
/* Uncomment this section if you need to have more page navigation than the top
	navigation bar allows.  You'll still be able to have a few of the default
	pages appear at the top (the one's that the Blix theme excludes by default).
**
?>
	<h2><em>Pages</em></h2>
	<ul class="pages">
	<?php
		$excluded = my_excluded_pages();
		wp_list_pages('title_li=&sort_column=menu_order&exclude='.$excluded);
	?>
	</ul>
<?php  */ ?>


<?php if (is_home()) { ?>
	<?php
	/**
	 * If a page called "about_short" has been set up its content will be put here.
	 * In case that a page called "about" has been set up, too, it'll be linked to via 'More'.
	 */
	$pages = my_get_pages();
	if ($pages) {
		foreach ($pages as $page) {
			$page_id = $page->ID;
   			$page_title = $page->post_title;
   			$page_name = $page->post_name;
   			$page_content = $page->post_content;

   			if ($page_name == "about") $more_url = '<a href="'.get_page_link($page_id).'" class="more">More</a>';
   			if ($page_name == "about_short") {
   				$about_title = $page_title;
   				$about_text = BX_remove_p($page_content);
   			}
		}
		if ($about_text != "") {
			echo "<h2><em>".$about_title."</em></h2>\n";
			echo "".$about_text;
			if ($more_url != "") echo " ".$more_url;
			echo "\n";
		}
	}   
	?>
<?php } ?>


<?php if (is_home() || is_page("archives") || is_archive() || is_search() || is_single()) { ?>
	<h2><em>Search</em></h2>
	<div id="search">
			<form method="get" action="<?php echo $_SERVER['PHP_SELF']; ?>">             <fieldset>
				<input class="searchfield" value="<?php echo wp_specialchars($s, 1); ?>" type="text" name="s" id="s" title="Enter keyword to search" />
				<input class="submit" type="submit" name="submit" value="" title="Click to search archives" />     </fieldset>
			</form>
	</div>
<?php } ?>


	<h2><em>Latest Posts</em></h2>
	<ul>
		<?php my_get_recent_posts(0, 10); ?>
	</ul>

	
<!-- comment out this Links section if you have already used the Links templates to make a Links page -->
<?php if (is_home()) { ?>
	<h2><em>Links</em></h2>
	<ul class="links">
	<?php get_links('-1', '<li>', '</li>', '', 0, 'name', 0, 0, -1, 0); ?>
	</ul>
<?php } ?>
<!-- end Links -->


<?php if (is_page("archives") || is_archive() || is_search() || is_single()) { ?>
	<h2><em>Calendar</em></h2>
	<?php get_calendar() ?>
	<?php if (!is_page("archives")) { ?>
		<h2><em>Posts by Month</em></h2>
		<ul class="months">
			<?php get_archives('monthly','','','<li>','</li>',''); ?>
		</ul>
        <br />
	<?php } ?>

	
	<h2><em>Most Recent Posts</em></h2>
	<ul class="posts">
		<?php BX_get_recent_posts($p,10); ?>
	</ul>

	
	<h2><em>Posts by Category</em></h2>
	<ul class="categories">
		<?php wp_list_cats('sort_column=name&hide_empty=0'); ?> 
	</ul>
<?php } ?>


<?php if (is_home() || is_page("archives") || is_archive() || is_search() || is_single()) { ?>
	<h2 class="feeds"><em>Syndication</em></h2>
	<ul class="feeds">
		<li><a href="<?php bloginfo_rss('rss2_url'); ?> ">RSS 2.0</a></li>
		<li><a href="<?php bloginfo_rss('comments_rss2_url'); ?> ">RSS 2.0 + Comments</a></li>       
		<li><a href="<?php bloginfo_rss('rss_url'); ?> ">RSS 0.92</a></li>
		<li><a href="<?php bloginfo_rss('rdf_url'); ?> ">RDF 1.0</a></li>   
        <li><a href="<?php bloginfo('atom_url'); ?> ">Atom 0.3</a></li>	
    </ul>

	
    <h2><em>Powered By</em></h2>
	<ul>
		<li><a href="http://www.wordpress.org">WordPress</a></li>
	</ul>
<?php } ?>


</div> <!-- /subcontent -->