<?php get_header(); ?>

<div id="main">
<div id="info">
<?php /* If this is a 404 page */ if (is_404()) { ?>
			<?php /* If this is a category archive */ } elseif (is_category()) { ?>
			<p>You are currently browsing the archives for the <?php single_cat_title(''); ?> category.</p>

			<?php /* If this is a yearly archive */ } elseif (is_day()) { ?>
			<p>You are currently browsing the <a href="<?php bloginfo('home'); ?>/"><?php echo bloginfo('name'); ?></a> weblog archives
			for the day <?php the_time('l, F jS, Y'); ?>.</p>

			<?php /* If this is a monthly archive */ } elseif (is_month()) { ?>
			<p>You are currently browsing the <a href="<?php bloginfo('home'); ?>/"><?php echo bloginfo('name'); ?></a> weblog archives
			for <?php the_time('F, Y'); ?>.</p>

      <?php /* If this is a yearly archive */ } elseif (is_year()) { ?>
			<p>You are currently browsing the <a href="<?php bloginfo('home'); ?>/"><?php echo bloginfo('name'); ?></a> weblog archives
			for the year <?php the_time('Y'); ?>.</p>

		 <?php /* If this is a monthly archive */ } elseif (is_search()) { ?>
			<p>You have searched the <a href="<?php echo bloginfo('home'); ?>/"><?php echo bloginfo('name'); ?></a> weblog archives
			for <strong>'<?php echo wp_specialchars($s); ?>'</strong>. If you are unable to find anything in these search results, you can try one of these links.</p>

			<?php /* If this is a monthly archive */ } elseif (isset($_GET['paged']) && !empty($_GET['paged'])) { ?>
			<p>You are currently browsing the <a href="<?php echo bloginfo('home'); ?>/"><?php echo bloginfo('name'); ?></a> weblog archives.</p>

			<?php } ?>
</div>

<?php if (have_posts()) : while (have_posts()) : the_post(); ?>
<div class="entrytitle" id="post-<?php the_ID(); ?>"><h2><span class="img_entry"><a href="<?php the_permalink() ?>" rel="bookmark" title="Permanent Link to <?php the_title(); ?>"><?php the_title(); ?></a></span></h2></div>
<div class="entry">
<?php the_content(__('Read more...')); ?>
</div> <!-- Close entry -->
<div class="entrytag">
<div class="floatleft"><span class="img_cat"><?php the_category(', ') ?></span> <span class="img_date"><?php the_time('F dS, Y') ?></span><span class="img_time"><?php the_time('h:i a'); ?></span>  <?php edit_post_link('Edit',' <strong>|</strong> ',' <strong>|</strong>'); ?></div><div class="floatright"><span class="img_comment"><?php comments_popup_link('No Comments', '1 Comment', '% Comments'); ?></span></div>
</div> <!-- Close entry tag -->
<div class="spacerhigh"></div>

<?php endwhile; ?>

<div class="navigation">
	<div class="floatleft"><?php next_posts_link('&laquo; Previous Entries') ?></div>
	<div class="floatright"><?php previous_posts_link('Next Entries &raquo;') ?></div>
</div>

<?php else : ?>

<h2 class="center">Not Found</h2>
	<p class="center">Sorry, but you are looking for something that isn't here.</p>
	<?php include (TEMPLATEPATH . "/searchform.php"); ?>

<?php endif; ?>

</div> <!-- Close main -->
<?php get_sidebar(); ?>
<?php get_footer(); ?>