<?php get_header(); ?>

<div id="wrapper">
	<?php get_sidebar(); ?>

<div id="postbody">
		<?php if (have_posts()) : ?>

		 <?php $post = $posts[0]; // Hack. Set $post so that the_date() works. ?>

	<?php /* If this is a category archive */ if (is_category()) { ?>
		<h3>Archive for '<?php echo single_cat_title(); ?>'</h3>

		<?php /* If this is a daily archive */ } elseif (is_day()) { ?>
		<h3>Archive for <?php the_time('F jS, Y'); ?></h3>

		<?php /* If this is a monthly archive */ } elseif (is_month()) { ?>
		<h3>Archive for <?php the_time('F, Y'); ?></h3>

		<?php /* If this is a yearly archive */ } elseif (is_year()) { ?>
		<h3>Archive for <?php the_time('Y'); ?></h3>

		<?php /* If this is a search */ } elseif (is_search()) { ?>
		<h3>Search Results</h3>

		<?php /* If this is an author archive */ } elseif (is_author()) { ?>
		<h3>Author Archive</h3>

		<?php /* If this is a paged archive */ } elseif (isset($_GET['paged']) && !empty($_GET['paged'])) { ?>
		<h3>Blog Archives</h3>

	<?php } ?>


	<div class="navtop">
			<div class="left"><?php previous_posts_link('<span class="famlst">Newer Posts</span>') ?></div>
			<div class="right"><?php next_posts_link('<span class="famnxt">Older Posts</span>') ?></div>
	</div>

	<?php while (have_posts()) : the_post(); ?>
		<div class="post">
				<h4 id="post-<?php the_ID(); ?>"><a href="<?php the_permalink() ?>" rel="bookmark" title="Permanent Link to <?php the_title(); ?>"><?php the_title(); ?></a></h4>

				<div class="premeta">
					<span class="famdat"><?php the_time('F jS, Y') ?> &ndash; <?php the_time() ?></span>
					<div class="<?php darkcash_tagcat3() ?>"><?php darkcash_tagcat2() ?> <?php the_category(',') ?></div>
				</div>

				<div class="storycontent">
					<?php the_excerpt() ?>
				</div>

				<div class="postmeta">
					<!--<span class="famaut"><?php _e("Posted by:"); ?> <?php the_author() ?></span> | -->
					<?php edit_post_link('<span class="famedt">Edit</span>', '', ' | '); ?>
					<?php comments_popup_link(__('<span class="famcom">Comments: (0)</span>'), __('<span class="famcom">Comments: (1)</span>'), __('<span class="famcom">Comments: (%)</span>')); ?>
				</div>

		</div>
	<?php endwhile; ?>

	<div class="nav">
			<div class="left"><?php previous_posts_link('<span class="famlst">Newer Posts</span>') ?></div>
			<div class="right"><?php next_posts_link('<span class="famnxt">Older Posts</span>') ?></div>
	</div>

	<?php else : ?>

		<h2 class="pagetitle">Not Found</h2>

	<?php endif; ?>

	</div>

	<!--I hate doin' it, but...-->
	<br clear="all" />

</div>

<?php get_footer(); ?>
