<?php if ( !empty($post->post_password) && $_COOKIE['wp-postpass_' . COOKIEHASH] != $post->post_password) : ?>
<p><?php _e('Enter your password to view comments.'); ?></p>
<?php return; endif; ?>

<h4 id="comments"><?php comments_number(__('No Comments'), __('1 Comment'), __('% Comments')); ?></h4> 

<span class="noprint">
<?php if ( comments_open() ) : ?>
	&raquo; <a href="#postcomment" title="<?php _e("Leave a comment"); ?>">Leave a comment now</a>
<?php endif; ?>
<p>&raquo; <?php comments_rss_link(__('<abbr title="Really Simple Syndication">RSS</abbr> feed for comments on this post')); ?><br />
<?php if ( pings_open() ) : ?>
	&raquo; <a href="<?php trackback_url() ?>" rel="trackback"><?php _e('TrackBack <abbr title="Uniform Resource Identifier">URI</abbr>'); ?></a>
<?php endif; ?>
</p>
</span>


<?php if ( $comments ) : ?>
<ol id="commentlist">

<?php foreach ($comments as $comment) : ?>
	<li id="comment-<?php comment_ID() ?>"><span class="postnumber noprint"><?php printf("%0d", ++$commentNr);?></span>
	<div class="commenttext"><?php comment_text() ?></div>
	<p><cite><?php comment_type(__('Comment'), __('Trackback'), __('Pingback')); ?> <?php _e('made by'); ?> <?php comment_author_link() ?> <?php _e('on'); ?> <?php comment_date() ?> @ <a href="#comment-<?php comment_ID() ?>"><?php comment_time() ?></a></cite><?php edit_comment_link(__("<span class=famedt>Edit Comment</span>"), '<br />'); ?></p>
	</li>

<?php endforeach; ?>

</ol>

<?php else : // If there are no comments yet ?>
	<p><?php _e('No comments yet.'); ?></p>
<?php endif; ?>

<div class="noprint">

<br />

<?php if ( comments_open() ) : ?>
<h4 id="postcomment"><?php _e('Leave a Comment'); ?></h4>

<?php if ( get_option('comment_registration') && !$user_ID ) : ?>
<p>You must be <a href="<?php echo get_option('siteurl'); ?>/wp-login.php?redirect_to=<?php the_permalink(); ?>">logged in</a> to post a comment.</p>
<?php else : ?>

<form action="<?php echo get_option('siteurl'); ?>/wp-comments-post.php" method="post" id="commentform">

<fieldset>
	<ol>

<?php if ( $user_ID ) : ?>

<li>&raquo; Logged in as <a href="<?php echo get_option('siteurl'); ?>/wp-admin/profile.php"><?php echo $user_identity; ?></a><br />
&raquo; <a href="<?php echo get_option('siteurl'); ?>/wp-login.php?action=logout" title="<?php _e('Log out of this account') ?>">Logout</a></li>

<?php else : ?>

		<li><label for="author">Name <?php if ($req) _e('<em>*</em>'); ?></label>
		<input type="text" name="author" id="author" value="<?php echo $comment_author; ?>" size="22" tabindex="1" /></li>
		
		<li><label for="email">Mail <?php if ($req) _e('<em>*</em>'); ?> <small>(will not be published)</small></label>
		<input type="text" name="email" id="email" value="<?php echo $comment_author_email; ?>" size="22" tabindex="2" /></li>
		
		<li><label for="url">Website</label>
		<input type="text" name="url" id="url" value="<?php echo $comment_author_url; ?>" size="22" tabindex="3" /></li>

<?php endif; ?>

		<li><blockquote class="tags"><p><small><strong>XHTML:</strong> You can use these tags: <?php echo allowed_tags(); ?></small></p></blockquote></li>

		<li><textarea name="comment" id="comment" cols="100%" rows="10" tabindex="4"></textarea></li>
		
		<li><input class="button" name="submit" type="submit" id="submit" tabindex="5" value="Submit Comment" />
		<input type="hidden" name="comment_post_ID" value="<?php echo $id; ?>" /></li>
	</ol>
</fieldset>
<?php do_action('comment_form', $post->ID); ?>

</form>

<?php endif; // If registration required and not logged in ?>

<?php else : // Comments are closed ?>
<p><?php _e('Sorry, the comment form is closed at this time.'); ?></p>
<?php endif; ?>
</div>
