<?php
/*
Template Name: Termine
Theme: dKret
Basis: page.php
Author: J. Kretzschmar
Author URI: http://diekretzschmars.de/
*/
?>

<?php get_header(); ?>

<!-- blog content -->
<div id="content">

<!--page.php static page-->

<!--start loop-->
    <?php if (have_posts()) : while (have_posts()) : the_post(); ?>

    <div id="post-<?php the_ID(); ?>">
    <?php if (function_exists('enp_edit_link')) { enp_edit_link('<img class="editLink" src="'.get_bloginfo(template_directory).'/images/pencil.gif" alt="'.__('Edit Link','dkret').'" />','<span class="editlink" title="'.__('Edit Post','dkret').'">','</span>'); }
    else { edit_post_link('<img class="editLink" src="'.get_bloginfo(template_directory).'/images/pencil.gif" alt="'.__('Edit Link','dkret').'" />','<span class="editlink" title="'.__('Edit Post','dkret').'">','</span>'); } ?>
		<h2><?php the_title(); ?></h2>
		
		<!--content-->

<?php // ec3_get_events function EDITED

  $limit='';
  $template_event='%DATE%: <a href="%LINK%">%TITLE% (%TIME%)</a>';
  $template_event_notime='%DATE%: <a href="%LINK%">%TITLE%</a>';
  $template_event_end='%DATE%: <a href="%LINK%">%TITLE% (%TIME%-%END_TIME%)</a>';
  $template_multiday_event='%DATE% - %END_DATE%: <a href="%LINK%">%TITLE%</a>';
  $template_day  ='';
  $date_format   ='D, d.m';
  $template_month='%MONTH%:';
  $month_format  ='F Y';

  if(!ec3_check_installed(__('Upcoming Events','ec3')))
    return;
  global $ec3,$wpdb,$wp_version;

  // Parse $limit:
  //  NUMBER      - limits number of posts
  //  NUMBER days - next NUMBER of days
  if(empty($limit))
  {
    $limit_numposts='';
  }
  elseif(preg_match('/^ *([0-9]+) *d(ays?)?/',$limit,$matches))
  {
    $secs=intval($matches[1])*24*3600;
    $and_before="AND start<='".ec3_strftime('%Y-%m-%d',time()+$secs)."'";
  }
  elseif(intval($limit)<1)
  {
    $limit_numposts='LIMIT 5';
  }
  else
  {
    $limit_numposts='LIMIT '.intval($limit);
  }
  
  if(!$date_format)
      $date_format=get_settings('date_format');

  // Find the upcoming events.
  $calendar_entries = $wpdb->get_results(
    "SELECT DISTINCT
       p.id AS id,
       post_title,
       start,
       end,
       u.$ec3->wp_user_nicename AS author,
       allday
     FROM $ec3->schedule s
     LEFT JOIN $wpdb->posts p ON s.post_id=p.id
     LEFT JOIN $wpdb->users u ON p.post_author = u.id
     WHERE p.post_status='publish'
       AND end>='$ec3->today' $and_before
     ORDER BY start $limit_numposts"
  );

  echo "<ul class='ec3_events'>";
  echo "<!-- Generated by Event Calendar v$ec3->version -->\n";
  if($calendar_entries)
  {
    $time_format=get_settings('time_format');
    $current_month=false;
    $current_date=false;
    $data=array();
    foreach($calendar_entries as $entry)
    {

      // To use %SINCE%, you need Dunstan's 'Time Since' plugin.
      if(function_exists('time_since'))
          $data['SINCE']=time_since( time(), ec3_to_time($entry->start) );

      // Month changed?
      $data['MONTH']=mysql2date($month_format,$entry->start);

      if((!$current_month || $current_month!=$data['MONTH']) && $template_month)
      {
        if($current_date)
            echo "</ul></li>\n";
        if($current_month)
            echo "</ul></li>\n";
        echo "<li class='ec3_list ec3_list_month'>"
        .    ec3_format_str($template_month,$data)."\n<ul>\n";
        $current_month=$data['MONTH'];
        $current_date=false;
      }

      // Date changed?
      $data['DATE'] =mysql2date($date_format, $entry->start);
      $data['END_DATE'] =mysql2date($date_format, $entry->end);
      if((!$current_date || $current_date!=$data['DATE']) && $template_day)
      {
        if($current_date)
            echo "</ul></li>\n";
        echo "<li class='ec3_list ec3_list_day'>"
        .    ec3_format_str($template_day,$data)."\n<ul>\n";
        $current_date=$data['DATE'];
      }

      if($entry->allday) {
          $data['TIME']=__('all day','ec3');
          $data['END_TIME']=__('all day','ec3');
      }

      else {
          $data['TIME']=mysql2date($time_format,$entry->start);
          $data['END_TIME']=mysql2date($time_format,$entry->end);
      }

      $data['TITLE'] =$entry->post_title;
      $data['LINK']  =get_permalink($entry->id);
      $data['AUTHOR']=$entry->author;

      if ($data['DATE'] != $data['END_DATE'])  
        echo " <li>".ec3_format_str($template_multiday_event,$data)."</li>\n";
      
      elseif (($data['TIME'] == $data['END_TIME']) && $data['TIME'] != '00:00') 
        echo " <li>".ec3_format_str($template_event,$data)."</li>\n";

      elseif (($data['TIME'] == $data['END_TIME']) && $data['TIME'] == '00:00') 
        echo " <li>".ec3_format_str($template_event_notime,$data)."</li>\n";

      elseif ($data['TIME'] != $data['END_TIME'])
      echo " <li>".ec3_format_str($template_event_end,$data)."</li>\n";
    
      
    }
    if($current_date)
        echo "</ul></li>\n";
    if($current_month)
        echo "</ul></li>\n";
  }
  else
  {
    echo "<li>".__('No events.','ec3')."</li>\n";
  }
  echo "</ul>\n"; ?>



				<?php the_content(__('(more...)','dkret')); ?>

				<?php link_pages('<p><strong>'.__('Pages:','dkret').'</strong> ', '</p>', 'number'); ?>

		    <?php if (function_exists('jkeywords_post_tags')) { ?>
    		<em class="tags"><span class="tag" title="Tags"><?php jkeywords_post_tags(); ?></span></em>
        <?php } ?>

    </div>

	  <?php endwhile; endif; ?>

<!--comments-->
<?php comments_template(); ?>
	  
<!--page.php end-->

<!-- Blog content end-->
</div>

<?php get_sidebar(); ?>

<?php get_footer(); ?>
