<?php get_header(); ?>

<!-- Blog content -->
<div id="content">
	
	<h2><?php _e('My Books','dkret'); ?></h2>
	
	<?php if( can_now_reading_admin() ) : ?>
		
		<p><?php _e('Admin','dkret'); ?>: &raquo; <a href="<?php manage_library_url() ?>"><?php _e('Manage Books','dkret'); ?></a></p>
		
	<?php endif; ?>
		
	<?php if( have_books('status=reading&num=-1') ) : ?>
		<h3><?php _e('Current','dkret'); ?> (<?php echo total_books('reading', 0) ?>):</h3>
	
		<?php while( have_books('status=reading&num=-1') ) : the_book(); ?>
			
				<p><a href="<?php book_permalink() ?>"><img class="i_left" src="<?php book_image() ?>" alt="<?php book_title() ?>" /></a></p>
				<p><a href="<?php book_permalink() ?>"><?php book_title() ?></a> <br /><?php _e('By','dkret'); ?> <a href="<?php book_author_permalink() ?>"><?php book_author() ?></a></p>
			
		<?php endwhile; ?>
		
	<?php endif; ?>


	<?php if( have_books('status=unread&num=-1') ) : ?>

    <h3><?php _e('Planned Books','dkret'); ?> (<?php echo total_books('unread', 0) ?>):</h3>
	
		<ul>
			<?php while( have_books('status=unread&num=-1') ) : the_book(); ?>
        <li><a href="<?php book_permalink() ?>"><?php book_title() ?></a> by <a href="<?php book_author_permalink() ?>"><?php book_author() ?></a></li>
			<?php endwhile; ?>
		</ul>
		
	<?php endif; ?>
		

	<?php if( have_books('status=read&orderby=finished&order=desc&num=-1') ) : ?>
    <h3><?php _e('Recent Books','dkret'); ?> (<?php echo total_books('read', 0) ?>):</h3>
		
		<ul>
			<?php while( have_books('status=read&orderby=finished&order=desc&num=-1') ) : the_book(); ?>
        <li><a href="<?php book_permalink() ?>"><?php book_title() ?></a> <br /><?php _e('By','dkret'); ?> <a href="<?php book_author_permalink() ?>"><?php book_author() ?></a></li>
			<?php endwhile; ?>
		</ul>
		
	<?php endif; ?>
		
	<p class="space"><?php do_action('nr_footer'); ?></p>
		
</div>

<?php get_sidebar() ?>

<?php get_footer() ?>
