<?php get_header(); global $nr_id; ?>

<!-- Blog content -->
<div id="content">

  <?php if( have_books(intval($nr_id)) ) : ?>
	
		<?php while ( have_books(intval(nr_id)) ) : the_book(); ?>

		<p><a href="<?php library_url() ?>">&larr; <?php _e('Back to Library','dkret'); ?></a></p>
		
		<h2><?php book_title() ?></h2>
		<p>By <a href="<?php book_author_permalink() ?>"><?php book_author() ?></a></p>

		<?php if( can_now_reading_admin() ) : ?>
		<p><?php _e('Admin','dkret'); ?>: &raquo; <a href="<?php manage_library_url() ?>"><?php _e('Manage Books','dkret'); ?></a> &raquo; <a href="<?php book_edit_url() ?>"><?php _e('Edit this Book','dkret'); ?></a></p>
		<?php endif; ?>
		
    <br />
		
		<p>
			<a href="<?php book_url() ?>" title="<?php _e("This Book's Amazon detail page",'dkret'); ?>"><img class="i_left" src="<?php book_image() ?>" alt="<?php book_title() ?>" /></a>
		</p>
		
		<?php if( book_has_post() ): ?>
			<p>This book is linked with the post <a href="<?php book_post_url() ?>">&ldquo;<?php book_post_title() ?>&rdquo;</a>.</p>
		<?php endif; ?>
		
		<dl>
			<dt><?php _e('Startet reading:','dkret'); ?></dt>
			<dd><?php book_started() ?></dd>
			
			<dt><?php _e('Finished Reading:','dkret'); ?></dt>
			<dd><?php book_finished() ?></dd>
			
			<?php print_book_meta(0); ?>

		</dl>
		
		<div class="review">

			<h3><?php _e('Review','dkret'); ?></h3>
			
			<p><strong><?php _e('Rating:','dkret'); ?></strong> <?php book_rating() ?></p>
			
			<?php book_review() ?>
			
		</div>
		
		<?php endwhile; ?>
		
	<?php else : ?>
		
		<p><?php _e("That book doesn't exist!",'dkret'); ?>.</p>
		
	<?php endif; ?>
	
	<p class="space"><?php do_action('nr_footer'); ?></p>
		
</div>

	
	<?php get_sidebar(); ?>
	
  <?php get_footer(); ?>
