<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">

<head profile="http://gmpg.org/xfn/11">
	<meta http-equiv="Content-Type" content="<?php bloginfo('html_type'); ?>; charset=<?php bloginfo('charset'); ?>" />

	<title><?php bloginfo('name'); ?> <?php if ( is_single() ) { ?> &raquo; Blog Archive <?php } ?> <?php wp_title(); ?></title>
	
	<meta name="generator" content="WordPress <?php bloginfo('version'); ?>" /> <!-- leave this for stats -->

	<link rel="stylesheet" href="<?php bloginfo('stylesheet_url'); ?>" type="text/css" media="screen" />
	<link rel="alternate" type="application/rss+xml" title="RSS 2.0" href="<?php bloginfo('rss2_url'); ?>" />
	<link rel="alternate" type="text/xml" title="RSS .92" href="<?php bloginfo('rss_url'); ?>" />
	<link rel="alternate" type="application/atom+xml" title="Atom 0.3" href="<?php bloginfo('atom_url'); ?>" />
	<link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />

	<?php wp_get_archives('type=monthly&format=link'); ?>

	<?php wp_head(); ?>
</head>
<body>

<div id="page">


<div id="header">
    <h1><a href="<?php echo get_settings('home'); ?>"><em><?php bloginfo('name'); ?></em></a></h1>
    <div id="menu">
<?php
$menu = <<<MENU
	<div class="nav">
		<ul>
                  <li id="skip"><a href="#content" accesskey="1">Skip to Content</a></li>
		  <li><a href="/" accesskey="2">Home</a></li>
		  <li><a href="#" accesskey="3">About</a></li>
		  <li><a href="#" accesskey="4">Archives</a></li>
		  <li><a href="#" accesskey="5">Contact</a></li>
		</ul>
	</div>
MENU;

$lines = split("\n", $menu);
foreach ($lines as $line) {
    $current = false;
    preg_match('/href="([^"]+)"/', $line, $url);
    if (substr($_SERVER["REQUEST_URI"], 0, 5) == substr($url[1], 0, 5)) {
        $line = str_replace('<a h', '<a id="current" h', $line);
        }
    echo $line."\n";
}
?>
            <div class="box">
                <p><strong><a href="<?php bloginfo('rss2_url'); ?>">Subscribe to <?php bloginfo('name'); ?>!</a> :</strong> <a href="<?php bloginfo('rss_url'); ?>" title="Subscribe to this site using RSS">RSS</a> &amp; <a href="<?php bloginfo('atom_url'); ?>" title="Subscribe to this site using Atom">Atom</a></p>
            </div>

        </div>
</div>
