<?php get_header(); ?>
<?php if (have_posts()) : ?>
<h2 class="headline">Search results</h2>
<div class="page-navigation">
  <div class="alignleft">
    <?php next_posts_link('Previous articles') ?>
  </div>
  <div class="alignright">
    <?php previous_posts_link('Next articles') ?>
  </div>
</div>
<?php while (have_posts()) : the_post(); ?>
<div class="post" id="post-<?php the_ID(); ?>">
  <div class="data">
    <?php the_time('F jS, Y') ?>
  </div>
  <h3 class="title"> <a href="<?php the_permalink() ?>" rel="bookmark" title="<?php the_title(); ?>">
    <?php the_title(); ?>
    </a></h3>
  <div class="author">Posted 
    in
    <?php the_category(', ') ?>
    by
    <?php the_author() ?>
    <?php edit_post_link('Edit','&nbsp;|&nbsp;',''); ?>
  </div>
  <?php the_content('More'); ?>
  <?php wp_link_pages(); ?>
  <div class="feedback">
    <?php comments_popup_link(__('comments'), __('1 comments'), __('% comments'), '', __('comments off')); ?>
    <span class="link-category">See also in
    <?php the_category(', ') ?>
    </span> </div>
</div>
<?php endwhile; ?>
<div class="page-navigation">
  <div class="alignleft">
    <?php next_posts_link('Previous articles') ?>
  </div>
  <div class="alignright">
    <?php previous_posts_link('Next articles') ?>
  </div>
</div>
<?php else : ?>
<div class="post">
<h2>No posts found! Try a different search?</h2>
<?php include (TEMPLATEPATH . '/searchform.php'); ?>
</div>
<?php endif; ?>
<?php get_footer(); ?>