<?php
/*
Plugin Name: Dunstan's Time of day
Plugin URI: http://www.ifelse.co.uk/archives/2004/08/17/time-of-day-plugin-v1/
Description: A WP plugin based on Dunstan's Time of Day code (http://1976design.com/blog/archive/2004/07/23/redesign-time-presentation/). <br/><strong>Usage</strong>: time_of_day(abs(strtotime($post->post_date))); <br/> Inputs are unix timestamps
Version: 1.0 beta
Author: Phu Ly & Dunstan Orchard & Michael Heilemann
Author URI: http://www.ifelse.co.uk
*/

// inputs must be unix timestamp (seconds)
function inner_time_of_day($pdate){
	global $wpdb, $tableposts;
	$hour=date('H',$pdate);
	switch($hour)
		{
		case 0:
		case 1:
		case 2:
			$tod = 'in the wee hours';
			break;
		case 3:
		case 4:
		case 5:
		case 6:
			$tod = 'terribly early in the morning';
			break;
		case 7:
		case 8:
		case 9:
			$tod = 'in the early morning';
			break;
		case 10:
			$tod = 'mid-morning';
			break;
		case 11:
			$tod = 'just before lunchtime';
			break;
		case 12:
		case 13:
			$tod = 'around lunchtime';
			break;
		case 14:
			$tod = 'in the early afternoon';
			break;
		case 15:
		case 16:
			$tod = 'mid-afternoon';
			break;
		case 17:
			$tod = 'in the late afternoon';
			break;
		case 18:
		case 19:
			$tod = 'in the early evening';
			break;
		case 20:
		case 21:
			$tod = 'at around evening time';
			break;
		case 22:
			$tod = 'in the late evening';
			break;
		case 23:
			$tod = 'late at night';
			break;
		default:
			$tod = '';
			break;
		}
	//return $tod;
	echo $tod;
	}
?>
<?php 
	get_header();

	if ($posts) { $pcount_lp = sizeof($posts); foreach ($posts as $post) {start_wp();?>
	<div class="entry">
		<?php 
			the_date('','<h2 class="entrydate">','</h2>');
			
		?>
		<h3 class="entrytitle" id="post-<?php the_ID(); ?>"><a href="<?php echo get_permalink() ?>" rel="bookmark" title="Permanent Link: <?php the_title(); ?>"><?php the_title(); ?></a></h3>
	<div class="entrybody">
		<strong><?php the_author() ?> wrote this <?php inner_time_of_day(abs(strtotime($post->post_date))); ?>:</strong> 
		<?php the_content();?>
		<p class="comments_link"><img src="<?php bloginfo('stylesheet_directory'); ?>/images/file.gif" title="file" alt="*" /> 
		<?php _e("Filed under:"); ?> <?php the_category(',') ?><br/>
		<?php 
			$comments_img_link = '<img src="' . get_stylesheet_directory_uri() . '/images/comments.gif"  title="comments" alt="*" />';
			comments_popup_link('No Comments', $comments_img_link . ' 1 Comment', $comments_img_link . ' % Comments'); 
		?>
		</p>
		<?php 
			if ($pcount_lp == 1){
			comments_template();
		} ?>
	</div>
</div>
<?php }?>
<?php } else { // end foreach, end if any posts ?>
<div class="entrybody"><p>Sorry, no posts matched your criteria.</p></div>
<?php } ?>
</div>
<?php get_sidebar(); ?>
<?php get_footer(); ?>